<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Veritabanı bağlantısı
include 'config.php'; // Veritabanı bağlantı dosyanızı dahil edin

// Authorization header'dan token'i al
$headers = apache_request_headers();

// CORS kontrolü
$allowedOrigin = 'gatesofbet9131.com';
if (isset($headers['Origin']) && parse_url($headers['Origin'], PHP_URL_HOST) !== $allowedOrigin) {
    http_response_code(403); // Yetkisiz
    echo json_encode(["error" => "Geçersiz domain"]);
    exit();
}

// Cron job kontrolü için özel bir header
$isCronJob = isset($headers['X-Cron-Job']) && $headers['X-Cron-Job'] === 'true';

// Eğer cron job değilse, sadece CORS kontrolü yap
if (!$isCronJob) {
    // Burada isterseniz başka bir kontrol ekleyebilirsiniz
}

// Kullanıcı verilerini çek
$queryKullanicilar = "SELECT id, username, created_at, ana_bakiye, bonus_code FROM blacrhdy_bet1.kullanicilar"; // Kullanıcı bilgilerini çekiyoruz
$resultKullanicilar = $db->query($queryKullanicilar);

$users = [];
if ($resultKullanicilar->rowCount() > 0) {
    $users = $resultKullanicilar->fetchAll(PDO::FETCH_ASSOC); // Tüm kullanıcıları al
}

// Yatırma işlemlerini çek
$queryParayatir = "SELECT user_id AS uye, tur AS banka, miktar, tarih 
                   FROM blacrhdy_bet1.parayatir"; // Tüm yatırma işlemlerini çekiyoruz
                   
$resultParayatir = $db->query($queryParayatir);

$yatirilanlar = [];
if ($resultParayatir->rowCount() > 0) {
    $yatirilanlar = $resultParayatir->fetchAll(PDO::FETCH_ASSOC); // Tüm yatırma işlemlerini al
}


// Çekme işlemlerini çek
$queryParacek = "SELECT uye, banka, miktar, tarih, durum FROM blacrhdy_bet1.paracek"; // Tüm çekme işlemlerini çekiyoruz
$resultParacek = $db->query($queryParacek);
$cekilenler = [];
if ($resultParacek->rowCount() > 0) {
    $cekilenler = $resultParacek->fetchAll(PDO::FETCH_ASSOC); // Tüm çekme işlemlerini al
}

// JSON formatında döndür
header('Content-Type: application/json');
echo json_encode([
    'kullanicilar' => $users,
    'yatirilanlar' => $yatirilanlar,
    'cekilenler' => $cekilenler,
]);
?>
