<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../inc/database.php';

$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name = trim($_POST['last_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone_number = trim($_POST['phone_number'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $company = trim($_POST['company'] ?? '');
    $website = trim($_POST['website'] ?? '');
    $telegram_channel = trim($_POST['telegram_channel'] ?? '');
    $instagram = trim($_POST['instagram'] ?? '');
    $tiktok = trim($_POST['tiktok'] ?? '');
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';
    if ($first_name && $last_name && $email && $phone_number && $username && $password && $password_confirm) {
        if ($password !== $password_confirm) {
            $error_message = 'Şifreler uyuşmuyor.';
        } elseif (strlen($password) < 6) {
            $error_message = 'Şifre en az 6 karakter olmalıdır.';
        }
    }
    if (empty($error_message) && $first_name && $last_name && $email && $phone_number && $username) {
        $stmt = $pdo->prepare('INSERT INTO affiliate_applications (first_name, last_name, email, phone_number, username, company, website, telegram_channel, instagram, tiktok, status, created_at) VALUES (:fn, :ln, :em, :ph, :un, :co, :ws, :tg, :ig, :tt, :st, NOW())');
        $stmt->bindValue(':fn', $first_name);
        $stmt->bindValue(':ln', $last_name);
        $stmt->bindValue(':em', $email);
        $stmt->bindValue(':ph', $phone_number);
        $stmt->bindValue(':un', $username);
        $stmt->bindValue(':co', $company);
        $stmt->bindValue(':ws', $website);
        $stmt->bindValue(':tg', $telegram_channel);
        $stmt->bindValue(':ig', $instagram);
        $stmt->bindValue(':tt', $tiktok);
        $stmt->bindValue(':st', 'Beklemede');
        try {
            $stmt->execute();
            // Kullanıcı hesabını "Beklemede" durumuyla oluştur
            $referans_kodu = rand(100000, 999999);
            $hash = password_hash($password, PASSWORD_BCRYPT);
            // Çakışma kontrolü: aynı kullanıcı adı veya email varsa atla
            $check = $pdo->prepare('SELECT id FROM kullanici2 WHERE kullanici_adi = :un OR email = :em LIMIT 1');
            $check->bindValue(':un', $username);
            $check->bindValue(':em', $email);
            $check->execute();
            $exists = $check->fetch();
            if (!$exists) {
                $ins = $pdo->prepare('INSERT INTO kullanici2 (kullanici_adi, sifre, email, commission_rate, referans_kodu, created_at, updated_at, role, durum) VALUES (:un, :pw, :em, :cr, :rk, NOW(), NOW(), :rl, :dm)');
                $ins->bindValue(':un', $username);
                $ins->bindValue(':pw', $hash);
                $ins->bindValue(':em', $email);
                $ins->bindValue(':cr', 0.10);
                $ins->bindValue(':rk', $referans_kodu);
                $ins->bindValue(':rl', 'user');
                $ins->bindValue(':dm', 'Beklemede');
                $ins->execute();
            }
            $success_message = 'Başvurunuz alınmıştır. Onaylandığında giriş yapabilirsiniz.';
        } catch (Throwable $e) { $error_message = 'Hata: ' . htmlspecialchars($e->getMessage()); }
    } else {
        $error_message = 'Zorunlu alanları doldurunuz.';
    }
}
?>
<?php include __DIR__ . '/../inc/head.php'; ?>
<?php include __DIR__ . '/../inc/header.php'; ?>
<style>
  body{background:#000 !important;color:#fff}
  .centerWrap{background:#000 !important}
  .container-fluid{background:#000 !important}
</style>
<div class="centerWrap">
  <div class="container-fluid" style="max-width:780px;padding:24px 12px;">
    <ul class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
      <li class="breadcrumb-item" aria-current="page">Affiliate Başvurusu</li>
    </ul>
    <div class="card" style="background:#0b0b0b;border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">
        <h5 class="card-title">Affiliate Başvuru Formu</h5>
        <?php if (!empty($success_message)) { ?><div class="alert alert-success" role="alert"><?php echo htmlspecialchars($success_message); ?></div><?php } ?>
        <?php if (!empty($error_message)) { ?><div class="alert alert-danger" role="alert"><?php echo htmlspecialchars($error_message); ?></div><?php } ?>
        <form method="POST" action="">
          <div class="row">
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Ad</label><input name="first_name" class="form-control" type="text" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Soyad</label><input name="last_name" class="form-control" type="text" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">E-posta</label><input name="email" class="form-control" type="email" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Telefon</label><input name="phone_number" class="form-control" type="text" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Kullanıcı Adı</label><input name="username" class="form-control" type="text" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Şifre</label><input name="password" class="form-control" type="password" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Şifreyi Doğrula</label><input name="password_confirm" class="form-control" type="password" required></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Şirket</label><input name="company" class="form-control" type="text"></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Web Sitesi</label><input name="website" class="form-control" type="url"></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Telegram Kanalı</label><input name="telegram_channel" class="form-control" type="text"></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">Instagram</label><input name="instagram" class="form-control" type="text"></div></div>
            <div class="col-md-6"><div class="form-group"><label class="col-form-label">TikTok</label><input name="tiktok" class="form-control" type="text"></div></div>
          </div>
          <div class="text-right"><button class="btn btn-primary" type="submit">Başvuru Gönder</button></div>
        </form>
      </div>
    </div>
  </div>
  <style>#menu-toggle{display:none !important}</style>
</div>