<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../inc/database.php';

$message = '';
$alertType = '';

try { $pdo->exec("ALTER TABLE kullanici2 ADD COLUMN IF NOT EXISTS reset_token VARCHAR(255) DEFAULT NULL"); } catch (Throwable $e) {}
try { $pdo->exec("ALTER TABLE kullanici2 ADD COLUMN IF NOT EXISTS reset_token_expires DATETIME DEFAULT NULL"); } catch (Throwable $e) {}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim(strtolower($_POST['email'] ?? ''));
    if ($email !== '') {
        $stmt = $pdo->prepare('SELECT id, kullanici_adi FROM kullanici2 WHERE LOWER(email) = :em LIMIT 1');
        $stmt->bindValue(':em', $email);
        $stmt->execute();
        $row = $stmt->fetch();
        if ($row) {
            $token = bin2hex(random_bytes(32));
            $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));
            $upd = $pdo->prepare('UPDATE kullanici2 SET reset_token = :t, reset_token_expires = :e WHERE id = :id');
            $upd->bindValue(':t', $token);
            $upd->bindValue(':e', $expires);
            $upd->bindValue(':id', $row['id'], PDO::PARAM_INT);
            if ($upd->execute()) {
                $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
                $resetLink = $scheme . '://' . $_SERVER['HTTP_HOST'] . '/affiliate/reset_password.php?token=' . $token;
                require_once __DIR__ . '/../inc/send_mail.php';
                $subject = 'Affiliate Şifre Sıfırlama';
                $message_body = '<p>Şifrenizi sıfırlamak için aşağıdaki bağlantıya tıklayın:</p><p><a href="' . $resetLink . '">Şifremi Sıfırla</a></p><p>Bağlantı 1 saat geçerlidir.</p>';
                if (send_mail($email, $subject, $message_body)) {
                    $message = 'Şifre sıfırlama bağlantısı e-posta adresinize gönderildi.';
                    $alertType = 'success';
                } else {
                    $message = 'E-posta gönderilirken hata oluştu. Lütfen daha sonra tekrar deneyin.';
                    $alertType = 'danger';
                }
                $devMessage = 'Geliştirme: <a href="' . htmlspecialchars($resetLink) . '">' . htmlspecialchars($resetLink) . '</a>';
            } else {
                $message = 'İşlem sırasında bir hata oluştu.';
                $alertType = 'danger';
            }
        } else {
            $message = 'Bu e-posta ile kayıtlı affiliate hesabı bulunamadı.';
            $alertType = 'danger';
        }
    }
}
?>
<?php include __DIR__ . '/../inc/head.php'; ?>
<?php include __DIR__ . '/../inc/header.php'; ?>
<style>
  body{background:#000 !important;color:#fff}
  .centerWrap{background:#000 !important}
  .container-fluid{background:#000 !important}
</style>
<div class="centerWrap">
  <div class="container-fluid" style="max-width:520px;padding:24px 12px;">
    <ul class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
      <li class="breadcrumb-item" aria-current="page">Affiliate Şifremi Unuttum</li>
    </ul>
    <div class="card" style="background:#0b0b0b;border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">
        <h5 class="card-title">Şifremi Unuttum</h5>
        <?php if (!empty($message)) { ?><div class="alert alert-<?php echo $alertType; ?>"><?php echo $message; ?></div><?php } ?>
        <form method="POST" action="">
          <div class="form-group">
            <label class="col-form-label">E-posta Adresiniz</label>
            <input name="email" class="form-control" type="email" required>
          </div>
          <div class="text-right"><button class="btn btn-primary" type="submit">Bağlantı Gönder</button></div>
        </form>
      </div>
    </div>
  </div>
  <style>#menu-toggle{display:none !important}</style>
</div>