<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../inc/database.php';

$username_error = '';
$password_error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $username_input = trim($_POST['username'] ?? '');
    $password_input = $_POST['password'] ?? '';
    $stmt = $pdo->prepare('SELECT id, kullanici_adi, sifre, referans_kodu, commission_rate, durum FROM kullanici2 WHERE kullanici_adi = :u LIMIT 1');
    $stmt->bindValue(':u', $username_input, PDO::PARAM_STR);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
        if (password_verify($password_input, $row['sifre'])) {
            if (isset($row['durum']) && $row['durum'] !== 'Onaylandı') {
                $password_error = 'Başvurunuz henüz onaylanmadı.';
            } else {
            if (session_status() === PHP_SESSION_ACTIVE && !headers_sent()) { session_regenerate_id(true); }
            $_SESSION['affiliate_logged_in'] = true;
            $_SESSION['affiliate_user_id'] = $row['id'];
            $_SESSION['affiliate_username'] = $row['kullanici_adi'];
            $_SESSION['affiliate_referans_kodu'] = $row['referans_kodu'] ?? null;
            $_SESSION['affiliate_commission_rate'] = $row['commission_rate'] ?? null;
            header('Location: /profile/referral');
            exit;
            }
        } else {
            $password_error = 'Yanlış şifre!';
        }
    } else {
        $username_error = 'Kullanıcı bulunamadı!';
    }
}
?>
<?php include __DIR__ . '/../inc/head.php'; ?>
<?php include __DIR__ . '/../inc/header.php'; ?>
<style>
  body{background:#000 !important;color:#fff}
  .centerWrap{background:#000 !important}
  .container-fluid{background:#000 !important}
</style>
<div class="centerWrap">
  <div class="container-fluid" style="max-width:520px;padding:24px 12px;">
    <ul class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
      <li class="breadcrumb-item" aria-current="page">Affiliate Giriş</li>
    </ul>
    <div class="card" style="background:#0b0b0b;border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">
        <h5 class="card-title">Affiliate Giriş</h5>
        <form method="POST" action="">
          <div class="form-group">
            <input name="username" class="form-control" type="text" placeholder="Kullanıcı Adı" required>
            <?php if (!empty($username_error)) { ?><div class="text-danger"><?php echo htmlspecialchars($username_error); ?></div><?php } ?>
          </div>
          <div class="form-group">
            <input name="password" class="form-control" type="password" placeholder="Şifre" required>
            <?php if (!empty($password_error)) { ?><div class="text-danger"><?php echo htmlspecialchars($password_error); ?></div><?php } ?>
            <div class="text-right mt-2"><a href="/affiliate/forgot_password.php" class="text-muted" style="font-size:.9rem">Şifremi Unuttum?</a></div>
          </div>
          <div class="text-right">
            <button class="btn btn-primary" type="submit" name="login">Giriş</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <style>#menu-toggle{display:none !important}</style>
  <script>document.addEventListener('DOMContentLoaded',function(){var s=document.getElementById('g5-sidebar');if(s){s.style.display='none';}});</script>
  
</div>