<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../inc/database.php';

$token = $_GET['token'] ?? '';
$message = '';
$alertType = '';
$valid = false;
$userId = null;

if ($token) {
    $stmt = $pdo->prepare('SELECT id, reset_token_expires FROM kullanici2 WHERE reset_token = :t LIMIT 1');
    $stmt->bindValue(':t', $token);
    $stmt->execute();
    $row = $stmt->fetch();
    if ($row) {
        if (!empty($row['reset_token_expires']) && strtotime($row['reset_token_expires']) > time()) {
            $valid = true; $userId = (int)$row['id'];
        } else {
            $message = 'Bağlantı süresi dolmuş.'; $alertType = 'danger';
        }
    } else { $message = 'Geçersiz bağlantı.'; $alertType = 'danger'; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['token'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['password_confirm'] ?? '';
    if ($password !== $confirm) { $message = 'Şifreler uyuşmuyor.'; $alertType = 'danger'; }
    elseif (strlen($password) < 6) { $message = 'Şifre en az 6 karakter olmalıdır.'; $alertType = 'danger'; }
    else {
        $stmt = $pdo->prepare('SELECT id FROM kullanici2 WHERE reset_token = :t AND reset_token_expires > NOW() LIMIT 1');
        $stmt->bindValue(':t', $token);
        $stmt->execute();
        $row = $stmt->fetch();
        if ($row) {
            $hash = password_hash($password, PASSWORD_BCRYPT);
            $upd = $pdo->prepare('UPDATE kullanici2 SET sifre = :pw, reset_token = NULL, reset_token_expires = NULL WHERE id = :id');
            $upd->bindValue(':pw', $hash);
            $upd->bindValue(':id', (int)$row['id'], PDO::PARAM_INT);
            if ($upd->execute()) {
                $message = 'Şifreniz güncellendi. Giriş yapabilirsiniz.'; $alertType = 'success';
            } else { $message = 'Güncelleme başarısız.'; $alertType = 'danger'; }
        } else { $message = 'Bağlantı geçersiz veya süresi dolmuş.'; $alertType = 'danger'; }
    }
}
?>
<?php include __DIR__ . '/../inc/head.php'; ?>
<?php include __DIR__ . '/../inc/header.php'; ?>
<style>
  body{background:#000 !important;color:#fff}
  .centerWrap{background:#000 !important}
  .container-fluid{background:#000 !important}
</style>
<div class="centerWrap">
  <div class="container-fluid" style="max-width:520px;padding:24px 12px;">
    <ul class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Ana Sayfa</a></li>
      <li class="breadcrumb-item" aria-current="page">Affiliate Şifre Sıfırla</li>
    </ul>
    <div class="card" style="background:#0b0b0b;border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">
        <h5 class="card-title">Şifre Sıfırlama</h5>
        <?php if (!empty($message)) { ?><div class="alert alert-<?php echo $alertType; ?>"><?php echo $message; ?></div><?php } ?>
        <?php if ($valid || $_SERVER['REQUEST_METHOD'] === 'POST') { ?>
        <form method="POST" action="">
          <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
          <div class="form-group">
            <label class="col-form-label">Yeni Şifre</label>
            <input name="password" class="form-control" type="password" required>
          </div>
          <div class="form-group">
            <label class="col-form-label">Şifreyi Doğrula</label>
            <input name="password_confirm" class="form-control" type="password" required>
          </div>
          <div class="text-right"><button class="btn btn-primary" type="submit">Şifreyi Güncelle</button></div>
        </form>
        <?php } ?>
      </div>
    </div>
  </div>
  <style>#menu-toggle{display:none !important}</style>
</div>