<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// JSON endpoint headers
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// Hataları kullanıcıya göstermeyelim (JSON çıktısını bozabilir)
error_reporting(E_ALL);
ini_set('display_errors', 0);

include '../inc/database.php';

function send_json($payload){
    if (ob_get_level()) { ob_clean(); }
    echo json_encode($payload, JSON_UNESCAPED_UNICODE);
    exit;
}

if (!empty($_SESSION['loggedin']) || !empty($_SESSION['username'])) {
    $username = $_SESSION['username'];

    $sql = "SELECT ana_bakiye FROM kullanicilar WHERE username = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        send_json(['status' => 'error', 'message' => 'Sorgu hazırlama hatası: ' . $conn->error]);
    }

    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($ana_bakiye);
    $stmt->fetch();
    $stmt->close();

    // Güvenli biçimlendirme ve JSON çıkışı
    $formatted = number_format((float)$ana_bakiye, 2, ',', '.') . " ₺";
    send_json(['status' => 'success', 'ana_bakiye' => $formatted]);
} else {
    send_json(['status' => 'error', 'message' => 'Kullanıcı oturumu açmamış.']);
}

$conn->close();
?>
