<?php
// Test verilerini hazırla
$data = [
    "Key" => "sample_key",
    "PlayerID" => 15,
    "PlayerFullName" => "Yiğitcik",
    "TraderTransactionID" => "TRX123",
    "PaymentTransactionID" => "PAY456",
    "Amount" => 5000.00,
    "Type" => "Deposit",
    "Status" => "Successful",
    "Description" => "Test description",
    "CurrencyCode" => "TRY",
    "PaymentName" => "HemenPay"
];

// JSON formatında veri oluştur
$json_data = json_encode($data);

// CURL ile POST isteği gönder
$url = "https://demo3.veritral.com/api/hemenpay2.php";
$ch = curl_init($url);

// CURL ayarlarını yap
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "Content-Length: " . strlen($json_data)
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);

// İsteği gönder ve yanıtı al
$response = curl_exec($ch);
$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

// CURL bağlantısını kapat
curl_close($ch);

// Yanıtı kontrol et ve göster
if ($error) {
    echo "CURL Hatası: " . $error;
} else {
    echo "HTTP Durumu: " . $http_status . PHP_EOL;
    echo "Yanıt: " . $response . PHP_EOL;
}
?>
