<?php
// Telegram Bot Token ve Default Chat ID
define('BOT_TOKEN', "7986728487:");
define('DEFAULT_CHAT_ID', "-");

// Telegram mesaj gönderme fonksiyonu
function telegram_mesajYolla($msg, $chat_id = DEFAULT_CHAT_ID) {
    return file_get_contents("https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage?chat_id=$chat_id&text=" . urlencode($msg));
}

// Veritabanı bağlantı bilgileri
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    // PDO ile veritabanı bağlantısını oluştur
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
    // Hata modunu ayarla
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Bağlantı hatası durumunda hata mesajı döndür
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Veritabanı bağlantı hatası: ' . $e->getMessage()]);
    exit;
}

// JSON verisini al
$json_input = file_get_contents('php://input');

// JSON verisini diziye dönüştür
$data = json_decode($json_input, true);

// JSON decode hatasını kontrol et
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Geçersiz JSON verisi']);
    exit;
}

// Gerekli alanları al
$key = isset($data['Key']) ? $data['Key'] : null;
$player_id = isset($data['PlayerID']) ? $data['PlayerID'] : null;
$player_full_name = isset($data['PlayerFullName']) ? $data['PlayerFullName'] : null;
$trader_transaction_id = isset($data['TraderTransactionID']) ? $data['TraderTransactionID'] : null;
$payment_transaction_id = isset($data['PaymentTransactionID']) ? $data['PaymentTransactionID'] : null;
$amount = isset($data['Amount']) ? $data['Amount'] : null;
$type = isset($data['Type']) ? $data['Type'] : null;
$status = isset($data['Status']) ? $data['Status'] : null;
$description = isset($data['Description']) ? $data['Description'] : null;
$currency_code = isset($data['CurrencyCode']) ? $data['CurrencyCode'] : null;
$payment_name = isset($data['PaymentName']) ? $data['PaymentName'] : null;
$checksum = isset($data['checksum']) ? $data['checksum'] : null;

// Durum kontrolü - Sadece başarılı işlemler işlenecek
if ($status !== 'Successful') {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Başarısız işlem']);
    exit;
}

// Kullanıcıyı kontrol et
try {
    $check_user_sql = "SELECT * FROM kullanicilar WHERE id = :player_id";
    $check_user_stmt = $pdo->prepare($check_user_sql);
    $check_user_stmt->bindParam(':player_id', $player_id);
    $check_user_stmt->execute();

    if ($check_user_stmt->rowCount() === 0) {
        // Kullanıcı bulunamazsa hata mesajı döndür
        http_response_code(404);
        echo json_encode(['status' => 'error', 'message' => 'Kullanıcı bulunamadı']);
        exit;
    }

    // Kullanıcının ana bakiyesini güncelle
    $update_sql = "UPDATE kullanicilar SET ana_bakiye = ana_bakiye + :amount WHERE id = :player_id";
    $update_stmt = $pdo->prepare($update_sql);
    $update_stmt->bindParam(':amount', $amount);
    $update_stmt->bindParam(':player_id', $player_id);
    $update_stmt->execute();

    // İşlemi kaydet
    $log_sql = "INSERT INTO parayatir (user_id, miktar, tur, referans, tarih, durum, aciklama, token, adsoyad)
                VALUES (:player_id, :amount, :payment_name, :trader_transaction_id, NOW(), 2, :description, :payment_transaction_id, :player_full_name)";
    $log_stmt = $pdo->prepare($log_sql);
    $log_stmt->bindParam(':player_id', $player_id);
    $log_stmt->bindParam(':amount', $amount);
    $log_stmt->bindParam(':payment_name', $payment_name);
    $log_stmt->bindParam(':trader_transaction_id', $trader_transaction_id);
    $log_stmt->bindParam(':description', $description);
    $log_stmt->bindParam(':payment_transaction_id', $payment_transaction_id);
    $log_stmt->bindParam(':player_full_name', $player_full_name);
    $log_stmt->execute();

    // Kullanıcı ID'si belirli bir aralıktaysa Telegram'a mesaj gönder
    if (1 <= $player_id && $player_id <= 999999) {
        $message = "$player_full_name HemenPay ile $amount TL yatırım yaptı. Ödeme türü: $payment_name (ID: $player_id)";
        telegram_mesajYolla($message);
    }

    // Başarı durumu
    http_response_code(200);
    echo json_encode(['status' => 'success', 'message' => 'İşlem başarılı']);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Veritabanı hatası: ' . $e->getMessage()]);
}
?>
