<?php


$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    // PDO ile veritabanı bağlantısını oluştur
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
    // Hata modunu ayarla
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Bağlantı hatası durumunda hata mesajı döndür
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Veritabanı bağlantı hatası: ' . $e->getMessage()]);
    exit;
}

// JSON verisini al
$json_input = file_get_contents('php://input');

// JSON verisini diziye dönüştür
$data = json_decode($json_input, true);

// JSON decode hatasını kontrol et
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Geçersiz JSON verisi']);
    exit;
}

// İşlem türünü belirle
$process = isset($data['Process']) ? $data['Process'] : '';
$islem = isset($data['islem']) ? $data['islem'] : '';

if ($process === 'WithdrawalReturn') {
    // Çekim işlemi
    $user_id = isset($data['UserID']) ? $data['UserID'] : null;
    $firma_key = isset($data['firma_key']) ? $data['firma_key'] : null;
    $amount = isset($data['Amount']) ? $data['Amount'] : null;
    $reference = isset($data['Reference']) ? $data['Reference'] : null;
    $date = isset($data['Date']) ? $data['Date'] : null;
    $token = isset($data['Token']) ? $data['Token'] : null;
    $method = isset($data['Method']) ? $data['Method'] : null;
    $hashcode = isset($data['Hashcode']) ? $data['Hashcode'] : null;
    $adsoyad = isset($data['kullanici_isim']) ? $data['kullanici_isim'] : null; // Ad soyad verisi

    // Duruma göre uygun değerleri belirle
    if ($data['Status'] === 'onay') {
        $db_durum = 1; // Başarı durumunda 1 olarak ayarlanır
        $status_text = 'onay'; // Status "onay" olarak ayarlanır
    } elseif ($data['Status'] === 'ret') {
        $db_durum = 1; // Red durumunda da 1 olarak ayarlanır
        $status_text = 'red'; // Status "red" olarak ayarlanır
    } else {
        // Geçersiz durum
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Geçersiz durum']);
        exit;
    }

}

elseif ($islem === 'yatirimsonuc') {
    // Yatırım işlemi
    $user_id = isset($data['id']) ? $data['id'] : null;
    $firma_key = isset($data['firma_key']) ? $data['firma_key'] : null;
    $kullanici_id = isset($data['kullanici_id']) ? $data['kullanici_id'] : null;
    $tutar = isset($data['tutar']) ? $data['tutar'] : null;
    $referans = isset($data['referans']) ? $data['referans'] : null;
    $durum = isset($data['durum']) ? $data['durum'] : null;
    $tarih = isset($data['tarih']) ? $data['tarih'] : null;
    $token = isset($data['token']) ? $data['token'] : null;
    $yontem = isset($data['yontem']) ? $data['yontem'] : null;
    $adsoyad = isset($data['kullanici_isim']) ? $data['kullanici_isim'] : null; // Ad soyad verisi

    // Duruma göre uygun değerleri belirle
    if ($durum === 'onay') {
        $db_durum = 0; // Durum 0 olarak ayarlanır
        $status = 'onay'; // Status "onay" olarak ayarlanır
    } elseif ($durum === 'ret') {
        $db_durum = 1; // Durum 1 olarak ayarlanır
        $status = 'red'; // Status "red" olarak ayarlanır
    } else {
        // Geçersiz durum
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Geçersiz durum']);
        exit;
    }

    try {
        // Kullanıcının varlığını kontrol et
        $check_user_sql = "SELECT * FROM kullanicilar WHERE id = :kullanici_id";
        $check_user_stmt = $pdo->prepare($check_user_sql);
        $check_user_stmt->bindParam(':kullanici_id', $kullanici_id);
        $check_user_stmt->execute();
        
        if ($check_user_stmt->rowCount() === 0) {
            // Kullanıcı bulunamazsa hata mesajı döndür
            http_response_code(404);
            echo json_encode(['status' => 'error', 'message' => 'Kullanıcı bulunamadı']);
            exit;
        }

        // Durum onay ise (0), işlem başarılı sayılacak ve bakiye güncellenecek
        if ($db_durum === 0) {
            // Kullanıcının ana bakiyesini güncelle
            $update_sql = "UPDATE kullanicilar SET ana_bakiye = ana_bakiye + :tutar WHERE id = :kullanici_id";
            $update_stmt = $pdo->prepare($update_sql);
            $update_stmt->bindParam(':tutar', $tutar);
            $update_stmt->bindParam(':kullanici_id', $kullanici_id); // Uye yerine kullanici_id kullanıyoruz
            $update_stmt->execute();

            // Durumu 2 yap
            $db_durum = 2;
        }

        // SQL sorgusu - işlemi kaydet
        $sql = "INSERT INTO parayatir (user_id, uye, miktar, tur, referans, tarih, durum, aciklama, token, adsoyad)
                VALUES (:user_id, :uye, :miktar, :tur, :referans, :tarih, :durum, :aciklama, :token, :adsoyad)";

        $stmt = $pdo->prepare($sql);

        // Verileri bağla
        $stmt->bindParam(':user_id', $user_id);
        $stmt->bindParam(':uye', $kullanici_id); // Kullanıcı ID'si
        $stmt->bindParam(':miktar', $tutar);
        $stmt->bindParam(':tur', $yontem); // Yöntemi 'tur' olarak kullan
        $stmt->bindParam(':referans', $referans);
        $stmt->bindParam(':tarih', $tarih);
        $stmt->bindParam(':durum', $db_durum); // Durum 2 olarak kaydedilecek
        $stmt->bindParam(':aciklama', $status);
        $stmt->bindParam(':token', $token);
        $stmt->bindParam(':adsoyad', $adsoyad);

        // SQL sorgusunu çalıştır
        $stmt->execute();

        // Başarı durumunda yanıt döndür
        http_response_code(200);
        echo json_encode(['status' => true]);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode([
            'status' => 'error', 
            'message' => 'Veritabanı hatası: ' . $e->getMessage() . ' - Sorgu: ' . $sql
        ]);
    }
} else {
    // Geçersiz işlem türü
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Geçersiz işlem türü']);
}
?>
