<?php
$token = getenv('TELEGRAM_BOT_TOKEN');
if (!$token) {
    echo "No TELEGRAM_BOT_TOKEN env set\n";
    exit(1);
}
$url = sprintf('https://api.telegram.org/bot%s/getMe', $token);
$ch = curl_init($url);
$insecure = getenv('CURL_INSECURE');
if ($insecure || isset($_GET['insecure'])) {
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
}
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 8,
    CURLOPT_CONNECTTIMEOUT => 5,
]);
$resp = curl_exec($ch);
if ($resp === false) {
    echo 'Curl error: ' . curl_error($ch) . "\n";
    exit(1);
}
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
echo "HTTP: {$code}\n{$resp}\n";