<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// OPTIONS request için
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../woohdd/config.php'; // Woohdd config dosyasını kullan

// Admin kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Geçersiz JSON verisi');
    }
    
    $alert_id = $input['alert_id'] ?? null;
    $status = $input['status'] ?? null;
    
    if (!$alert_id || !$status) {
        throw new Exception('Eksik parametreler');
    }
    
    // Geçerli durum değerleri
    $valid_statuses = ['active', 'resolved', 'false_positive', 'investigating'];
    
    if (!in_array($status, $valid_statuses)) {
        throw new Exception('Geçersiz durum değeri');
    }
    
    // Uyarı durumunu güncelle
    $stmt = $pdo->prepare("
        UPDATE detected_suspicious_activities 
        SET status = ?, 
            resolved_at = CASE WHEN ? IN ('resolved', 'false_positive') THEN NOW() ELSE NULL END,
            resolved_by = CASE WHEN ? IN ('resolved', 'false_positive') THEN ? ELSE NULL END
        WHERE id = ?
    ");
    
    $admin_id = $_SESSION['admin_id'] ?? 1;
    $stmt->execute([$status, $status, $status, $admin_id, $alert_id]);
    
    if ($stmt->rowCount() === 0) {
        throw new Exception('Uyarı bulunamadı veya güncelleme yapılamadı');
    }
    
    // Log kaydı oluştur
    $log_stmt = $pdo->prepare("
        INSERT INTO admin_logs (admin_id, action, details, created_at)
        VALUES (?, 'alert_status_update', ?, NOW())
    ");
    
    $log_details = json_encode([
        'alert_id' => $alert_id,
        'new_status' => $status,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
    $log_stmt->execute([$admin_id, $log_details]);
    
    echo json_encode([
        'status' => 'success',
        'message' => 'Uyarı durumu başarıyla güncellendi',
        'alert_id' => $alert_id,
        'new_status' => $status
    ]);
    
} catch (Exception $e) {
    error_log("Update alert status error: " . $e->getMessage());
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>