<?php
$servername = "localhost";
$username = "blacrhdy_bet1";
$password = "blacrhdy_bet1";
$dbname = "blacrhdy_bet1";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Bağlantı hatası: " . $conn->connect_error);
}

$request = json_decode(file_get_contents('php://input'), true);
session_start();
$aktif_kullanici_username = $_SESSION['username'];

$kullanici_id_sql = "SELECT id, ana_bakiye FROM kullanicilar WHERE username = ?";
$stmt = $conn->prepare($kullanici_id_sql);
$stmt->bind_param("s", $aktif_kullanici_username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $kullanici = $result->fetch_assoc();
    $aktif_kullanici_id = $kullanici['id'];
    $ana_bakiye = $kullanici['ana_bakiye'];
} else {
    echo json_encode(['success' => false, 'message' => 'Kullanıcı bulunamadı.']);
    exit;
}

if ($request['action'] === 'ver_bonusu') {
    $bonusTuru = $request['bonusTuru'];
    date_default_timezone_set('Europe/Istanbul');
    $bugun = date('Y-m-d');

    // Günlük bonus kontrolü
    $gunluk_kontrol_sql = "SELECT * FROM bonus_talepleri WHERE uye_id = ? AND tarih = ?";
    $stmt = $conn->prepare($gunluk_kontrol_sql);
    $stmt->bind_param("is", $aktif_kullanici_id, $bugun);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo json_encode(['success' => false, 'message' => 'Günlük bonus hakkınızı zaten kullandınız.']);
        exit;
    }

    // Son 24 saat yatırım kontrolü
    $yatirim_sql = "SELECT SUM(miktar) AS toplam_yatirim FROM parayatir WHERE (uye = ? OR user_id = ?) AND durum = 1 AND tarih >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
    $stmt = $conn->prepare($yatirim_sql);
    $stmt->bind_param("ii", $aktif_kullanici_id, $aktif_kullanici_id);
    $stmt->execute();
    $result = $stmt->get_result();
$row = $result->fetch_assoc();
$toplam_yatirim = isset($row['toplam_yatirim']) ? floatval($row['toplam_yatirim']) : 0.0;

    $bonus_miktari = 0;

    if ($bonusTuru === '%100 HOŞGELDİN BONUSU') {
        // İlk yatırım kontrolü
        $onceki_yatirim_sql = "SELECT COUNT(*) as yatirim_sayisi FROM parayatir WHERE uye = ? AND durum = 1";
        $stmt = $conn->prepare($onceki_yatirim_sql);
        $stmt->bind_param("i", $aktif_kullanici_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $yatirim_sayisi = $result->fetch_assoc()['yatirim_sayisi'];

        if ($yatirim_sayisi > 1) {
            echo json_encode(['success' => false, 'message' => 'Hoşgeldin bonusu sadece ilk yatırım için geçerlidir.']);
            exit;
        }
        $bonus_miktari = $toplam_yatirim;
    } else {
        switch ($bonusTuru) {
            case '5000 TL ÜSTÜ YATIRIMLARDA %200 BONUS':
                if ($toplam_yatirim >= 5000) {
                    $bonus_miktari = $toplam_yatirim * 2;
                } else {
                    echo json_encode(['success' => false, 'message' => 'Bu bonus için minimum 5000 TL yatırım gereklidir.']);
                    exit;
                }
                break;
            case '%20 ÇEVRİMSİZ YATIRIM BONUSU':
                $bonus_miktari = $toplam_yatirim * 0.20;
                break;
        }
    }

    if ($bonus_miktari > 0) {
        $conn->begin_transaction();
        $wr = 0.0;
        $wrq = $conn->prepare("SELECT wagering_requirement, no_wagering FROM bonus_types WHERE name = ? LIMIT 1");
        $wrq->bind_param("s", $bonusTuru);
        $wrq->execute();
        $wrres = $wrq->get_result();
        $no_wr = 0;
        if ($wrrow = $wrres->fetch_assoc()) { $wr = floatval($wrrow['wagering_requirement']); $no_wr = intval($wrrow['no_wagering']) ? 1 : 0; }
        $wrq->close();
        $insert_sql = "INSERT INTO bonus_talepleri (uye_id, bonus_turu, miktar, tarih, durum, wagering_requirement, no_wagering) VALUES (?, ?, ?, ?, 1, ?, ?)";
        $insert_stmt = $conn->prepare($insert_sql);
        $insert_stmt->bind_param("isdsii", $aktif_kullanici_id, $bonusTuru, $bonus_miktari, $bugun, $wr, $no_wr);
        if ($insert_stmt->execute()) {
            $update_sql = "UPDATE kullanicilar SET ana_bakiye = ana_bakiye + ? WHERE id = ?";
            $upd = $conn->prepare($update_sql);
            $upd->bind_param("di", $bonus_miktari, $aktif_kullanici_id);
            if ($upd->execute()) {
                $conn->commit();
                echo json_encode(['success' => true, 'message' => 'Bonus başarıyla hesabınıza eklendi.']);
            } else {
                $conn->rollback();
                echo json_encode(['success' => false, 'message' => 'Bonus bakiye güncellemesi başarısız.']);
            }
            $upd->close();
        } else {
            $conn->rollback();
            echo json_encode(['success' => false, 'message' => 'Bonus talebi oluşturulamadı.']);
        }
        $insert_stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Geçerli bir yatırım bulunamadı.']);
    }
}

$conn->close();
?>