<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bonus Talep</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Work+Sans:wght@200;300;400;500;600;700;800;900&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: #000;
            color: #ffffff;
            font-family: 'Work Sans', sans-serif;
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }

        .header-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding: 20px 0;
            border-bottom: 2px solid #333;
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(45deg, #d1af0a, #f4d03f);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .home-button {
            background: linear-gradient(45deg, #d1af0a, #f4d03f);
            color: #000;
            padding: 12px 24px;
            border-radius: 25px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(209, 175, 10, 0.3);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .home-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(209, 175, 10, 0.4);
            color: #000;
        }

        .home-button i {
            margin-right: 8px;
        }

        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(45deg, #d1af0a, #f4d03f);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .bonus-section {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .bonus-section h2 {
            text-align: center;
            font-size: 2rem;
            margin-bottom: 25px;
            color: #d1af0a;
        }

        .bonus-buttons {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .bonus-btn {
            background: linear-gradient(45deg, #333, #444);
            border: 2px solid #d1af0a;
            color: #fff;
            padding: 20px;
            border-radius: 15px;
            cursor: pointer;
            font-size: 1.1rem;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .bonus-btn:hover {
            background: linear-gradient(45deg, #d1af0a, #f4d03f);
            color: #000;
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(209, 175, 10, 0.3);
        }

        .bonus-btn.active {
            background: linear-gradient(45deg, #d1af0a, #f4d03f);
            color: #000;
        }

        .bonus-btn i {
            margin-right: 10px;
            font-size: 1.3rem;
        }

        .bonus-list {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }

        .bonus-list button {
            background: linear-gradient(45deg, #d1af0a, #f4d03f);
            color: #000;
            border: none;
            padding: 18px 20px;
            border-radius: 12px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(209, 175, 10, 0.2);
        }

        .bonus-list button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(209, 175, 10, 0.4);
            opacity: 0.9;
        }

        .past-bonuses-section {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 20px;
            padding: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .past-bonuses-section h2 {
            text-align: center;
            font-size: 2rem;
            margin-bottom: 25px;
            color: #d1af0a;
        }

        .table-responsive {
            overflow-x: auto;
        }

        .bonus-table {
            width: 100%;
            border-collapse: collapse;
            background: rgba(255, 255, 255, 0.02);
            border-radius: 10px;
            overflow: hidden;
        }

        .bonus-table th,
        .bonus-table td {
            padding: 15px;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .bonus-table th {
            background: rgba(209, 175, 10, 0.2);
            font-weight: 600;
            color: #d1af0a;
        }

        .bonus-table td {
            color: #fff;
        }

        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
        }

        .status-success {
            background: #18ab2b;
            color: #fff;
        }

        .status-danger {
            background: #d70b0b;
            color: #fff;
        }

        .status-warning {
            background: #d7b00b;
            color: #fff;
        }

        .alert {
            border: none;
            border-radius: 12px;
            color: white;
            font-size: 1rem;
            font-weight: 500;
            padding: 15px 20px;
            margin-bottom: 20px;
            display: none;
        }

        .alert.show {
            display: block;
            animation: slideIn 0.3s ease;
        }

        .alert-success {
            background: linear-gradient(45deg, #18ab2b, #28c940);
        }

        .alert-danger {
            background: linear-gradient(45deg, #d70b0b, #e74c3c);
        }

        .alert-warning {
            background: linear-gradient(45deg, #d7b00b, #f39c12);
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 768px) {
            .header-section {
                flex-direction: column;
                gap: 20px;
                text-align: center;
            }

            .page-title {
                font-size: 2rem;
            }

            .bonus-buttons {
                grid-template-columns: 1fr;
            }

            .bonus-list {
                grid-template-columns: 1fr;
            }

            .container {
                padding: 0 10px;
            }
        }
    </style>
    <style>
        .sweet-overlay { background: rgba(0,0,0,.6) !important; }
        .sweet-alert { background: #11151a !important; border: 1px solid rgba(255,255,255,.12) !important; border-radius: 14px !important; box-shadow: 0 8px 24px rgba(0,0,0,.35) !important; padding: 24px 20px !important; }
        .sweet-alert h2 { color: #e6e9ef !important; font-weight: 800 !important; font-size: 20px !important; }
        .sweet-alert p { color: #9aa4b2 !important; font-size: 13px !important; }
        .sweet-alert .sa-button-container .confirm, .sweet-alert button.confirm { background: var(--primary, #e5b645) !important; color: var(--btntText, #000) !important; border-radius: 10px !important; padding: 10px 18px !important; box-shadow: none !important; }
        .sweet-alert .sa-button-container .cancel, .sweet-alert button.cancel { background: rgba(255,255,255,.08) !important; color: #e6e9ef !important; border-radius: 10px !important; }
        .sweet-alert .sa-icon.sa-error { border-color: #e74c3c !important; }
        .sweet-alert .sa-icon.sa-error .sa-x-mark { position: relative; }
        .sweet-alert .sa-icon.sa-error .sa-line.sa-left { background-color: #e74c3c !important; }
        .sweet-alert .sa-icon.sa-error .sa-line.sa-right { background-color: #e74c3c !important; }
        .sweet-alert .sa-icon.sa-success { border-color: #2ecc71 !important; }
        .sweet-alert .sa-icon.sa-success::before, .sweet-alert .sa-icon.sa-success::after { background: transparent !important; }
        .sweet-alert .sa-icon.sa-success .sa-line.sa-tip, .sweet-alert .sa-icon.sa-success .sa-line.sa-long { background-color: #2ecc71 !important; }
        .sweet-alert .sa-icon.sa-warning { border-color: #f39c12 !important; }
        @media (max-width: 480px){ .sweet-alert { width: calc(100% - 32px) !important; left: 16px !important; right: 16px !important; } }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header Section -->
        <div class="header-section">
            <a href="/" class="home-button">
                <i class="fas fa-home"></i> Anasayfaya Dön
            </a>
            <h1 class="page-title">Bonus Talep</h1>
        </div>

        <!-- Alert -->
        <div class="alert" role="alert" id="alert">
            <span></span>
        </div>

        <!-- Bonus Section -->
        <div class="bonus-section">
            <h2>Oto Bonus</h2>
            <div class="bonus-buttons">
                <button class="bonus-btn investment-btn active" onclick="showBonuses('yatirim')">
                    <i class="fas fa-coins"></i>
                    Yatırım Bonusları
                </button>
                <button class="bonus-btn loss-btn" onclick="showBonuses('kayip')">
                    <i class="fas fa-chart-line-down"></i>
                    Kayıp Bonusları
                </button>
            </div>

            <div class="bonus-list" id="bonus-list">
                <!-- Initial investment bonuses -->
                <button id="premiumBonus">5000 TL ÜSTÜ YATIRIMLARDA %200 BONUS</button>
                <button id="welcomeBonus">%100 HOŞGELDİN BONUSU</button>
                <button id="noRolloverBonus">%20 ÇEVRİMSİZ YATIRIM BONUSU</button>
            </div>
        </div>

        <!-- Past Bonuses Section -->
        <div class="past-bonuses-section">
            <h2>Geçmiş Bonuslar</h2>
            <div class="table-responsive">
                <table class="bonus-table">
                    <thead>
                        <tr>
                            <th>Bonus Türü</th>
                            <th>Miktar</th>
                            <th>Tarih</th>
                            <th>Durum</th>
                        </tr>
                    </thead>
                    <tbody id="pastBonusesTable">
                        <!-- Geçmiş bonuslar buraya yüklenecek -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        if (typeof swal !== 'undefined' && swal.setDefaults) { swal.setDefaults({ confirmButtonText: 'Tamam' }); }
        // Initialize with investment bonuses
        addYatirimListeners();
        loadPastBonuses();

        function showBonuses(type) {
            const bonusList = document.getElementById("bonus-list");
            const buttons = document.querySelectorAll(".bonus-btn");
            
            // Remove active class from all buttons
            buttons.forEach(button => button.classList.remove("active"));
            
            if (type === 'yatirim') {
                document.querySelector(".investment-btn").classList.add("active");
                bonusList.innerHTML = `
                    <button id="premiumBonus">5000 TL ÜSTÜ YATIRIMLARDA %200 BONUS</button>
                    <button id="welcomeBonus">%100 HOŞGELDİN BONUSU</button>
                    <button id="noRolloverBonus">%20 ÇEVRİMSİZ YATIRIM BONUSU</button>
                `;
                addYatirimListeners();
            } else if (type === 'kayip') {
                document.querySelector(".loss-btn").classList.add("active");
                bonusList.innerHTML = `
                    <button id="lossBonus">%20 KAYIP BONUSU</button>
                    <button id="nightLossBonus">%30 GECE KAYIP BONUSU</button>
                `;
                addKayipListeners();
            }
        }

        function addYatirimListeners() {
            document.getElementById('premiumBonus').addEventListener('click', function() {
                bonusTalep('5000 TL ÜSTÜ YATIRIMLARDA %200 BONUS', 'bonus_ver.php');
            });
            document.getElementById('welcomeBonus').addEventListener('click', function() {
                bonusTalep('%100 HOŞGELDİN BONUSU', 'bonus_ver.php');
            });
            document.getElementById('noRolloverBonus').addEventListener('click', function() {
                bonusTalep('%20 ÇEVRİMSİZ YATIRIM BONUSU', 'bonus_ver.php');
            });
        }

        function addKayipListeners() {
            document.getElementById('lossBonus').addEventListener('click', function() {
                bonusTalep('%20 KAYIP BONUSU', 'kayip_bonus_ver.php');
            });
            document.getElementById('nightLossBonus').addEventListener('click', function() {
                bonusTalep('%30 GECE KAYIP BONUSU', 'kayip_bonus_ver.php');
            });
        }

        function bonusTalep(bonusTuru, dosyaAdi) {
            fetch(`./${dosyaAdi}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    action: 'ver_bonusu',
                    bonusTuru: bonusTuru
                })
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Ağ yanıtı düzgün değil: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    swal("Başarılı!", "Bonus başarıyla verildi!", "success");
                    loadPastBonuses();
                } else {
                    swal("Hata!", "Bonus verilemedi: " + data.message, "error");
                }
            })
            .catch(error => {
                console.error('Hata:', error);
                swal("Hata!", "Bir hata oluştu. Lütfen tekrar deneyin.", "error");
            });
        }

        function loadPastBonuses() {
            const tbody = document.getElementById('pastBonusesTable');
            Promise.all([
                fetch('../api/bonus_system.php?action=get_bonus_history').then(r => r.json()).catch(() => ({ success: false, history: [] })),
                fetch('../api/bonus_system.php?action=get_bonus_requests').then(r => r.json()).catch(() => ({ success: false, requests: [] }))
            ]).then(([histRes, reqRes]) => {
                const statusMap = {
                    pending: 'Bekliyor',
                    active: 'Aktif',
                    used: 'Kullanıldı',
                    expired: 'Süresi Doldu',
                    approved: 'Onaylandı',
                    rejected: 'Reddedildi',
                    activated: 'Aktifleştirildi'
                };
                const history = Array.isArray(histRes.history) ? histRes.history : [];
                const requests = Array.isArray(reqRes.requests) ? reqRes.requests : [];
                const entries = [];
                for (const item of history) {
                    entries.push({
                        tur: item.bonus_name || 'Bonus',
                        miktar: typeof item.amount !== 'undefined' ? item.amount : '',
                        tarih: item.action_date || item.created_at || '',
                        durum: statusMap[item.status || item.action || ''] || (item.status || item.action || '')
                    });
                }
                for (const r of requests) {
                    const durumKey = r.durum === 0 ? 'pending' : (r.durum === 1 ? 'approved' : (r.durum === 2 ? 'rejected' : ''));
                    entries.push({
                        tur: r.bonus_name || 'Bonus',
                        miktar: typeof r.amount !== 'undefined' ? r.amount : '',
                        tarih: r.created_at || '',
                        durum: statusMap[durumKey] || (durumKey || '')
                    });
                }
                if (entries.length === 0) {
                    tbody.innerHTML = `<tr><td colspan="4">Henüz geçmiş bonus bulunmuyor</td></tr>`;
                    return;
                }
                tbody.innerHTML = entries.map(e => `<tr><td>${e.tur}</td><td>${e.miktar}</td><td>${e.tarih}</td><td>${e.durum}</td></tr>`).join('');
            }).catch(() => {
                tbody.innerHTML = `<tr><td colspan="4">Geçmiş bonuslar yüklenirken hata oluştu</td></tr>`;
            });
        }

        function showAlert(message, type) {
            const alert = document.getElementById('alert');
            const span = alert.querySelector('span');
            
            span.textContent = message;
            alert.className = `alert alert-${type} show`;
            
            setTimeout(() => {
                alert.classList.remove('show');
            }, 5000);
        }
    </script>
</body>
</html>