<?php include '../inc/head.php' ?>
<?php include '../inc/header.php' ?>
<?php include '../inc/slider.php' ?>
</div>


<?php
include '../database.php';


// Oyunları arama fonksiyonu
function searchGames($searchTerm) {
    global $pdo;
    $sql = "SELECT game_id, game_name, cover FROM games WHERE game_name LIKE :searchTerm";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':searchTerm', '%' . $searchTerm . '%', PDO::PARAM_STR);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Toplam oyun sayısını almak için fonksiyon
function getGameCount() {
    global $pdo;
    $sql = "SELECT COUNT(*) as total_games FROM games";
    $stmt = $pdo->query($sql);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    return $result['total_games'];
}

// Toplam oyun sayısını al
$total_games = getGameCount();
?>

<style>
    .iframe-popup {
        display: none;
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 80%;
        height: 80%;
        background-color: white;
        border-radius: 10px;
        border: 1px solid #ccc;
        z-index: 9999;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }

    .iframe-popup iframe {
        width: 100%;
        height: 100%;
        border: none;
    }

    .overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.7);
        z-index: 9998;
    }

    .flex-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

   .vendor-item {
    display: inline-block;
    margin-right: 10px;
    text-align: center;
    cursor: pointer;
    transition: transform 0.2s, width 0.2s;
    width: 150px;
    height: 120px;
    overflow: hidden;
    position: relative;
    color: #000;
    font-size: 12px;
}

    .vendor-item img {
        width: 100%; /* Make the image fill the width */
        height: auto; /* Maintain aspect ratio */
        display: block; /* Removes space below the image */
    }

    .vendor-item .type {
        display: block; /* Display name as a block */
        margin-top: 5px; /* Space between image and name */
        color: #fff; /* White color for text */
    }

    .vendor-item:hover {
        transform: scale(1.05); /* Slightly enlarge on hover */
    }

    .vendor-item.active {
        transform: scale(1.1); /* Enlarge selected item */
        width: 100px; /* Increase width for active item */
        background-color: rgba(0, 0, 0, 0.5); /* Optional background for active item */
        border-radius: 5px; /* Rounded corners for active item */
    }

    .horizontal-scroll {
        overflow-x: auto;
        white-space: nowrap;
        padding: 10px 0; /* Padding for better spacing */
    }

@media (max-width: 768px) {
    .vendor-item {
        width: 130px;
        height: 120px;
    }

        .vendor-item .type {
            font-size: 10px; /* Smaller font on mobile */
        }
    }
</style>

<script>
    // iframe popup'ı açma fonksiyonu
    function openIframe(url) {
        const iframePopup = document.getElementById('iframePopup');
        const overlay = document.getElementById('overlay');
        const iframe = document.getElementById('gameIframe');

        iframe.src = url; // URL'yi iframe'e ayarla
        iframePopup.style.display = 'block'; // Popup'ı göster
        overlay.style.display = 'block'; // Overlay'i göster
    }

    // Popup'ı kapatma fonksiyonu
    function closeIframe() {
        const iframePopup = document.getElementById('iframePopup');
        const overlay = document.getElementById('overlay');
        const iframe = document.getElementById('gameIframe');

        iframe.src = ''; // iframe kaynağını temizle
        iframePopup.style.display = 'none'; // Popup'ı gizle
        overlay.style.display = 'none'; // Overlay'i gizle
    }
</script>

<div class="overlay" id="overlay" onclick="closeIframe()"></div>
<div class="iframe-popup" id="iframePopup">
    <button onclick="closeIframe()" style="position: absolute; top: 10px; right: 10px;">Kapat</button>
    <iframe id="gameIframe" src=""></iframe>
</div>

<div class="horizontal-scroll" id="vendorsList">
    <div class="vendor-item vendorId-0 active" onclick="loadGames('hepsi', this)">
        <img src="./providersimg/hepsi.svg" alt="Hepsi" />
        <span class="type">Hepsi</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('pragmatic', this)">
        <img src="https://garsbet.com/provider/images/pragmatic.jpg" alt="pragmatic" />
        <span class="type">PRAGMATİC</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('joingames', this)">
        <img src="https://garsbet.com/provider/images/joingames.jpg" alt="joingames" />
        <span class="type">JOİN GAMES</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('macawgaming', this)">
        <img src="https://garsbet.com/provider/images/macawgaming.jpg" alt="macawgaming" />
        <span class="type">Macaw Gaming</span>
    </div>



    <div class="vendor-item vendorId-156" onclick="loadGames('boominggames', this)">
        <img src="https://garsbet.com/provider/images/boominggames.jpg" alt="boominggames" />
        <span class="type">Booming Games</span>
    </div>



    <div class="vendor-item vendorId-156" onclick="loadGames('armadillostudios', this)">
        <img src="https://garsbet.com/provider/images/armadillostudios.jpg" alt="armadillostudios" />
        <span class="type">Armadillo Studios</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('bgaming', this)">
        <img src="https://garsbet.com/provider/images/bgaming.jpg" alt="bgaming" />
        <span class="type">B GAMiNG</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('adlunam', this)">
        <img src="https://garsbet.com/provider/images/adlunam.jpg" alt="adlunam" />
        <span class="type">AD Lunam</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('1x2', this)">
        <img src="https://garsbet.com/provider/images/1x2.jpg" alt="1x2" />
        <span class="type">1x2 Gaming</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('prospectgaming', this)">
        <img src="https://garsbet.com/provider/images/prospectgaming.jpg" alt="prospectgaming" />
        <span class="type">Prospect Gaming</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('jvl', this)">
        <img src="https://garsbet.com/provider/images/jvl.jpg" alt="jvl" />
        <span class="type">JVL</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('irondog', this)">
        <img src="https://garsbet.com/provider/images/irondog.jpg" alt="irondog" />
        <span class="type">İron Dog Studio</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('bigtimegaming', this)">
        <img src="https://garsbet.com/provider/images/bigtimegaming.jpg" alt="bigtimegaming" />
        <span class="type">Big Time Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('amigogaming', this)">
        <img src="https://garsbet.com/provider/images/amigogaming.jpg" alt="amigogaming" />
        <span class="type">Amigo Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('kagaming', this)">
        <img src="https://garsbet.com/provider/images/kagaming.jpg" alt="kagaming" />
        <span class="type">KA Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('netgame', this)">
        <img src="https://garsbet.com/provider/images/netgame.jpg" alt="netgame" />
        <span class="type">Net Game</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('rubyplay', this)">
        <img src="https://garsbet.com/provider/images/rubyplay.jpg" alt="rubyplay" />
        <span class="type">Ruby Play</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('pateplay', this)">
        <img src="https://garsbet.com/provider/images/pateplay.jpg" alt="pateplay" />
        <span class="type">Pateplay</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('nolimitcity', this)">
        <img src="https://garsbet.com/provider/images/nolimitcity.jpg" alt="nolimitcity" />
        <span class="type">Nolimit City</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('evoplay', this)">
        <img src="https://garsbet.com/provider/images/evoplay.jpg" alt="evoplay" />
        <span class="type">Evoplay</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('slotopia', this)">
        <img src="https://garsbet.com/provider/images/slotopia.jpg" alt="slotopia" />
        <span class="type">Slotopia</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('habanero', this)">
        <img src="https://garsbet.com/provider/images/habanero.jpg" alt="habanero" />
        <span class="type">Habanero</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('bigpotgaming', this)">
        <img src="https://garsbet.com/provider/images/bigpotgaming.jpg" alt="bigpotgaming" />
        <span class="type">Bigpot Gaming</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('skywind', this)">
        <img src="https://garsbet.com/provider/images/skywind.jpg" alt="skywind" />
        <span class="type">Skywind Group</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('caletagaming', this)">
        <img src="https://garsbet.com/provider/images/caletagaming.jpg" alt="caletagaming" />
        <span class="type">Caleta Gaming</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('7mojos', this)">
        <img src="https://garsbet.com/provider/images/7mojos.jpg" alt="7mojos" />
        <span class="type">7 Mojos</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('hacksaw', this)">
        <img src="https://garsbet.com/provider/images/hacksaw.jpg" alt="hacksaw" />
        <span class="type">Hacksaw Gaming</span>
    </div>


    <div class="vendor-item vendorId-156" onclick="loadGames('backseat', this)">
        <img src="https://garsbet.com/provider/images/backseat.jpg" alt="backseat" />
        <span class="type">Backseat Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('bullshark', this)">
        <img src="https://garsbet.com/provider/images/bullshark.jpg" alt="bullshark" />
        <span class="type">Bullshark Games</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('popok', this)">
        <img src="https://garsbet.com/provider/images/popok.jpg" alt="popok" />
        <span class="type">Popok Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('platipus', this)">
        <img src="https://garsbet.com/provider/images/platipus.jpg" alt="platipus" />
        <span class="type">Platipus</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('mancala', this)">
        <img src="https://garsbet.com/provider/images/mancala.jpg" alt="mancala" />
        <span class="type">Mancala Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('retrogames', this)">
        <img src="https://garsbet.com/provider/images/retrogames.jpg" alt="retrogames" />
        <span class="type">Retro Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('spinomenal', this)">
        <img src="https://garsbet.com/provider/images/spinomenal.jpg" alt="spinomenal" />
        <span class="type">Spinomenal</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('fils', this)">
        <img src="https://garsbet.com/provider/images/fils.jpg" alt="fils" />
        <span class="type">Fils Game</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('smartsoft', this)">
        <img src="https://garsbet.com/provider/images/smartsoft.jpg" alt="smartsoft" />
        <span class="type">Smartsoft Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('onetouch', this)">
        <img src="https://garsbet.com/provider/images/onetouch.jpg" alt="onetouch" />
        <span class="type">One Touch</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('spearhead', this)">
        <img src="https://garsbet.com/provider/images/spearhead.jpg" alt="spearhead" />
        <span class="type">Spearhead Studios</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('betsoft', this)">
        <img src="https://garsbet.com/provider/images/betsoft.jpg" alt="betsoft" />
        <span class="type">Betsoft</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('pgsoft', this)">
        <img src="https://garsbet.com/provider/images/pgsoft.jpg" alt="pgsoft" />
        <span class="type">PG Soft</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('platingaming', this)">
        <img src="https://garsbet.com/provider/images/platingaming.jpg" alt="platingaming" />
        <span class="type">Platin Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('7777', this)">
        <img src="https://garsbet.com/provider/images/7777.jpg" alt="7777" />
        <span class="type">7777 Gaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('micro-gaming', this)">
        <img src="https://garsbet.com/provider/images/micro-gaming.jpg" alt="micro-gaming" />
        <span class="type">Microgaming</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('gamzix', this)">
        <img src="https://garsbet.com/provider/images/gamzix.jpg" alt="gamzix" />
        <span class="type">GAMZİX</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('redrake', this)">
        <img src="https://garsbet.com/provider/images/redrake.jpg" alt="redrake" />
        <span class="type">Red Rake</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('aviatrix', this)">
        <img src="https://garsbet.com/provider/images/aviatrix.jpg" alt="aviatrix" />
        <span class="type">Aviatrix</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('waz-dan', this)">
        <img src="https://garsbet.com/provider/images/waz-dan.jpg" alt="waz-dan" />
        <span class="type">Wazdan</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('galaxsys', this)">
        <img src="https://garsbet.com/provider/images/galaxsys.jpg" alt="galaxsys" />
        <span class="type">Galaxsys</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('ctinteractive', this)">
        <img src="https://garsbet.com/provider/images/ctinteractive.jpg" alt="ctinteractive" />
        <span class="type">CT Gaming</span>
    </div>
    
    <div class="vendor-item vendorId-156" onclick="loadGames('3oaks', this)">
        <img src="https://garsbet.com/provider/images/3oaks.jpg" alt="3oaks" />
        <span class="type">3 Oaks</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('play-son', this)">
        <img src="https://garsbet.com/provider/images/play-son.jpg" alt="play-son" />
        <span class="type">Playson</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('fazi', this)">
        <img src="https://garsbet.com/provider/images/fazi.jpg" alt="fazi" />
        <span class="type">Fazi</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('redstone', this)">
        <img src="https://garsbet.com/provider/images/redstone.jpg" alt="redstone" />
        <span class="type">Redstone</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('tiptop', this)">
        <img src="https://garsbet.com/provider/images/tiptop.jpg" alt="tiptop" />
        <span class="type">TipTop</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('spribe-gh', this)">
        <img src="https://garsbet.com/provider/images/spribe-gh.jpg" alt="spribe-gh" />
        <span class="type">Spribe</span>
    </div>

    <div class="vendor-item vendorId-156" onclick="loadGames('redtiger-gh', this)">
        <img src="https://garsbet.com/provider/images/redtiger-gh.jpg" alt="redtiger-gh" />
        <span class="type">Red Tiger</span>
    </div>

    <div class="vendor-item vendorId-115" onclick="loadGames('netent-gh', this)">
        <img src="https://garsbet.com/provider/images/netent-gh.jpg" alt="netent-gh" />
        <span class="type">NetEnt</span>
    </div>
</div>


<script>
function loadGames(provider, element) {
    // Belirtilen sağlayıcının dosyasını yükle
    const filePath = `../games/casino/${provider}.php`;

    // Burada PHP dosyasını içeri aktarıyoruz
    fetch(filePath)
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.text();
        })
        .then(data => {
            // Oyunları içeren dosyanın içeriğini yerleştir
            document.getElementById('gamesContainer').innerHTML = data; // Burada oyunları göstereceğin bir konteyner olmalı

            // Seçili öğeyi güncelle
            updateActiveVendor(element);
        })
        .catch(error => {
            console.error('Error loading the games:', error);
        });
}

function updateActiveVendor(selectedElement) {
    const vendorItems = document.querySelectorAll('.vendor-item');
    
    // Tüm vendor bağlantılarındaki "active" sınıfını kaldır
    vendorItems.forEach(item => {
        item.classList.remove('active');
    });
    
    // Seçilen öğeye "active" sınıfını ekle
    selectedElement.classList.add('active');
}
</script>

<div id="gamesContainer">
    <?php include "../games/casino/amigogaming.php"; // Varsayılan olarak "hepsi"yi yükle ?>
</div>

</body>
</html>
