<?php
// Simple database check for bonus tables
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$username = 'blacrhdy_bet1';
$password = 'blacrhdy_bet1';

try {
    $db = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Database Connection: OK</h2>";
    
    // Check if tables exist
    $tables = ['personalized_bonuses', 'bonus_talepleri', 'kullanicilar', 'bonus_types', 'parayatir'];
    foreach ($tables as $table) {
        try {
            $stmt = $db->query("SELECT 1 FROM $table LIMIT 1");
            echo "<p>✓ Table '$table' exists</p>";
        } catch (Exception $e) {
            echo "<p style='color: red;'>✗ Table '$table' missing: " . $e->getMessage() . "</p>";
        }
    }
    
    echo "<hr>";
    
    // Count records in each table
    echo "<h2>Record Counts:</h2>";
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM personalized_bonuses");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>personalized_bonuses: <strong>" . $result['count'] . "</strong> records</p>";
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM bonus_talepleri");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>bonus_talepleri: <strong>" . $result['count'] . "</strong> records</p>";
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM kullanicilar");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>kullanicilar: <strong>" . $result['count'] . "</strong> records</p>";
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM bonus_types");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<p>bonus_types: <strong>" . $result['count'] . "</strong> records</p>";
    
    // Today's successful deposits (parayatir)
    try {
        $stmt = $db->query("SELECT COUNT(*) AS count, COALESCE(SUM(miktar),0) AS total FROM parayatir WHERE durum = 1 AND DATE(tarih) = CURDATE()");
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p>parayatir (today, durum=2): <strong>" . ($res['count'] ?? 0) . "</strong> records, total: <strong>" . number_format(($res['total'] ?? 0),2) . "</strong></p>";
    } catch (Exception $e) {
        echo "<p style='color: red;'>parayatir check failed: " . htmlspecialchars($e->getMessage()) . "</p>";
    }
    
    echo "<hr>";
    
    // Show sample data if available
    echo "<h2>Sample Data:</h2>";
    
    // Sample personalized bonuses
    $stmt = $db->query("SELECT pb.id, pb.user_id, k.username, pb.amount, pb.status, pb.created_at 
                       FROM personalized_bonuses pb 
                       LEFT JOIN kullanicilar k ON pb.user_id = k.id 
                       ORDER BY pb.created_at DESC LIMIT 3");
    $bonuses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($bonuses) > 0) {
        echo "<h3>Personalized Bonuses (last 3):</h3>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>User ID</th><th>Username</th><th>Amount</th><th>Status</th><th>Created</th></tr>";
        foreach ($bonuses as $bonus) {
            echo "<tr>";
            echo "<td>" . $bonus['id'] . "</td>";
            echo "<td>" . $bonus['user_id'] . "</td>";
            echo "<td>" . ($bonus['username'] ?? 'N/A') . "</td>";
            echo "<td>" . $bonus['amount'] . "</td>";
            echo "<td>" . $bonus['status'] . "</td>";
            echo "<td>" . $bonus['created_at'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No personalized bonuses found</p>";
    }
    
    // Sample bonus talepleri
    $stmt = $db->query("SELECT bt.id, bt.uye_id, k.username, bt.bonus_turu, bt.miktar, bt.durum, bt.tarih 
                       FROM bonus_talepleri bt 
                       LEFT JOIN kullanicilar k ON bt.uye_id = k.id 
                       ORDER BY bt.tarih DESC LIMIT 3");
    $talepler = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($talepler) > 0) {
        echo "<h3>Bonus Talepleri (last 3):</h3>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>User ID</th><th>Username</th><th>Bonus Türü</th><th>Miktar</th><th>Durum</th><th>Tarih</th></tr>";
        foreach ($talepler as $talep) {
            echo "<tr>";
            echo "<td>" . $talep['id'] . "</td>";
            echo "<td>" . $talep['uye_id'] . "</td>";
            echo "<td>" . ($talep['username'] ?? 'N/A') . "</td>";
            echo "<td>" . $talep['bonus_turu'] . "</td>";
            echo "<td>" . $talep['miktar'] . "</td>";
            echo "<td>" . $talep['durum'] . "</td>";
            echo "<td>" . $talep['tarih'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No bonus talepleri found</p>";
    }
    
    // Sample deposits today
    try {
        $stmt = $db->query("SELECT id, uye, user_id, miktar, durum, tarih FROM parayatir WHERE durum = 1 AND DATE(tarih) = CURDATE() ORDER BY tarih DESC LIMIT 5");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (count($rows) > 0) {
            echo "<h3>parayatir (today, last 5):</h3>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>ID</th><th>uye</th><th>user_id</th><th>miktar</th><th>durum</th><th>tarih</th></tr>";
            foreach ($rows as $r) {
                echo "<tr>";
                echo "<td>" . $r['id'] . "</td>";
                echo "<td>" . $r['uye'] . "</td>";
                echo "<td>" . $r['user_id'] . "</td>";
                echo "<td>" . $r['miktar'] . "</td>";
                echo "<td>" . $r['durum'] . "</td>";
                echo "<td>" . $r['tarih'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p>No deposits today (durum=1)</p>";
        }
    } catch (Exception $e) {
        echo "<p style='color: red;'>parayatir sample failed: " . htmlspecialchars($e->getMessage()) . "</p>";
    }
    
} catch (PDOException $e) {
    echo "<h2 style='color: red;'>Database Error</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>