<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game Yönetimi</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        input[type="text"] {
            width: 70%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            margin-right: 10px;
        }
        button {
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }
        th {
            background-color: #f4f4f9;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
    </style>
    <script>
        async function searchGames() {
            const providerGame = document.getElementById("providerGame").value;
            const response = await fetch(`cover.php?provider_game=${providerGame}`);
            const games = await response.json();

            const tableBody = document.getElementById("gameList");
            tableBody.innerHTML = ""; // Listeyi temizle

            games.forEach(game => {
                const row = `<tr>
                    <td>${game.id}</td>
                    <td>${game.game_name}</td>
                    <td>${game.provider_game}</td>
                    <td>${game.banner}</td>
                    <td>${game.cover}</td>
                </tr>`;
                tableBody.innerHTML += row;
            });
        }

        async function updateAllCovers() {
            const providerGame = document.getElementById("providerGame").value;
            if (!providerGame) {
                alert("Lütfen bir provider_game değeri girin.");
                return;
            }

            const formData = new FormData();
            formData.append("provider_game", providerGame);

            const response = await fetch("cover.php", {
                method: "POST",
                body: formData,
            });

            const result = await response.json();
            alert(result.message);
            searchGames(); // Listeyi yenile
        }
    </script>
</head>
<body>
    <div class="container">
        <h1>Game Yönetimi</h1>
        <div>
            <input type="text" id="providerGame" placeholder="Provider Game ile ara">
            <button onclick="searchGames()">Ara</button>
            <button onclick="updateAllCovers()">Tümünü Güncelle</button>
        </div>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Oyun Adı</th>
                    <th>Provider Game</th>
                    <th>Banner</th>
                    <th>Cover</th>
                </tr>
            </thead>
            <tbody id="gameList"></tbody>
        </table>
    </div>
</body>
</html>
