<?php
// Veritabanı bağlantısı
$host = 'localhost';
$db = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

$conn = new mysqli($host, $user, $pass, $db);

// Bağlantı kontrolü
if ($conn->connect_error) {
    die("Bağlantı hatası: " . $conn->connect_error);
}

// Veritabanı güncellemesi
$alterQueries = [
    "ALTER TABLE kullanicilar ADD COLUMN IF NOT EXISTS reset_token VARCHAR(255) DEFAULT NULL",
    "ALTER TABLE kullanicilar ADD COLUMN IF NOT EXISTS reset_token_expires DATETIME DEFAULT NULL"
];

$success = true;
$messages = [];

foreach ($alterQueries as $query) {
    if (!$conn->query($query)) {
        $success = false;
        $messages[] = "Hata: " . $conn->error . " (Sorgu: $query)";
    } else {
        $messages[] = "Başarılı: $query";
    }
}

// Sonuçları göster
echo "<h2>Veritabanı Güncelleme Sonuçları</h2>";
if ($success) {
    echo "<p style='color: green;'>Tüm güncellemeler başarıyla tamamlandı!</p>";
} else {
    echo "<p style='color: red;'>Bazı güncellemeler sırasında hatalar oluştu.</p>";
}

echo "<ul>";
foreach ($messages as $message) {
    if (strpos($message, "Hata") === 0) {
        echo "<li style='color: red;'>$message</li>";
    } else {
        echo "<li style='color: green;'>$message</li>";
    }
}
echo "</ul>";

// Bağlantıyı kapat
$conn->close();
?>