<?php
// Direct API test
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['admin_id'] = 1;

// Set up the request
$_GET['action'] = 'admin_get_bonuses';
$_GET['status'] = '';

// Start output buffering
ob_start();

// Include the API
include 'api/bonus_system.php';

// Get the output
$output = ob_get_clean();

// Display results
echo "<h1>Direct API Test Results</h1>";
echo "<h2>Raw JSON Output:</h2>";
echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ccc; overflow: auto;'>";
echo htmlspecialchars($output);
echo "</pre>";

// Parse and display the response
$response = json_decode($output, true);
if ($response) {
    echo "<h2>Parsed Response:</h2>";
    echo "<table border='1' cellpadding='10'>";
    echo "<tr><td><strong>Success:</strong></td><td>" . ($response['success'] ? '<span style="color: green;">Yes</span>' : '<span style="color: red;">No</span>') . "</td></tr>";
    
    if (isset($response['message'])) {
        echo "<tr><td><strong>Message:</strong></td><td>" . htmlspecialchars($response['message']) . "</td></tr>";
    }
    
    if (isset($response['bonuses'])) {
        echo "<tr><td><strong>Bonuses Count:</strong></td><td>" . count($response['bonuses']) . "</td></tr>";
        
        if (count($response['bonuses']) > 0) {
            echo "<tr><td><strong>First Bonus:</strong></td><td><pre>" . print_r($response['bonuses'][0], true) . "</pre></td></tr>";
        }
    }
    
    if (isset($response['debug'])) {
        echo "<tr><td><strong>Debug Info:</strong></td><td><pre>" . print_r($response['debug'], true) . "</pre></td></tr>";
    }
    
    echo "</table>";
} else {
    echo "<p style='color: red;'>Failed to parse JSON response</p>";
}

echo "<hr>";
echo "<h2>Session Information:</h2>";
echo "<pre>" . print_r($_SESSION, true) . "</pre>";

echo "<h2>GET Parameters:</h2>";
echo "<pre>" . print_r($_GET, true) . "</pre>";
?>