<?php
session_start();

// Veritabanı Bağlantısı
$host = 'localhost';
$dbname = 'u168255904_yeni';
$user = 'u168255904_yeni';
$pass = '>cy5Rr[AJ4i';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo 'Veritabanı bağlantı hatası: ' . $e->getMessage();
    exit;
}

// Oyunları almak için fonksiyon
function getGames() {
    global $pdo;
    $sql = "SELECT game_code, game_name, game_image FROM egt_games";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$is_logged_in = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;

// Tüm oyunları al
$games = getGames();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Oyunlar</title>
    <style>
        .game-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            grid-gap: 20px;
            margin: 20px;
        }

        .game-item {
            text-align: center;
            color: white;
        }

        .game-item img {
            width: 100%;
            height: auto;
            cursor: pointer;
            border-radius: 10px;
            transition: 0.3s;
        }

        .game-item img:hover {
            transform: scale(1.05);
        }
    </style>
</head>
<body>

<div class="game-grid" id="game-grid">
    <?php foreach ($games as $game): ?>
        <div class="game-item">
            <img src="<?= htmlspecialchars($game['game_image'], ENT_QUOTES); ?>" 
                 alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>" 
                 onclick="openGameInNewTab('<?= $is_logged_in ? '/tbs2/game.php?gameid=' . $game['game_code'] : '/tbs2/demo.php?gameid=' . $game['game_code']; ?>')">
            <p><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?></p>
        </div>
    <?php endforeach; ?>
</div>

<script>
    function openGameInNewTab(url) {
        // Oyunu yeni sekmede aç
        window.open(url, '_blank'); // '_blank' parametresi yeni sekmede açmayı sağlar
    }
</script>

</body>
</html>

<?php include '../../../../m/tr/includes/footer.php'; ?>
