<?php
session_start(); // Oturum başlat

// Kullanıcının giriş yapıp yapmadığını kontrol et
$isLoggedIn = isset($_SESSION['loggedin']) && $_SESSION['loggedin'];

// Eğer giriş yapılmışsa, kullanıcı adını al
$userUsername = $isLoggedIn ? $_SESSION['username'] : '';

// Veritabanı bağlantısı (MySQLi örneği)
$servername = "localhost";
$username2 = "blacrhdy_bet1";
$password2 = "blacrhdy_bet1";
$dbname = "blacrhdy_bet1";

$conn = new mysqli($servername, $username2, $password2, $dbname);

// Bağlantı kontrolü, hata mesajı göstermemek için sadece bağlantıyı kapatıyoruz
if ($conn->connect_error) {
    exit; // Bağlantı hatası durumunda hiçbir şey göstermiyoruz
}

// Eğer kullanıcı oturum açmamışsa, oturum açmamış kullanıcı için bakiyeyi almayacağız
$userBalance = null;
if (!empty($userUsername)) {
    // Aktif kullanıcının bakiyesini çekmek için SQL sorgusu
    $sql = "SELECT ana_bakiye FROM kullanicilar WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $userUsername); // "s" parametre tipi, burada kullanici_adi bir string'dir
    $stmt->execute();
    $stmt->bind_result($userBalance);
    $stmt->fetch();
    $stmt->close();
}

// Veritabanı bağlantısını kapat
$conn->close();

// Oturumdaki bakiyeyi PHP'ye aktar
$_SESSION['ana_bakiye'] = $userBalance;

?>





<!-- SweetAlert CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<!-- SweetAlert JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<html lang="tr" class="browser-Chrome" style="--vh: 6.67px;">

<head>
    <meta charset="utf-8">
    <title data-rh="true"></title>



    <meta name="viewport" content="width=device-width, maximum-scale=1, viewport-fit=cover">


    <link data-chunk="main" rel="stylesheet" href="/sporassets/main.15203e0c84ea961ee027.css">
    <link data-chunk="theme" rel="stylesheet" href="/sporassets/theme.3ed7d24f26ca4b2477c4.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/3.5ea1511a7cce485e81ae.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/0.38c1ac79ecf1be31d551.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/2.604450a90727135839a1.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/1.b3fcf877461209e39ccd.css">
    <link data-chunk="home" rel="stylesheet" href="/sporassets/6.3b5480dc1d9cd739b966.css">

    <!-- Env variables -->
    <script type="text/javascript">
        Object.defineProperty(window, 'PROCESS_ENV', {
            value: Object.freeze({ "NODE_ENV": "production", "PROJECT_ENV": "production", "BETTING_PLATFORM_SVC_URL": "https://sportsbook-betting-betby-prod-2.gtdevteam.work", "BETTING_PLATFORM_SVC_TENANT_ID": "be607739-89aa-4e11-a32f-6521cbf19241", "BETTING_PLATFORM_CMS_SVC_URL": "https://sportsbook-cms-svc-prod.gtdevteam.work", "BETTING_PLATFORM_CONFIG_SVC_URL": "https://sportsbook-betting-config-svc-prod.gtdevteam.work", "MAINTENANCE_WHITELISTED_IPS": "217.21.60.69,54.247.131.117,193.161.14.148,128.124.60.16,79.110.133.34,93.73.252.12,178.158.194.96", "GTAG": "G-Q2QHHDJV3K", "SENTRY_DSN": "https://dc2208bdb44da909920fd615e6557580@o249775.ingest.sentry.io/4506240876871680", "BETBY_API_URL": "https://sportsbook-betting-betby-prod-2.gtdevteam.work/v3", "BETBY_API_URL_V2": "https://sportsbook-betting-betby-prod-2.gtdevteam.work/v3", "BETBY_BRAND_ID": "2346016880764006400", "BETBY_LIVE_TRACKER_URL": "https://start9.sptpub.com", "BETBY_WS_URL": "wss://api1-ws.sptpub.com/api/v1", "BETBY_RINDLES_URL": "https://s.sptpub.com/92a4b2bb", "BRAND_NAME": "casipol" }),
            writable: false
        });
        window.__HISTORY_STATE__ = undefined;
    </script>
    <!-- End Env variables-->
    <link rel="stylesheet" type="text/css" href="/sporassets/13.ca7386153f0814e7c5d8.css">
    <script charset="utf-8" src="/sporassets/13.8612bbd3e0340393cd4c.js"></script>
    <link rel="stylesheet" type="text/css" href="/sporassets/7.10632a04adb21a618427.css">
    <script charset="utf-8" src="/sporassets/7.2248abf3440d4330b8d4.js"></script>
    <link rel="stylesheet" type="text/css" href="/sporassets/14.9db4012bbd33c75bb025.css">
    <script charset="utf-8" src="/sporassets/14.e3271ab1d0c2e480b8a9.js"></script>
    <link rel="stylesheet" type="text/css" href="/sporassets/8.3ef50a8872af6f1632a0.css">
    <script charset="utf-8" src="/sporassets/8.a500c882c1ef3af42595.js"></script>
</head>

<body class="">

    <div id="root" class="container-min-width d-flex flex-column">
        <div class="global-notifications-stack position-fixed d-flex flex-column px-1 mt-sm-3 px-sm-2"></div>
        <div class="main-bg-wrapper overflow-hidden position-absolute">
            <div class="main-bg position-absolute main-bg-default main-bg-undefined"></div>
        </div>
        <div class="d-flex main-content">
            <div class="left-sidebar d-none d-lg-block bg-main-2 pb-4 flex-shrink-0"></div>
            <div class="d-flex flex-column central-part position-relative px-0 px-sm-2 container-fluid">
                <div class="header-main d-flex flex-column mx-sm-n2 flex-shrink-0 bg-main-3">
                    <div class="sports-menu d-flex justify-content-between align-items-center"><span class="caption ml-1 pl-0_25 text-nowrap text-extra-2">Oranlar</span></span>
                    </div>
                </div>

<style>

    

/* Oran için modern görünüm */
.modern-odd {
    background-color: #28a745; /* Yeşil arka plan */
    color: #fff; /* Beyaz yazı */
    font-size: 18px; /* Büyük yazı */
    font-weight: bold; /* Kalın yazı */
    padding: 5px 10px; /* İç boşluk */
    border-radius: 5px; /* Yuvarlatılmış köşeler */
    display: inline-block; /* Inline görünüm */
    text-align: center; /* Metin hizalama */
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2); /* Hafif gölge */
    transition: background-color 0.3s ease, transform 0.2s ease; /* Animasyon */
}

/* Hover efekti */
.modern-odd:hover {
    background-color: #218838; /* Daha koyu yeşil */
    transform: scale(1.05); /* Hafif büyüme efekti */
}

/* Diğer tasarım iyileştirmeleri */
.stake-item {
    margin-bottom: 15px;
    padding: 15px;
}

.stake-item .d-flex {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.remove-odd {
    margin-top: 10px;
    color: #dc3545; /* Kırmızı yazı */
    cursor: pointer;
    font-weight: bold;
    text-align: center;
    padding: 5px 10px;
    border-radius: 5px;
    background-color: #f8d7da; /* Hafif kırmızı arka plan */
    transition: background-color 0.3s ease, color 0.3s ease;
}

.remove-odd:hover {
    background-color: #f5c6cb; /* Daha koyu kırmızı */
    color: #721c24; /* Koyu kırmızı yazı */
}

.bet-amount-input {
    position: relative;
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 15px;
    background-color: #2c2c2c; /* Arka plan koyu gri */
    border-radius: 8px; /* Yuvarlatılmış köşeler */
    padding: 10px 15px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.3); /* Hafif gölge */
}


.stake-amount {
    width: 100px; /* Giriş alanının genişliği */
    padding: 8px;
    font-size: 16px;
    font-weight: bold;
    background-color: #1a1a1a; /* Koyu arka plan */
    color: #e0e0e0; /* Açık gri yazı rengi */
    border: 1px solid #444; /* İnce çerçeve */
    border-radius: 5px; /* Yuvarlatılmış kenarlar */
    text-align: right; /* Yazıyı sağa yasla */
    outline: none; /* Odak çerçevesini kaldır */
    transition: all 0.3s ease; /* Pürüzsüz animasyon */
}

.stake-amount:focus {
    border-color: #888; /* Odaklanınca çerçeve rengi */
    box-shadow: 0 0 8px rgba(136, 136, 136, 0.5); /* Hafif bir parlama */
    background-color: #333; /* Odaklanınca arka plan rengi */
}

.bet-amount-input-currency {
    color: #b3b3b3; /* Gri tonunda yazı rengi */
    font-size: 14px;
    font-weight: 600; /* Hafif kalın yazı */
    pointer-events: none; /* Kullanıcı ile etkileşim engellendi */
    margin-left: auto; /* Giriş alanının sağına hizalar */
}

.bet-amount-input:hover {
    background-color: #333; /* Hover efekti için daha koyu gri */
}

.bet-amount-input-currency::before {
    content: "₺"; /* Para birimi sembolü */
    margin-right: 5px;
    color: #f2f2f2; /* Hafif açık gri sembol */
}


.selected-odd {
    background-color: lightblue; /* Or any light color to highlight the selected odd */
}



/* Ülke başlıkları */
.country-item {
  margin-bottom: 15px;
}

.country-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px;
  border: 1px solid #ddd;
  cursor: pointer;
  border-radius: 5px;
}

.country-name {
  font-size: 16px;
  font-weight: bold;
}

.arrow-icon {
  transition: transform 0.3s ease-in-out;
}

/* Ligler listesi */
.league-container-wrapper {
  margin-top: 10px;
}

.leagues-container {
  padding: 10px;
  border: 1px solid #ddd;
  border-radius: 5px;
  display: none;
}

/* Lig öğeleri */
.league-item {
  padding: 8px;
  margin-bottom: 5px;
  border-radius: 3px;
  cursor: pointer;
}

.league-item:hover {
  background-color: #d3d3d3;
}

/* Arrow icon transformations */
.arrow-icon.rotate {
  transform: rotate(90deg);
}




</style>
    <div id="event-list"></div>



<script>

const API_BASE_URL = 'https://ariabet.tech/api';

// 7. Etkinlik listesini almak
async function fetchEvents(url) {
    try {
        // URL'den parametreleri almak
        const urlParams = new URLSearchParams(new URL(url).search);
        const leagueId = urlParams.get('leagueId');
        const sportId = urlParams.get('sportId');

        if (!leagueId || !sportId) {
            throw new Error('URL parametreleri eksik');
        }

        // API'ye istek gönderiliyor
        const response = await fetch(`${API_BASE_URL}/events?champId=${leagueId}&sportId=${sportId}`);
        
        // Eğer istek başarılı değilse hata fırlatılıyor
        if (!response.ok) throw new Error('Etkinlik listesi yüklenirken hata oluştu');
        
        // JSON verisi alınıyor
        const events = await response.json();
        
        // Etkinlikler ekranda görüntüleniyor
        displayEvents(events, sportId, leagueId);
    } catch (error) {
        // Hata mesajı
        console.error('Etkinlik listesi yüklenemedi:', error);
        alert('Etkinlik listesi yüklenemedi. Lütfen daha sonra tekrar deneyin.');
    }
}

// Sayfa yüklendiğinde otomatik olarak maçları listele
window.onload = () => {
    // URL'yi belirleyin (örneğin, doğrudan URL'yi kullanabilirsiniz)
    const url = window.location.href; // veya özel bir URL kullanabilirsiniz
    fetchEvents(url);
};


    
    function displayEvents(events, sport, league) {
        const eventListElement = document.getElementById('event-list');
        eventListElement.innerHTML = '';  // Clear previous events
    
        events.forEach(event => {
            // Event container
            const eventContainer = document.createElement('div');
            eventContainer.classList.add('event-item', 'bg-main-2', 'p-2', 'rounded');
    
            // Event details
            const eventDetails = document.createElement('div');
            eventDetails.classList.add('event-details');
            
            const eventName = document.createElement('h3');
            eventName.classList.add('font-bold', 'text-lg');
            eventName.textContent = `${event.N} - OC: ${event.OC || 'Bilgi Yok'}`;
    
            const eventTime = document.createElement('p');
            eventTime.classList.add('text-sm', 'text-gray-600');
            eventTime.textContent = `Zaman: ${event.D || 'TBA'}`;
    
            // Odds container
            const oddsContainer = document.createElement('div');
            oddsContainer.classList.add('odds-container', 'position-relative');
    
            if (event.StakeTypes && event.StakeTypes.length > 0) {
                event.StakeTypes.forEach(stakeType => {
                    const marketName = document.createElement('div');
                    marketName.classList.add('market-name', 'text-center', 'mt-1');
                    const marketTitle = document.createElement('span');
                    marketTitle.classList.add('text-nowrap', 'text-extra-3');
                    marketTitle.textContent = stakeType.N;
                    marketName.appendChild(marketTitle);
                    oddsContainer.appendChild(marketName);
    
                    // Odds scroll container
                    const oddsScrollWrapper = document.createElement('div');
                    oddsScrollWrapper.classList.add('odds-scroll-wrapper', 'd-flex', 'overflow-auto', 'mt-2');
    
                    stakeType.Stakes.forEach(stake => {
                        const outcomeWrapper = document.createElement('div');
                        outcomeWrapper.classList.add('outcome-wrapper', 'odd-cell', 'd-flex', 'flex-column', 'justify-content-between', 'align-items-center', 'text-small', 'px-2', 'py-1', 'mr-2');
    
                        const oddLabel = document.createElement('span');
                        oddLabel.classList.add('odd-cell-label', 'text-nowrap');
                        oddLabel.textContent = stake.A !== null && stake.A !== undefined ? `${stake.N} (${stake.A >= 0 ? '+' : ''}${stake.A})` : stake.N;
    
                        const oddValue = document.createElement('div');
                        oddValue.classList.add('odd-cell-value', 'd-flex', 'align-items-center', 'justify-content-center');
                        const rankArrow = document.createElement('div');
                        rankArrow.classList.add('rank-arrow', 'font-weight-bold');
                        rankArrow.textContent = stake.F;
    
                        oddValue.appendChild(rankArrow);
                        outcomeWrapper.appendChild(oddLabel);
                        outcomeWrapper.appendChild(oddValue);
                        oddsScrollWrapper.appendChild(outcomeWrapper);
    
                        // Add click event for selecting odds
                        outcomeWrapper.addEventListener('click', () => handleOddSelection(outcomeWrapper, event));
                    });
    
                    oddsContainer.appendChild(oddsScrollWrapper);
                });
            } else {
                const noOdds = document.createElement('div');
                noOdds.textContent = 'Oranlar mevcut değil';
                oddsContainer.appendChild(noOdds);
            }
    
            // Event details
            eventDetails.appendChild(eventName);
            eventDetails.appendChild(eventTime);
            eventDetails.appendChild(oddsContainer);
    
            // Add event details to event container
            eventContainer.appendChild(eventDetails);
            eventListElement.appendChild(eventContainer);
        });
    }
    
    
    // Mobile bet slip toggle functionality
let isBetSlipOpen = false;

function toggleMobileBetSlip() {
    const ticketMobile = document.getElementById('ticket-mobile');
    isBetSlipOpen = !isBetSlipOpen;
    ticketMobile.classList.toggle('is-opened', isBetSlipOpen);
    updateTicketCount();
}

function updateTicketCount() {
    const ticketCount = document.querySelector('.ticket-small-count');
    const betSlipItems = document.querySelectorAll('.stake-item');
    if (ticketCount) {
        ticketCount.textContent = betSlipItems.length.toString();
    }
}

// Add odds to the bet slip
let selectedOdds = {}; // Track selected odds

function handleOddSelection(outcomeWrapper, event, category) {
    const betSlipContent = document.getElementById('bet-slip-content');
    const eventId = event.Id;
    const selectedOddValue = parseFloat(outcomeWrapper.querySelector('.rank-arrow').textContent);

    if (selectedOdds[eventId]) {
        if (selectedOdds[eventId] === outcomeWrapper) {
            return;
        }
    } else {
        outcomeWrapper.classList.add('selected-odd');
        selectedOdds[eventId] = outcomeWrapper;
        addToBetSlip(event, selectedOddValue, category);
    }
    updateTicketCount();
}

// Date and time formatting functions remain the same
function formatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('tr-TR', { day: '2-digit', month: '2-digit', year: 'numeric' });
}

function formatTime(dateString) {
    const date = new Date(dateString);
    return date.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit' });
}

let totalOdds = 0;
let totalStakeAmount = 10;

function addToBetSlip(event, oddValue, category) {
    const betSlipContent = document.getElementById('bet-slip-content');
    const eventId = event.Id;

    const eventDate = formatDate(event.D);
    const eventTime = formatTime(event.D);

    const selectedOddElement = selectedOdds[eventId];
    const selectedOddLabel = selectedOddElement 
        ? selectedOddElement.querySelector('.odd-cell-label').textContent 
        : 'N/A';

    const marketNameElement = selectedOddElement 
        ? selectedOddElement.closest('.odds-container').querySelector('.market-name span')
        : null;
    const marketName = marketNameElement 
        ? marketNameElement.textContent 
        : 'Belirtilmedi';

    const stakeItemHTML = `
        <div class="stake-item" id="stake-item-${eventId}">
            <div class="d-flex justify-content-between">
                <span class="event-name">${event.N}</span>
                <span class="odd-value modern-odd">${oddValue}</span>
            </div>
            <div class="bet-category">
                <span class="odd-label">Seçim: ${selectedOddLabel}</span> |
                <span class="teams">Market: ${marketName}</span>
            </div>
            <div class="bet-category">
                Tarih: ${eventDate} Saat: ${eventTime}
            </div>
            <div class="remove-odd" role="button" onclick="removeFromBetSlip('${eventId}', ${oddValue})">Kaldır</div>
        </div>
    `;

    betSlipContent.insertAdjacentHTML('beforeend', stakeItemHTML);
    totalOdds += oddValue;
    
    if (betSlipContent.querySelector('.bet-amount-input') === null) {
        const stakeAmountHTML = `
            <div class="bet-amount-input">
                <input 
                    type="number" 
                    class="stake-amount" 
                    id="stake-amount"
                    value="${totalStakeAmount}"
                />
                <div class="bet-amount-input-currency">TL</div>
            </div>
            <div class="potential-winnings" id="potential-winnings">
                Muhtemel Kazanç: ${(totalStakeAmount * totalOdds).toFixed(2)} TL
            </div>
        `;
        betSlipContent.insertAdjacentHTML('beforeend', stakeAmountHTML);

        const stakeAmountInput = document.getElementById('stake-amount');
        if (stakeAmountInput) {
            stakeAmountInput.addEventListener('input', updatePotentialWinnings);
        }
    } else {
        updatePotentialWinnings();
    }

    moveToBottom();
    updateTicketCount();
}

function removeFromBetSlip(eventId, oddValue) {
    const stakeItem = document.getElementById(`stake-item-${eventId}`);
    if (stakeItem) stakeItem.remove();

    totalOdds -= oddValue;

    const outcomeWrapper = selectedOdds[eventId];
    if (outcomeWrapper) {
        outcomeWrapper.classList.remove('selected-odd');
        delete selectedOdds[eventId];
    }

    const betSlipContent = document.getElementById('bet-slip-content');
    const remainingItems = betSlipContent.querySelectorAll('.stake-item');

    if (remainingItems.length === 0) {
        const betAmountInput = document.querySelector('.bet-amount-input');
        const potentialWinnings = document.querySelector('.potential-winnings');
        
        if (betAmountInput) betAmountInput.remove();
        if (potentialWinnings) potentialWinnings.remove();
    } else {
        updatePotentialWinnings();
    }
    
    updateTicketCount();
}

// Other functions remain the same
function updatePotentialWinnings() {
    const stakeAmountInput = document.getElementById('stake-amount');
    const potentialWinningsElement = document.getElementById('potential-winnings');

    if (!stakeAmountInput || !potentialWinningsElement) {
        return;
    }

    const stakeAmount = parseFloat(stakeAmountInput.value);

    if (isNaN(stakeAmount) || stakeAmount <= 0 || isNaN(totalOdds) || totalOdds <= 0) {
        potentialWinningsElement.textContent = "Muhtemel Kazanç: 0.00 TL";
        return;
    }

    const potentialWinnings = stakeAmount * totalOdds;
    potentialWinningsElement.textContent = `Muhtemel Kazanç: ${potentialWinnings.toFixed(2)} TL`;
}

function moveToBottom() {
    const betSlipContent = document.getElementById('bet-slip-content');
    betSlipContent.scrollTop = betSlipContent.scrollHeight;

    const stakeAmountInput = document.getElementById('stake-amount');
    const potentialWinningsElement = document.getElementById('potential-winnings');

    if (stakeAmountInput && potentialWinningsElement) {
        betSlipContent.appendChild(stakeAmountInput.parentElement);
        betSlipContent.appendChild(potentialWinningsElement);
    }
}

document.addEventListener('DOMContentLoaded', () => {
    const betSlipContent = document.getElementById('bet-slip-content');
    const isUserLoggedIn = <?php echo json_encode($isLoggedIn); ?>;
    const userBalance = <?php echo json_encode($userBalance); ?>;
    const minBetAmount = <?php echo json_encode($minBetAmount); ?>;

    // Add mobile bet slip toggle button
    const toggleButton = document.querySelector('.ticket-small');
    if (toggleButton) {
        toggleButton.addEventListener('click', toggleMobileBetSlip);
    }

    // Add close button functionality
    const closeButton = document.querySelector('.ticket-mobile-bet-slip-title [role="button"]');
    if (closeButton) {
        closeButton.addEventListener('click', toggleMobileBetSlip);
    }

    if (betSlipContent) {
        const betSlipFooter = document.createElement('div');
        betSlipFooter.className = 'bet-slip-footer pb-2_5 pt-2 bg-main-4 is-ordinar';
        betSlipFooter.innerHTML = `
            <div class="d-flex align-items-center"></div>
            <button type="button" class="position-relative btn btn-primary btn-sm btn-block">
                <div class="btn-content"><span>Bahis yap</span></div>
            </button>
        `;

        // For mobile view, append to the ticket-mobile container
        const ticketMobile = document.getElementById('ticket-mobile');
        if (ticketMobile) {
            ticketMobile.appendChild(betSlipFooter);
        } else {
            betSlipContent.parentElement.appendChild(betSlipFooter);
        }

       const betButton = betSlipFooter.querySelector('button');
        betButton.addEventListener('click', () => {
            if (!isUserLoggedIn) {
                Swal.fire({
                    icon: 'error',
                    title: 'Giriş Yapınız',
                    text: 'Bahis yapabilmek için lütfen giriş yapınız.',
                });
                return;
            }

            const stakeAmountInput = document.getElementById('stake-amount');
            const stakeAmount = stakeAmountInput ? parseFloat(stakeAmountInput.value) : 0;

            if (stakeAmount < minBetAmount) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Yetersiz Bahis Tutarı',
                    text: `Minimum bahis tutarı ${minBetAmount} TL olmalıdır.`,
                });
                return;
            }

            if (userBalance < stakeAmount) {
                Swal.fire({
                    icon: 'error',
                    title: 'Yetersiz Bakiye',
                    text: 'Bahis yapmak için lütfen bakiyenizi yükleyin.',
                });
                return;
            }

            if (betSlipContent.querySelectorAll('.stake-item').length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Kupon Boş',
                    text: 'Lütfen bahis seçimi yapın.',
                });
                return;
            }

            Swal.fire({
                icon: 'success',
                title: 'Kupon Kaydediliyor',
                text: 'Kuponunuz başarıyla kaydediliyor...',
            }).then(() => {
                processBetSlip(stakeAmount); // Bahis işlemini başlat
            });
        });
    }
});


function processBetSlip(stakeAmount) {
    const betSlipContent = document.getElementById('bet-slip-content');
    const betItems = betSlipContent.querySelectorAll('.stake-item');

    if (!betItems || betItems.length === 0) {
        console.error('No bet items found.');
        return;
    }

    const bets = Array.from(betItems).map(item => {
        const eventName = item.querySelector('.event-name').textContent;
        const oddValueElement = item.querySelector('.odd-value');
        const oddValue = oddValueElement ? parseFloat(oddValueElement.textContent) : 0;
        const eventId = item.id.replace('stake-item-', '');

        // Tarih ve saat bilgilerini al
        const dateTimeElement = item.querySelector('.bet-category:nth-child(3)');
        let eventDate = 'Bilinmiyor';
        let eventTime = 'Bilinmiyor';
        if (dateTimeElement) {
            const dateTimeText = dateTimeElement.textContent.trim();
            const dateMatch = dateTimeText.match(/Tarih: (.*?) Saat:/);
            const timeMatch = dateTimeText.match(/Saat: (.*)/);

            eventDate = dateMatch ? dateMatch[1].trim() : 'Bilinmiyor';
            eventTime = timeMatch ? timeMatch[1].trim() : 'Bilinmiyor';
        }

        // Tarih ve saat birleşimi: YYYY-MM-DD HH:mm:ss
        let eventDateTime = null;
        if (eventDate !== 'Bilinmiyor' && eventTime !== 'Bilinmiyor') {
            const dateParts = eventDate.split('.');
            const formattedDate = `${dateParts[2]}-${dateParts[1]}-${dateParts[0]}`; // '24.01.2025' -> '2025-01-24'
            eventDateTime = `${formattedDate} ${eventTime}:00`; // '2025-01-24 15:00:00'
        }

        const selectedOddLabel = item.querySelector('.odd-label').textContent.split(': ')[1];
        const marketName = item.querySelector('.teams').textContent.split(': ')[1];

        const potentialWinnings = (stakeAmount * oddValue).toFixed(2);

        return {
            eventId: eventId,
            eventName: eventName,
            oddValue: oddValue,
            stakeAmount: stakeAmount,
            eventDateTime: eventDateTime, // SQL için formatlanmış tarih-saat
            selectedOddLabel: selectedOddLabel,
            marketName: marketName,
            potentialWinnings: potentialWinnings,
            status: 'Bekliyor',
        };
    });

    const betDescription = bets.length === 1 
        ? 'Tekli bahis' 
        : `${bets.length}’li bahis`;

    const payload = {
        stakeAmount,
        betDescription,
        bets,
    };

    fetch('/save-bet-slip.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(payload),
    })
    .then(response => response.json())
    .then(data => {
        console.log('Server Response:', data);
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Başarılı',
                text: 'Kuponunuz başarıyla kaydedildi.',
            });
            location.reload();
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Hata',
                text: data.message || 'Kupon kaydedilirken bir hata oluştu.',
            });
        }
    })
    .catch(error => {
        console.error('Error saving bet slip:', error);
        Swal.fire({
            icon: 'error',
            title: 'Hata',
            text: 'Bir hata oluştu. Lütfen tekrar deneyin.',
        });
    });
}






    
    
    // Etkinlik detaylarını almak
    async function fetchEventDetails(event, sport, league) {
        console.log('Detayları al:', event);
    }</script>
    
    


</body>
</html>
<style></style>


<div
    class="navigation-bar d-flex align-items-center justify-content-between d-lg-none position-fixed px-3 mx-1 bg-main-5">

   
<div role="button" tabindex="0" class="ticket-small rounded-circle position-relative d-flex align-items-center justify-content-center" style="
    left: inherit;
"><svg
            xmlns="http://www.w3.org/2000/svg" width="20" height="24" viewBox="0 0 20 24">
            <g fill="none" stroke="#0c1217" stroke-width="2" transform="translate(1 1)">
                <rect width="18" height="19" rx="2"></rect>
                <path d="M2 19h14v1c0 1.105-.895 2-2 2H4c-1.105 0-2-.895-2-2v-1h0z"></path>
            </g>
        </svg>
        
        
        <span class="ticket-small-count font-weight-bold position-absolute text-extra-8">0</span></div>
        
        
        
        
        
        <!--spor betsslip-->


        

 
 
        <div id="ticket-mobile" class="ticket-mobile position-fixed d-lg-none mt-3_5">
    <div class="ticket-mobile-bet-slip-title d-flex align-items-center justify-content-between px-1_5 bg-main-5">
        <span class="font-weight-bold">Kupon</span>
        <div role="button" tabindex="0" onclick="toggleBetSlip()">
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM3.95958 5.37379L6.58582 8.00004L3.95958 10.6263L5.37379 12.0405L8.00004 9.41425L10.6262 12.0405L12.0405 10.6262L9.41425 8.00004L12.0405 5.37383L10.6262 3.95962L8.00004 6.58582L5.37379 3.95958L3.95958 5.37379Z"
                    fill="white" fill-opacity="0.3"></path>
            </svg>
        </div>
    </div>

    <!-- Bet Slip Content - Initially Hidden -->
    <div id="bet-slip-content" class="overflow-auto" style="display: block; max-height: 300px;">
        <!-- New bets will be inserted here dynamically -->
    </div>

   
</div>

        
        
        <svg width="0" height="0">
            <defs>
                <linearGradient id="icon-no-bets-a" x1="86.018%" x2="44.145%" y1="40.619%" y2="50%">
                    <stop offset="0%" stop-color="#1A1A1E"></stop>
                    <stop offset="100%"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-c" x1="17.501%" x2="54.003%" y1="43.172%" y2="47.597%">
                    <stop offset="0%" stop-color="#1A1A1E"></stop>
                    <stop offset="100%"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-d" x1="26.415%" x2="78.955%" y1="30.393%" y2="74.066%">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-e" x1="27.551%" x2="81.011%" y1="29.955%" y2="74.824%">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-g" x1="24.353%" x2="81.49%" y1="38.372%" y2="64.277%">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-h" x1="26.733%" x2="38.588%" y1="46.702%" y2="51.67%">
                    <stop offset="0%" stop-color="#2979FF"></stop>
                    <stop offset="100%" stop-color="#1958C4"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-j" x1="0%" x2="110.577%" y1="2.548%" y2="133.649%">
                    <stop offset="0%" stop-color="#1A1A1E"></stop>
                    <stop offset="100%"></stop>
                </linearGradient>
                <linearGradient id="icon-no-bets-k" x1="23.461%" x2="87.575%" y1="21.702%" y2="90.066%">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </linearGradient>
                <radialGradient id="icon-no-bets-b" cx="58.304%" cy="91.129%" r="26.734%" fx="58.304%" fy="91.129%"
                    gradientTransform="matrix(.75065 0 0 1 .145 0)">
                    <stop offset="0%"></stop>
                    <stop offset="100%" stop-opacity="0"></stop>
                </radialGradient>
                <radialGradient id="icon-no-bets-f" cx="24.377%" cy="11.965%" r="74.272%" fx="24.377%" fy="11.965%"
                    gradientTransform="matrix(.99716 0 0 1 0 0)">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </radialGradient>
                <radialGradient id="icon-no-bets-i" cx="33.533%" cy="22.114%" r="67.975%" fx="33.533%" fy="22.114%"
                    gradientTransform="matrix(.99715 0 0 1 .001 0)">
                    <stop offset="0%" stop-color="#323438"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </radialGradient>
                <radialGradient id="icon-no-bets-l" cx="33.532%" cy="22.114%" r="67.975%" fx="33.532%" fy="22.114%"
                    gradientTransform="matrix(.99715 0 0 1 .001 0)">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </radialGradient>
                <radialGradient id="icon-no-bets-m" cx="33.532%" cy="22.115%" r="67.976%" fx="33.532%" fy="22.115%"
                    gradientTransform="matrix(.99715 0 0 1 .001 0)">
                    <stop offset="0%" stop-color="#292A2E"></stop>
                    <stop offset="100%" stop-color="#1A1A1E"></stop>
                </radialGradient>
                <linearGradient id="linear-gradient-all-sports" x1="0%" x2="100%" y1="8.434%" y2="91.566%">
                    <stop offset="0%" stop-color="#5595ff"></stop>
                    <stop offset="100%" stop-color="#1c71ff"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-basketball" x1="100%" x2="0%" y1="94.291%" y2="5.709%">
                    <stop offset="0%" stop-color="#f5600f"></stop>
                    <stop offset="100%" stop-color="#ef8e00"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-icehockey" x1="0%" x2="100%" y1="13.624%" y2="86.376%">
                    <stop offset="0%" stop-color="#5595ff"></stop>
                    <stop offset="100%" stop-color="#1c71ff"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-soccer" x1="0%" x2="100%" y1="5.709%" y2="94.291%">
                    <stop offset="0%" stop-color="#04d992"></stop>
                    <stop offset="100%" stop-color="#00a970"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-tennis" x1="0%" x2="100%" y1="5.711%" y2="94.289%">
                    <stop offset="0%" stop-color="#d3e21b"></stop>
                    <stop offset="100%" stop-color="#9bb60d"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-volleyball" x1="0%" x2="100%" y1="5.709%" y2="94.291%">
                    <stop offset=".435%" stop-color="#d33aed"></stop>
                    <stop offset="100%" stop-color="#aa24c1"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-handball" x1="0%" x2="100%" y1="5.71%" y2="94.29%">
                    <stop offset="0%" stop-color="#fedb83"></stop>
                    <stop offset="100%" stop-color="#dfbd68"></stop>
                </linearGradient>
                <linearGradient id="linear-gradient-inplay-others" x1="0%" x2="100%" y1="5.709%" y2="94.291%">
                    <stop offset="0%" stop-color="#d7e1ec"></stop>
                    <stop offset="100%" stop-color="#b4c4d8"></stop>
                </linearGradient>
                <linearGradient id="icon-ticket-empty-a" x1="50%" x2="50%" y1="0%" y2="100%">
                    <stop offset="0%" stop-color="#FFF" stop-opacity="0"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                </linearGradient>
                <linearGradient id="icon-ticket-empty-b" x1="36.264%" x2="91.762%" y1="37.5%" y2="71.061%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <path id="icon-sports-fustal-a" d="M0 0L20 0 20 20 0 20z"></path>
                <mask id="icon-sports-fustal-b" fill="#fff">
                    <use xlink:href="#icon-sports-fustal-a"></use>
                </mask>
                <path id="icon-sports-mini-football-a" d="M0 0L19.98 0 19.98 19.97 0 19.97z"></path>
                <mask id="icon-sports-mini-football-b" fill="#fff">
                    <use xlink:href="#icon-sports-mini-football-a"></use>
                </mask>
                <linearGradient id="icon-stub-a" x1="32.704%" x2="91.156%" y1="28.571%" y2="74.17%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-b" x1="25.867%" x2="52.524%" y1="47.817%" y2="64.488%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-c" x1="43.967%" x2="50.631%" y1="0%" y2="381.809%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-d" x1="49.349%" x2="94.083%" y1="21.889%" y2="181.495%">
                    <stop offset="0%" stop-color="#FFF" stop-opacity=".1"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-e" x1="48.14%" x2="94.083%" y1="17.575%" y2="181.495%">
                    <stop offset="2.631%" stop-color="#FFF" stop-opacity=".1"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-f" x1="42.559%" x2="226.332%" y1="17.575%" y2="181.495%">
                    <stop offset="0%" stop-color="#FFF" stop-opacity=".12"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-g" x1="35.167%" x2="116.464%" y1="26.685%" y2="131.77%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-stub-h" x1="50%" x2="100.982%" y1="30.307%" y2="220.597%">
                    <stop offset="0%" stop-color="#FFF" stop-opacity=".12"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stream-stub-a" x1="-856.79" y1="1249.86" x2="-855.79" y2="1249.49"
                    gradientTransform="matrix(94 0 0 -58 80543 72514.99)" gradientUnits="userSpaceOnUse">
                    <stop offset="0" stop-color="#303236"></stop>
                    <stop offset="1" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stream-stub-b" x1="-849.46" y1="1201.31" x2="-849.46" y2="1198.43"
                    gradientTransform="matrix(54 0 0 -17 45923.79 20481.41)" gradientUnits="userSpaceOnUse">
                    <stop offset="0" stop-color="#222226"></stop>
                    <stop offset="1" stop-color="#303236"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stream-stub-c" x1="-857.67" y1="1252.89" x2="-856.67" y2="1252.47"
                    gradientTransform="matrix(104 0 0 -68 89198 85216.37)" xlink:href="#icon-live-stream-stub-a">
                </linearGradient>
                <linearGradient id="icon-live-stream-stub-d" x1="-811.51" y1="1231.07" x2="-811.24" y2="1230.07"
                    gradientTransform="matrix(16 0 0 -30 13081 36970.13)" gradientUnits="userSpaceOnUse">
                    <stop offset="0" stop-color="#303236"></stop>
                    <stop offset="1" stop-color="#2b2b30"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stream-stub-e" x1="-811.53" y1="1211.2" x2="-811.18" y2="1209.86"
                    gradientTransform="matrix(16 0 0 -20 13081 24263.76)" gradientUnits="userSpaceOnUse">
                    <stop offset="0" stop-color="#fff" stop-opacity=".08"></stop>
                    <stop offset="1" stop-color="#fff" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stream-stub-f" x1="-829.63" y1="1228.3" x2="-828.89" y2="1226.97"
                    gradientTransform="matrix(24 0 0 -28 20005 34446.86)" xlink:href="#icon-live-stream-stub-a">
                </linearGradient>
                <linearGradient id="icon-live-stats-stub-a" x1="0%" x2="82.878%" y1="34.673%" y2="61.861%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stats-stub-b" x1="0%" x2="93.609%" y1="49.926%" y2="50.789%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stats-stub-c" x1="0%" x2="82.878%" y1="47.752%" y2="51.74%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stats-stub-d" x1="42.559%" x2="60.766%" y1="43.307%" y2="67.203%">
                    <stop offset="0%" stop-color="#FFF" stop-opacity=".08"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stats-stub-e" x1="12.92%" x2="100%" y1="12.905%" y2="109.652%">
                    <stop offset="0%" stop-color="#303236"></stop>
                    <stop offset="100%" stop-color="#222226"></stop>
                </linearGradient>
                <linearGradient id="icon-live-stats-stub-f" x1="19.402%" x2="74.735%" y1="9.967%" y2="143.706%">
                    <stop offset="0%" stop-color="#FFF" stop-opacity=".08"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".04"></stop>
                    <stop offset="100%" stop-color="#FFF" stop-opacity=".02"></stop>
                </linearGradient>
                <linearGradient id="icon-bonus-a" x1="-9" y1="9" x2="9" y2="27" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04D992"></stop>
                    <stop offset="1" stop-color="#00A970"></stop>
                </linearGradient>
                <linearGradient id="icon-bonus-b" x1="19.2146" y1="9.73679" x2="9.05191" y2="0.889743"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="white" stop-opacity="0.599104"></stop>
                    <stop offset="1" stop-color="white"></stop>
                </linearGradient>
                <clipPath id="icon-leagues-a">
                    <rect width="20" height="20" fill="white"></rect>
                </clipPath>
                <linearGradient id="icon-team-placeholder-a" x1="48" y1="8" x2="48" y2="88"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#B6B6B6" stop-opacity="0.82"></stop>
                    <stop offset="1" stop-color="#A8A8B8" stop-opacity="0.12"></stop>
                </linearGradient>
                <linearGradient id="icon-team-placeholder-b" x1="59.4583" y1="11.2558" x2="14.3469" y2="55.7093"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="white" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0.21"></stop>
                </linearGradient>
                <linearGradient id="icon-individual-placeholder-a" x1="48" y1="8" x2="48" y2="88"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#B6B6B6" stop-opacity="0.82"></stop>
                    <stop offset="1" stop-color="#A8A8B8" stop-opacity="0.27"></stop>
                </linearGradient>
                <linearGradient id="icon-individual-placeholder-b" x1="48" y1="18" x2="48" y2="66.458"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-opacity="0.36"></stop>
                    <stop offset="1" stop-opacity="0.82"></stop>
                </linearGradient>
                <linearGradient id="icon-country-placeholder-a" x1="48" y1="8" x2="48" y2="88"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#B6B6B6" stop-opacity="0.82"></stop>
                    <stop offset="1" stop-color="#A8A8B8" stop-opacity="0.27"></stop>
                </linearGradient>
                <linearGradient id="icon-country-placeholder-b" x1="48" y1="18.1201" x2="48" y2="77.8801"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-opacity="0.36"></stop>
                    <stop offset="1" stop-opacity="0.82"></stop>
                </linearGradient>
            </defs>
        </svg>
    </div>
    <div id="portal-root">
        <div>
            <div class="bet-slip-notification p-1_5 d-flex justify-content-center align-items-center position-fixed">
                <svg class="flex-shrink-0" xmlns="http://www.w3.org/2000/svg" width="13" height="10"
                    viewBox="0 0 13 10">
                    <path fill="#ffeb3b"
                        d="M7.009.105c.145.086.266.207.352.352l4.747 8.034c.281.476.124 1.089-.352 1.37-.154.091-.33.139-.508.139H1.752c-.552 0-1-.448-1-1 0-.179.048-.355.14-.509L5.639.457c.281-.476.894-.633 1.37-.352zM7 7H6v1h1V7zm0-4H6v3h1V3z">
                    </path>
                </svg><span class="ml-1 text-small font-weight-bold">Kuponda en fazla 20 adet bahis bulunabilir.</span>
            </div>
        </div>
    </div>


    <script id="__LOADABLE_REQUIRED_CHUNKS__" type="application/json">[3,0,2,1,6]</script>
    <script id="__LOADABLE_REQUIRED_CHUNKS___ext" type="application/json">{"namedChunks":["home"]}</script>
    <script async="" data-chunk="main" src="/sporassets/main.160182c763bd4cff6088.js" type="text/javascript"></script>
    <script async="" data-chunk="theme" src="/sporassets/theme.55e64468f27b8f6a530f.js" type="text/javascript"></script>
    <script async="" data-chunk="home" src="/sporassets/3.7d00ea4a3f42c70b4b81.js" type="text/javascript"></script>
    <script async="" data-chunk="home" src="/sporassets/0.e94c39b04acbf3a649b4.js" type="text/javascript"></script>
    <script async="" data-chunk="home" src="/sporassets/2.8198896a092c77beb65e.js" type="text/javascript"></script>
    <script async="" data-chunk="home" src="/sporassets/1.66118040bf82a2cf579a.js" type="text/javascript"></script>
    <script async="" data-chunk="home" src="/sporassets/6.02c4e69ce05673c041e4.js" type="text/javascript"></script>





</body>

</html>

      