<?php
session_start();
include 'inc/database.php';

// Veritabanı bağlantısı
$host = 'localhost';
$db = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

$conn = new mysqli($host, $user, $pass, $db);

// Bağlantı kontrolü
if ($conn->connect_error) {
    die("Bağlantı hatası: " . $conn->connect_error);
}

// Veritabanı tablosunu kontrol et ve gerekirse güncelle
$alterQueries = [
    "ALTER TABLE kullanicilar ADD COLUMN IF NOT EXISTS reset_token VARCHAR(255) DEFAULT NULL",
    "ALTER TABLE kullanicilar ADD COLUMN IF NOT EXISTS reset_token_expires DATETIME DEFAULT NULL"
];

foreach ($alterQueries as $query) {
    $conn->query($query);
}

$message = '';
$alertType = '';

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    
    // E-posta adresini kontrol et
    $email = trim(strtolower($email)); // E-posta adresini küçük harfe çevir ve boşlukları temizle
    $stmt = $conn->prepare("SELECT id, username FROM kullanicilar WHERE LOWER(email) = ? LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        
        // Şifre sıfırlama token'ı oluştur
        $token = bin2hex(random_bytes(32));
        $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));
        
        // Token'ı veritabanına kaydet
        $updateStmt = $conn->prepare("UPDATE kullanicilar SET reset_token = ?, reset_token_expires = ? WHERE id = ?");
        $updateStmt->bind_param("ssi", $token, $expires, $user['id']);
        
        if ($updateStmt->execute()) {
            // Şifre sıfırlama e-postası gönderme
            $resetLink = "https://" . $_SERVER['HTTP_HOST'] . "/reset_password.php?token=" . $token;
            
            // E-posta gönderme
            $to = $email;
            $subject = "Şifre Sıfırlama";
            $message_body = "Şifrenizi sıfırlamak için aşağıdaki bağlantıya tıklayın:\n\n" . $resetLink;
            require_once 'inc/send_mail.php';
            
            $to = $email;
            $subject = "Şifre Sıfırlama";
            $message_body = "
            <html>
            <head>
                <title>Şifre Sıfırlama</title>
            </head>
            <body>
                <p>Merhaba,</p>
                <p>Şifrenizi sıfırlamak için aşağıdaki bağlantıya tıklayın:</p>
                <p><a href=\"$resetLink\">Şifremi Sıfırla</a></p>
                <p>Veya bu bağlantıyı tarayıcınıza kopyalayın:</p>
                <p>$resetLink</p>
                <p>Bu bağlantı 1 saat süreyle geçerlidir.</p>
                <p>Teşekkürler,<br>Blackbet1 Ekibi</p>
            </body>
            </html>";
            
            if(send_mail($to, $subject, $message_body)) {
                $message = "Şifre sıfırlama bağlantısı e-posta adresinize gönderildi. Lütfen e-postanızı kontrol edin.";
                $alertType = "success";
            } else {
                $message = "E-posta gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.";
                $alertType = "danger";
            }
            
            // Geliştirme aşamasında bağlantıyı göster
            $devMessage = "Geliştirme modu: Şifre sıfırlama bağlantısı: <a href='$resetLink'>$resetLink</a>";
        } else {
            $message = "Şifre sıfırlama işlemi sırasında bir hata oluştu. Lütfen daha sonra tekrar deneyin.";
            $alertType = "danger";
        }
        
        $updateStmt->close();
    } else {
        $message = "Bu e-posta adresiyle kayıtlı bir hesap bulunamadı.";
        $alertType = "danger";
    }
    
    $stmt->close();
}

// Bağlantıyı kapat
$conn->close();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Şifremi Unuttum</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #000;
            color: #fff;
            padding-top: 50px;
        }
        .forgot-password-container {
            max-width: 500px;
            margin: 0 auto;
            background-color: #1a1a1a;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .btn-primary {
background-color: var(--primary); /* Site sarı tek ton */
border-color: var(--primary);
            color: #fff;
            width: 100%;
        }
        .btn-primary:hover, .btn-primary:focus {
            filter: brightness(0.95);
            background-color: #C9A233;
            border-color: #C9A233;
            color: #fff;
        }
        .form-control {
            background-color: #333;
            border: 1px solid #444;
            color: #fff;
        }
        .form-control:focus {
            background-color: #444;
            color: #fff;
            border-color: #007bff;
            box-shadow: 0 0 0 0.25rem rgba(0, 123, 255, 0.25);
        }
        .alert {
            border-radius: 5px;
        }
        .dev-message {
            margin-top: 20px;
            padding: 10px;
            background-color: #333;
            border-radius: 5px;
        }
        .dev-message a {
            color: #007bff;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="forgot-password-container">
            <div class="logo">
                <img src="/assets/images/logo/redbets-logo1.jpg" alt="Logo" height="60">
            </div>
            
            <h2 class="text-center mb-4">Şifremi Unuttum</h2>
            
            <?php if ($message): ?>
                <div class="alert alert-<?php echo $alertType; ?>">
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>
            
            <form method="post" action="">
                <div class="mb-3">
                    <label for="email" class="form-label">E-posta Adresiniz</label>
                    <input type="email" class="form-control" id="email" name="email" required>
                    <div class="form-text text-muted">Kayıt olduğunuz e-posta adresinizi girin.</div>
                </div>
                
                <div class="mb-3">
                    <button type="submit" class="btn btn-primary">Şifre Sıfırlama Bağlantısı Gönder</button>
                </div>
            </form>
            
            <div class="text-center mt-3">
                <a href="/" class="text-light">Ana Sayfaya Dön</a>
            </div>
            
            <?php if (isset($devMessage)): ?>
                <div class="dev-message">
                    <?php echo $devMessage; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>