<?php
include '../../database.php';

// Oyunları almak için fonksiyon
function getGames($searchTerm = '', $sort = 'new', $offset = 0, $limit = 20, $provider_game = null) {
    global $pdo;

    // Güvenli ORDER BY oluşturma
    switch (strtolower($sort)) {
        case 'az':
            $orderBy = 'game_name ASC';
            break;
        case 'za':
            $orderBy = 'game_name DESC';
            break;
        case 'old':
            $orderBy = 'created_at ASC';
            break;
        case 'featured':
            $orderBy = 'is_featured DESC, created_at DESC';
            break;
        case 'new':
        default:
            $orderBy = 'created_at DESC';
            break;
    }

    // Slot oyunlarını provider kısıtlaması ve arama terimi ile filtreleyelim
    if (!empty($provider_game)) {
        $sql = "
            SELECT provider_game, game_id, game_name, cover 
            FROM games 
            WHERE LOWER(game_type) LIKE 'slot%' 
              AND provider_game = ?
              AND game_name LIKE ?
            ORDER BY $orderBy
            LIMIT ?, ?";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(1, $provider_game, PDO::PARAM_STR);
        $stmt->bindValue(2, '%' . $searchTerm . '%', PDO::PARAM_STR);
        $stmt->bindValue(3, (int)$offset, PDO::PARAM_INT);
        $stmt->bindValue(4, (int)$limit, PDO::PARAM_INT);
    } else {
        $sql = "
            SELECT provider_game, game_id, game_name, cover 
            FROM games 
            WHERE LOWER(game_type) LIKE 'slot%' 
              AND game_name LIKE ?
            ORDER BY $orderBy
            LIMIT ?, ?";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(1, '%' . $searchTerm . '%', PDO::PARAM_STR);
        $stmt->bindValue(2, (int)$offset, PDO::PARAM_INT);
        $stmt->bindValue(3, (int)$limit, PDO::PARAM_INT);
    }

    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// İlk oyunları al
$searchTerm = isset($_GET['search']) ? $_GET['search'] : ''; // Arama terimini al
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'new';
$offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
$provider_game = isset($_GET['provider_game']) ? $_GET['provider_game'] : null;
$games = getGames($searchTerm, $sort, $offset, $limit, $provider_game);

// Tanılama: DB'de kaç adet slot var?
try {
    $totalSlot = (int)$pdo->query("SELECT COUNT(*) FROM games WHERE game_type = 'slot'")->fetchColumn();
    $totalSlotLike = (int)$pdo->query("SELECT COUNT(*) FROM games WHERE LOWER(game_type) LIKE 'slot%'")->fetchColumn();
} catch (Exception $e) {
    $totalSlot = 0;
    $totalSlotLike = 0;
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            color: white; /* Metin rengi */
            font-family: 'Arial', sans-serif; /* Yazı tipi */
        }
.search-bar {
    margin: 20px auto; /* Otomatik kenar boşluğu */
    text-align: center; /* Merkezleme */
    position: relative; /* İçerik konumlandırma için */
    max-width: 600px; /* Maksimum genişlik */
    width: 100%; /* Genişlik %100 */
}

.search-bar input {
    width: 100%; 
    padding: 12px 20px; /* Daha dengeli iç boşluk */
    font-size: 18px; /* Yazı boyutu */
    border-radius: 5px; /* Yuvarlak köşe ama daha minimal */
    border: 1px solid #ccc; /* Daha yumuşak kenar rengi */
    background-color: rgba(255, 255, 255, 0.9); /* Daha az şeffaf arka plan */
    color: #333; /* Koyu metin rengi */
    transition: background-color 0.3s, border-color 0.3s; /* Geçiş efektleri */
    padding-right: 40px; /* Arama ikonunun yerleşmesi için sağda boşluk */
}

.search-bar input:focus {
    outline: none; /* Odaklandığında çerçeve kaldır */
    background-color: rgba(255, 255, 255, 1); /* Tam beyaz arka plan */
    border-color: #007bff; /* Kenar rengi değişikliği */
}

.search-bar button {
    position: absolute; /* İkonu konumlandırmak için */
    right: 10px; /* İkonu sağa yerleştiriyoruz */
    top: 50%; /* Dikey olarak ortala */
    transform: translateY(-50%); /* Dikey ortalama için */
    background: transparent; /* Arka planı şeffaf yap */
    border: none; /* Kenarları kaldır */
    cursor: pointer; /* İmleci göster */
    color: #007bff; /* İkon rengi */
    font-size: 20px; /* İkon boyutu */
    transition: color 0.3s; /* Renk geçişi */
}

.search-bar button:hover {
    color: #0056b3; /* Üzerine gelince rengi değiştir */
}

/* Mobil uyumlu tasarım */
@media (max-width: 768px) {
    .search-bar {
        margin: 10px auto; /* Mobilde daha küçük kenar boşluğu */
        max-width: 100%; /* Maksimum genişlik %100 */
    }

    .search-bar input {
        padding: 8px 12px; /* Daha küçük iç boşluk */
        font-size: 14px; /* Yazı boyutunu küçültüyoruz */
    }

    .search-bar button {
        right: 8px; /* İkonu sağa biraz daha kaydırıyoruz */
        font-size: 16px; /* İkon boyutunu küçültüyoruz */
    }
}

@media (max-width: 480px) {
    .search-bar {
        margin: 8px auto; /* Daha da küçük kenar boşluğu */
    }

    .search-bar input {
        padding: 6px 10px; /* İç boşluğu daha da küçültüyoruz */
        font-size: 12px; /* Yazı boyutunu daha da küçültüyoruz */
    }

    .search-bar button {
        right: 6px; /* İkonu sağa daha da kaydırıyoruz */
        font-size: 14px; /* İkon boyutunu daha da küçültüyoruz */
    }
}

        .game-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            grid-gap: 20px;
            margin: 20px;
        }
        .game-item {
            text-align: center;
            color: white;
        }
        .game-item img {
            width: 100%;
            height: auto;
            cursor: pointer;
            border-radius: 10px;
            transition: 0.3s;
        }
        .game-item img:hover {
            transform: scale(1.05);
        }
        .button-container {
            display: flex;
            justify-content: center;
        }
        .btn {
            background-color: var(--primary);
            color: var(--btntText);
            padding: 10px 200px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: var(--hover-color);
        }
        @media (max-width: 768px) {
            .game-grid {
                grid-template-columns: repeat(3, 1fr);
            }
            .btn {
                width: 100%;
                padding: 15px;
            }
        }
    </style>
</head>
<body>

<?php if (empty($hide_search) && !isset($_GET['hide_search'])): ?>
<div class="search-bar">
    <form method="GET" action="">
        <input type="text" id="provider-input" name="search" placeholder="Oyun adını yazın..." value="<?= htmlspecialchars($searchTerm, ENT_QUOTES); ?>">
        <button type="submit"><i class="fas fa-search"></i></button>
    </form>
</div>
<?php endif; ?>

<div class="game-grid" id="game-grid">
    <?php if (empty($games)): ?>
        <p>Hiç oyun bulunamadı.</p>
    <?php else: ?>
        <?php foreach ($games as $game): ?>
            <div class="game-item" data-provider="<?= htmlspecialchars($game['provider_game'], ENT_QUOTES); ?>">
                <img src="<?= htmlspecialchars($game['cover'], ENT_QUOTES); ?>" alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>" 
                     onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>', '_blank')">
                        <div class="game-actions">
                            <button class="btn-real" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>', '_blank')">Oyna</button>
                            <button class="btn-demo" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>&demo=1', '_blank')">Demo</button>
                        </div>
                <p><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?></p>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php if (empty($hide_show_more) && !isset($_GET['hide_show_more'])): ?>
<div class="button-container">
    <button id="show-more-btn" class="btn" onclick="loadMoreGames()">Daha Fazla Oyun Göster</button>
</div>
<?php endif; ?>
<br><br><br>
<script>
    // Geçerli sağlayıcıyı (hepsi veya spesifik) globalde tut
    window.currentSlotProvider = window.currentSlotProvider || '<?= htmlspecialchars($provider_game ? $provider_game : 'hepsi', ENT_QUOTES); ?>';

    let offset = document.querySelectorAll('#game-grid .game-item').length; // Mevcut oyun sayısına göre başla
    const limit = 20; // Eklenen oyun sayısı
    let loading = false;

    document.addEventListener('DOMContentLoaded', function(){
        // Sort functionality removed
    });

    function loadMoreGames() {
        if (loading) return;
        loading = true;
        document.getElementById('show-more-btn').innerText = 'Yükleniyor...';
        document.getElementById('show-more-btn').disabled = true;

        const searchEl = document.getElementById('provider-input');
        const searchTerm = searchEl ? searchEl.value : ''; // Arama terimini al
        const sortVal = ''; // Slot sayfasında mevcut sıralamayı korumak için sort göndermiyoruz
        const providerGame = (window.currentSlotProvider && window.currentSlotProvider !== 'hepsi') ? window.currentSlotProvider : '';
        const xhr = new XMLHttpRequest();
        const url = '/games/casino/loadgames/load_more_games.php?offset=' + offset + '&limit=' + limit + '&search=' + encodeURIComponent(searchTerm) + (providerGame ? '&provider_game=' + encodeURIComponent(providerGame) : '');
        xhr.open('GET', url, true);

        xhr.onload = function () {
            document.getElementById('show-more-btn').innerText = 'Daha Fazla Oyun Göster';
            document.getElementById('show-more-btn').disabled = false;

            if (this.status === 200) {
                const newGames = JSON.parse(this.responseText);
                
                const gameGrid = document.getElementById('game-grid');

                if (newGames.length === 0) {
                    alert('Artık daha fazla oyun yok.');
                    loading = false;
                    return;
                }

                newGames.forEach(function (game) {
                    const gameItem = document.createElement('div');
                    gameItem.className = 'game-item';
                    gameItem.setAttribute('data-provider', game.provider_game);
                    gameItem.innerHTML = `
                        <img src="${game.cover}" alt="${game.game_name}" onclick="window.open('/start/game.php?gameid=${game.game_id}', '_blank')">
                        <div class="game-actions">
                            <button class="btn-real" onclick="window.open('/start/game.php?gameid=${game.game_id}', '_blank')">Oyna</button>
                            <button class="btn-demo" onclick="window.open('/start/game.php?gameid=${game.game_id}&demo=1', '_blank')">Demo</button>
                        </div>
                        <p>${game.game_name}</p>
                    `;
                    gameGrid.appendChild(gameItem);
                });
                offset += newGames.length;
                loading = false;
            } else {
                console.error('Failed to load games. Status:', this.status);
                alert('Oyunları yüklerken bir hata oluştu. Lütfen tekrar deneyin.');
                loading = false;
            }
        };

        xhr.onerror = function () {
            document.getElementById('show-more-btn').innerText = 'Daha Fazla Oyun Göster';
            document.getElementById('show-more-btn').disabled = false;
            loading = false;
            console.error('AJAX request failed.');
            alert('AJAX isteği başarısız oldu. Lütfen internet bağlantınızı kontrol edin.');
        };

        xhr.send();
    }
</script>
</body>
</html>
