<?php
header('Content-Type: application/json');
// Veritabanı Bağlantısı
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo 'Veritabanı bağlantı hatası: ' . $e->getMessage();
    exit;
}

// Parametreleri al
$offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
$provider_game = isset($_GET['provider_game']) ? $_GET['provider_game'] : null;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'new';

// İzin verilen oyun sağlayıcıları listesi
$allowed_providers = [
    'iconix', 'macaw', 'booming', 'fancyshoes', 'armadillostudios', 'b-gaming', 
    'adlunam', '1x2gaming', 'prospectgaming', 'jvl', 'irondogPP', 'irondog', 'irondogP', 
    'bigtimegaming', 'amigogaming', 'kagaming', 'netgame', 'bitville', 'rubyplay', 
    'pateplay', 'nolimitcity', 'evoplay', 'slotopia', 'habanero', 'pragmatic', 
    'pragmaticS', 'endorphina', 'skywind', 'caletagaming', 'absolute', '7-mojos-slots', 
    'bfgames', 'hacksaw', 'backseat', 'bullshark', 'popok', 'platipus', 'mancala', 
    'retrogames', 'spinomenal', 'fils', 'jetx', 'smartsoft', 'onetouch', 'spearhead', 
    'spearheadP', 'betsoft', 'pgsoft', 'platingaming', '7777', 'micro-gaming', 'gamzix', 
    'redrake', 'aviatrix', 'waz-dan', 'galaxsys', 'ctinteractive', '3oaks', '3oaksP', 
    'play-son', 'play-sonP', 'fazi', 'redstone', 'tiptop', 'spribe-gh', 'redtiger-gh', 
    'netent-gh', 'aviator-gh'
];

// Oyunları almak için fonksiyon
function getGames($provider_game, $offset, $limit, $search, $sort) {
    global $pdo;

    // Güvenli ORDER BY oluşturma
    switch (strtolower($sort)) {
        case 'az':
            $orderBy = 'game_name ASC';
            break;
        case 'za':
            $orderBy = 'game_name DESC';
            break;
        case 'old':
            $orderBy = 'created_at ASC';
            break;
        case 'featured':
            $orderBy = 'is_featured DESC, created_at DESC';
            break;
        case 'new':
        default:
            $orderBy = 'created_at DESC';
            break;
    }

    if ($provider_game) {
        // Belirtilen sağlayıcının slot oyunlarını ve arama terimine göre filtrele
        $sql = "SELECT provider_game, game_id, game_name, cover FROM games WHERE LOWER(game_type) LIKE 'slot%' AND provider_game = ? AND game_name LIKE ? ORDER BY $orderBy LIMIT ?, ?";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(1, $provider_game, PDO::PARAM_STR);
        $stmt->bindValue(2, '%' . $search . '%', PDO::PARAM_STR);
        $stmt->bindValue(3, $offset, PDO::PARAM_INT);
        $stmt->bindValue(4, $limit, PDO::PARAM_INT);
    } else {
        // Tüm slot oyunlarını arama terimine göre getir
        $sql = "SELECT provider_game, game_id, game_name, cover FROM games WHERE LOWER(game_type) LIKE 'slot%' AND game_name LIKE ? ORDER BY $orderBy LIMIT ?, ?";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(1, '%' . $search . '%', PDO::PARAM_STR);
        $stmt->bindValue(2, $offset, PDO::PARAM_INT);
        $stmt->bindValue(3, $limit, PDO::PARAM_INT);
    }

    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Oyunları al
$games = getGames($provider_game, $offset, $limit, $search, $sort);
echo json_encode($games);
?>
