<?php
include '../../database.php';

function getOtherSlotGames() {
    global $pdo;

    // Bilinen slot provider_game değerleri (slot sekmesinde ayrı dosyası olanlar)
    $knownProviders = [
        'pragmatic','pragmaticS',
        'skywind',
        'slotopia',
        'spribe','spribe-gh',
        'egtdigital','egtd',
        'armadillostudios',
        'redrake',
        'iconix',
        'pgsoft',
        'kagaming',
        'wazdan','wazdan-a',
        'fils',
        'booming',
        '7777',
        'micro-gaming',
        'bigtimegaming-a',
        'caletagaming',
        'novo-matic',
        '7-mojos-slots',
        'mancala',
        'amigogaming',
        'gamzix',
        'redstone',
        'platipus',
        'popok',
        'spearhead','spearheadP',
        '3oaks','3oaksP',
        'redtigerWC',
        'tiptop',
        'spinomenal',
        'jvl',
        '1x2gaming',
        'bullshark',
        'macaw',
        'habanero',
        'backseat',
        'aviatrix',
        'nolimitcity','nolimitcity-a',
        'adlunam',
        'pateplay',
        'betsoft-a',
        'fazi',
        'irondog','irondogPP','irondogP',
        'prospectgaming',
        'retrogames',
        'smartsoft',
        'bgaming',
        'rubyplay',
        'onetouch',
        'platingaming',
        'netentWC',
        'galaxsys',
        'endorphina',
        'netgame',
        'amusnet',
        'bfgames',
        'hacksaw',
        'bitville',
        'evoplay',
        'play-son','play-sonP'
    ];

    $placeholders = implode(',', array_fill(0, count($knownProviders), '?'));

    $sql = "SELECT provider_game, game_id, game_name, cover 
            FROM games 
            WHERE LOWER(game_type) LIKE 'slot%' 
              AND provider_game NOT IN ($placeholders)
            ORDER BY game_name ASC";

    $stmt = $pdo->prepare($sql);
    foreach ($knownProviders as $i => $prov) {
        $stmt->bindValue($i + 1, $prov, PDO::PARAM_STR);
    }
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$games = getOtherSlotGames();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Diğer Slot Oyunları</title>
    <style>
        body { background-color: #000; color: #fff; }
        .game-grid { display: grid; grid-template-columns: repeat(5, 1fr); grid-gap: 20px; margin: 20px; }
        .game-item { text-align: center; color: #fff; }
        .game-item img { width: 100%; height: auto; cursor: pointer; border-radius: 10px; transition: 0.3s; }
        .game-item img:hover { transform: scale(1.05); }
        .game-item p { color: #fff; margin-top: 10px; }
        @media (max-width: 768px) { .game-grid { grid-template-columns: repeat(3, 1fr); } }
    </style>
</head>
<body>

<div class="game-grid" id="game-grid">
    <?php foreach ($games as $game): ?>
        <div class="game-item">
            <a href="/start/game.php?gameid=<?= $game['game_id']; ?>" target="_blank">
                <img src="<?= htmlspecialchars($game['cover'], ENT_QUOTES); ?>" alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>">
                <p><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?> <small>(<?= htmlspecialchars($game['provider_game'], ENT_QUOTES); ?>)</small></p>
            </a>
        </div>
    <?php endforeach; ?>
</div>

</body>
</html>