<?php
session_start();
include '../../../tr/includes/head.php';
include '../../../tr/includes/headertext.php';

// Giriş yapmış kullanıcıyı kontrol et
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    include '../../../tr/includes/header2.php'; 
} else {
    include '../../../tr/includes/header.php'; 
}
?>

<?php

// Veritabanı Bağlantısı (Değerleri kendine göre değiştir)
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo 'Veritabanı bağlantı hatası: ' . $e->getMessage();
    exit;
}

// Oyunları almak için fonksiyon
function getGames() {
    global $pdo;
    // egt_games tablosundan oyunları çekiyoruz
    $sql = "SELECT game_code, game_name, game_image FROM egt_games";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


$is_logged_in = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;

// Tüm oyunları al
$games = getGames();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Oyunlar</title>
    <style>
        .game-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            grid-gap: 20px;
            margin: 20px;
        }

        .game-item {
            text-align: center;
            color: white;
        }

        .game-item img {
            width: 100%;
            height: auto;
            cursor: pointer;
            border-radius: 10px;
            transition: 0.3s;
        }

        .game-item img:hover {
            transform: scale(1.05);
        }

        .iframe-popup {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 60%;
            height: 80%;
            background-color: white;
            border-radius: 10px;
            border: 1px solid #ccc;
            z-index: 9999;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .iframe-popup iframe {
            width: 100%;
            height: 100%;
            border: none;
        }

        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 9998;
        }
    </style>
</head>
<body>

<div class="game-grid" id="game-grid">
    <?php foreach ($games as $game): ?>
        <div class="game-item">
            <img src="<?= htmlspecialchars($game['game_image'], ENT_QUOTES); ?>" alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>" 
                 onclick="openIframe('<?= $is_logged_in ? '/tbs2/game.php?gameid=' . $game['game_code'] : '/tbs2/demo.php?gameid=' . $game['game_code']; ?>')">
            <p><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?></p>
        </div>
    <?php endforeach; ?>
</div>

<!-- Iframe Popup -->
<div class="overlay" id="overlay" onclick="closeIframe()"></div>
<div class="iframe-popup" id="iframe-popup">
    <iframe id="iframe-content" src="" frameborder="0"></iframe>
</div>

<script>
    function openIframe(url) {
        document.getElementById('iframe-content').src = url;
        document.getElementById('iframe-popup').style.display = 'block';
        document.getElementById('overlay').style.display = 'block';
    }

    function closeIframe() {
        document.getElementById('iframe-popup').style.display = 'none';
        document.getElementById('overlay').style.display = 'none';
        document.getElementById('iframe-content').src = '';
    }
</script>

</body>
</html>

<?php
include '../../../tr/includes/footer.php';
include '../../../tr/includes/footertext.php';
include '../../../tr/includes/helper.php';
?>
