<?php
header('Content-Type: application/json');

$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Veritabanı bağlantı hatası: ' . $e->getMessage()]);
    exit;
}

// Tüm game type'ları tanımla
$gameTypes = [
    'tablegames', 'shooting', 'crashgame', 'bingo', 'baccarat', 'roulette', 
    'dice', 'blackjack', 'cards', 'poker', 'dragontiger', 'instantgame', 
    'sicbo', 'andarbahar', 'keno', 'interactivegame', 'scratchcards', 
    'gameshow', 'lottery', 'virtual', 'lobby', 'plinko', 'arcade', 'other'
];

$counts = [];

try {
    // Her game type için oyun sayısını getir
    foreach ($gameTypes as $type) {
        $sql = "SELECT COUNT(*) as count FROM games WHERE game_type = :game_type AND NOT game_type LIKE 'slot%'";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':game_type', $type, PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $counts[$type] = (int)$result['count'];
    }

    echo json_encode($counts);

} catch (PDOException $e) {
    echo json_encode(['error' => 'Veritabanı hatası: ' . $e->getMessage()]);
}
?>