<?php
header('Content-Type: application/json');

$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Veritabanı bağlantı hatası: ' . $e->getMessage()]);
    exit;
}

$gameType = isset($_GET['type']) ? trim($_GET['type']) : '';
if (empty($gameType)) {
    echo json_encode(['error' => 'Geçersiz oyun türü']);
    exit;
}

$allowedTypes = [
    'tablegames', 'shooting', 'crashgame', 'bingo', 'baccarat', 'roulette', 
    'dice', 'blackjack', 'cards', 'poker', 'dragontiger', 'instantgame', 
    'sicbo', 'andarbahar', 'keno', 'interactivegame', 'scratchcards', 
    'gameshow', 'lottery', 'virtual', 'lobby', 'plinko', 'arcade', 'other'
];

if (!in_array($gameType, $allowedTypes)) {
    echo json_encode(['error' => 'Geçersiz oyun türü']);
    exit;
}

try {
    $sql = "SELECT provider_game, COUNT(*) AS count FROM games WHERE LOWER(game_type) NOT LIKE 'slot%' AND game_type = :game_type GROUP BY provider_game ORDER BY provider_game ASC";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':game_type', $gameType, PDO::PARAM_STR);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $providers = [];
    foreach ($rows as $row) {
        // Null veya boş providerları dışarıda bırak
        if (!empty($row['provider_game'])) {
            $providers[] = [
                'provider_game' => $row['provider_game'],
                'count' => (int)$row['count']
            ];
        }
    }
    echo json_encode($providers);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Veritabanı hatası: ' . $e->getMessage()]);
}
?>