<?php
include '../../database.php';

// Oyunları almak için fonksiyon
function getGames($offset = 0, $limit = 20) {
    global $pdo;
    // provider_game alanına göre iconix ve spinomenal hariç, pragmatic-bj başta olacak şekilde sorgu
    $sql = "
        SELECT provider_game, game_id, game_name, cover 
        FROM games 
        WHERE LOWER(game_type) NOT LIKE 'slot%' 
        ORDER BY 
            CASE 
                WHEN provider_game = 'pragmatic-bj' THEN 1 
                ELSE 2 
            END, 
            game_name ASC
        LIMIT :offset, :limit";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
    $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// İlk 20 oyunu al
$games = getGames();
?>


<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Oyunlar</title>
    <style>
        body {
            background-color: #000; /* Arka plan rengi siyah */
            color: white; /* Yazı rengi beyaz */
        }

        .game-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            grid-gap: 20px;
            margin: 20px;
        }

        .game-item {
            text-align: center;
            color: white;
        }

        .game-item img {
            width: 100%;
            height: auto;
            cursor: pointer;
            border-radius: 10px;
            transition: 0.3s;
        }

        .game-item img:hover {
            transform: scale(1.05);
        }

.button-container {
    display: flex;
    justify-content: center; /* Yatayda ortalama */
}

.btn {
    background-color: red; /* Buton rengi kırmızı */
    color: white; /* Buton yazı rengi beyaz */
    padding: 10px 200px; /* Buton iç boşlukları */
    border: none; /* Kenar yok */
    border-radius: 5px; /* Kenar yuvarlama */
    cursor: pointer; /* İmleç işareti */
    transition: background-color 0.3s;
    text-align: center;
}



        .btn:hover {
            background-color: darkred; /* Buton üzerine gelindiğinde rengi değişir */
        }

        /* Mobil cihazlar için düzenlemeler */
        @media (max-width: 768px) {
            .game-grid {
                grid-template-columns: repeat(3, 1fr); /* Mobilde 3 sütun */
            }

            .btn {
                width: 100%; /* Buton genişliğini tam yap */
                padding: 15px; /* Buton iç boşlukları */
            }
        }

        /* Tablet ve daha büyük cihazlar için */
        @media (min-width: 769px) {
            .btn {
                width: auto; /* Buton genişliği otomatik */
            }
        }
    </style>
</head>
<body>

<div class="game-grid" id="game-grid">
    <?php foreach ($games as $game): ?>
        <div class="game-item">
            <img src="<?= htmlspecialchars($game['cover'], ENT_QUOTES); ?>" alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>" 
                 onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>', '_blank')">
            <div class="game-actions">
                <button class="btn-real" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>', '_blank')">Oyna</button>
                <button class="btn-demo" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>&demo=1', '_blank')">Demo</button>
            </div>
            <p><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?></p>
        </div>
    <?php endforeach; ?>
</div>

<div class="row">
    <div class="col s12 button-container" style="text-align: center; margin: 20px 0 40px 0;">
<button id="show-more-btn" class="btn btn-show-more" onclick="loadMoreGames()">Daha Fazla Oyun Göster</button>
    </div>
</div>

<br><br>





<script>
    let offset = 20;
    const limit = 20;
    let loading = false;

    function loadMoreGames() {
        if (loading) return;
        loading = true;

        const xhr = new XMLHttpRequest();
        xhr.open('GET', '../games/livecasino/loadgames/load_more_games.php?offset=' + offset + '&limit=' + limit + '&sort=' + encodeURIComponent(window.livecasinoSort || 'az'), true);

        document.getElementById('show-more-btn').innerText = 'Yükleniyor...';
        document.getElementById('show-more-btn').disabled = true;

        xhr.onload = function () {
            document.getElementById('show-more-btn').innerText = 'Daha Fazla Oyun Göster';
            document.getElementById('show-more-btn').disabled = false;

            if (this.status === 200) {
                const newGames = JSON.parse(this.responseText);
                
                const gameGrid = document.getElementById('game-grid');

                if (newGames.length === 0) {
                    alert('Artık daha fazla oyun yok.');
                    loading = false;
                    return;
                }

                newGames.forEach(function (game) {
                    const gameItem = document.createElement('div');
                    gameItem.className = 'game-item';
                    gameItem.innerHTML = `
                        <img src="${game.cover}" alt="${game.game_name}" onclick="window.open('/start/game.php?gameid=${game.game_id}', '_blank')">
                        <div class="game-actions">
                            <button class="btn-real" onclick="window.open('/start/game.php?gameid=${game.game_id}', '_blank')">Oyna</button>
                            <button class="btn-demo" onclick="window.open('/start/game.php?gameid=${game.game_id}&demo=1', '_blank')">Demo</button>
                        </div>
                        <p>${game.game_name}</p>
                    `;
                    gameGrid.appendChild(gameItem);
                });
                offset += newGames.length;
                loading = false;
            } else {
                console.error('Failed to load games. Status:', this.status);
                alert('Oyunları yüklerken bir hata oluştu. Lütfen tekrar deneyin.');
                loading = false;
            }
        };

        xhr.onerror = function () {
            document.getElementById('show-more-btn').innerText = 'Daha Fazla Oyun Göster';
            document.getElementById('show-more-btn').disabled = false;
            loading = false;
            console.error('AJAX request failed.');
            alert('AJAX isteği başarısız oldu. Lütfen internet bağlantınızı kontrol edin.');
        };

        xhr.send();
    }
</script>



</body>
</html>