<?php
include '../../database.php';

function getGames() {
    global $pdo;
    $sql = "SELECT provider_game, game_id, game_name, cover FROM games WHERE provider_game = 'livegames' AND LOWER(game_type) NOT LIKE 'slot%'";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$games = getGames();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Oyunlar</title>
    <style>
        body {
            background-color: #000; 
            color: white; 
        }

        .game-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            grid-gap: 20px;
            margin: 20px;
        }

        .game-item {
            text-align: center;
            color: white; 
        }

        .game-item img {
            width: 100%;
            height: auto;
            cursor: pointer;
            border-radius: 10px;
            transition: 0.3s;
        }

        .game-item img:hover {
            transform: scale(1.05);
        }

        .game-item p {
            color: white; 
            margin-top: 10px; 
        }

        .btn {
            background-color: red; 
            color: white; 
            padding: 10px 20px; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer; 
            transition: background-color 0.3s;
        }

        .btn:hover {
            background-color: darkred; 
        }

        @media (max-width: 768px) {
            .game-grid {
                grid-template-columns: repeat(3, 1fr); 
            }

            .btn {
                width: 100%; 
                padding: 15px; 
            }
        }

        @media (min-width: 769px) {
            .btn {
                width: auto; 
            }
        }
    </style>
</head>
<body>

<div class="game-grid" id="game-grid">
    <?php foreach ($games as $game): ?>
        <div class="game-item">
            <img src="<?= htmlspecialchars($game['cover'], ENT_QUOTES); ?>" alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>" style="width:100%;border-radius:10px;cursor:pointer" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>','_blank')">
            <div class="game-actions">
                <button class="btn-real" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>','_blank')">Oyna</button>
                <button class="btn-demo" onclick="window.open('/start/game.php?gameid=<?= $game['game_id']; ?>&demo=1','_blank')">Demo</button>
            </div>
            <p style="margin-top:8px"><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?></p>
        </div>
    <?php endforeach; ?>
</div>

</body>
</html>
