<?php
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo 'Veritabanı bağlantı hatası: ' . $e->getMessage();
    exit;
}

// Game type parametresini al
$gameType = isset($_GET['type']) ? $_GET['type'] : '';
// Opsiyonel provider filtre parametresi
$providerGame = isset($_GET['provider_game']) ? trim($_GET['provider_game']) : '';

if (empty($gameType)) {
    echo 'Oyun bulunamadı';
    exit;
}

// Güvenlik için game type'ı kontrol et
$allowedTypes = [
    'tablegames', 'shooting', 'crashgame', 'bingo', 'baccarat', 'roulette', 
    'dice', 'blackjack', 'cards', 'poker', 'dragontiger', 'instantgame', 
    'sicbo', 'andarbahar', 'keno', 'interactivegame', 'scratchcards', 
    'gameshow', 'lottery', 'virtual', 'lobby', 'plinko', 'arcade', 'other'
];

if (!in_array($gameType, $allowedTypes)) {
    echo 'Geçersiz oyun türü';
    exit;
}

// Oyunları getir
try {
    $sql = "SELECT game_id, game_name, cover FROM games WHERE LOWER(game_type) NOT LIKE 'slot%' AND game_type = :game_type";
    if (!empty($providerGame)) {
        $sql .= " AND provider_game = :provider_game";
    }
    $sql .= " ORDER BY game_name ASC";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':game_type', $gameType, PDO::PARAM_STR);
    if (!empty($providerGame)) {
        $stmt->bindParam(':provider_game', $providerGame, PDO::PARAM_STR);
    }
    $stmt->execute();
    $games = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($games)) {
        echo 'Oyun bulunamadı';
        exit;
    }

    // Oyunları HTML olarak çıktıla
    echo '<div class="game-grid">';
    
    foreach ($games as $game) {
        $gameId = htmlspecialchars($game['game_id']);
        $gameName = htmlspecialchars($game['game_name']);
        $cover = htmlspecialchars($game['cover']);
        
        // Kapak resmi kontrolü
        $coverPath = !empty($cover) ? $cover : 'default-game-cover.jpg';
        
        echo '<div class="game-item">';
        // Görsel
        echo '<img src="' . $coverPath . '" alt="' . $gameName . '" loading="lazy" style="width:100%;border-radius:10px;cursor:pointer" onclick="window.open(\'/start/game.php?gameid=' . $gameId . '\', \'_blank\')">';
        // Butonlar (üstte)
        echo '<div class="game-actions">';
        echo '<button class="btn-real" onclick="window.open(\'/start/game.php?gameid=' . $gameId . '\', \'_blank\')">Oyna</button>';
        echo '<button class="btn-demo" onclick="window.open(\'/start/game.php?gameid=' . $gameId . '&demo=1\', \'_blank\')">Demo</button>';
        echo '</div>';
        // İsim (altta)
        echo '<p style="margin-top:8px">' . $gameName . '</p>';
        echo '</div>';
    }
    
    echo '</div>';

} catch (PDOException $e) {
    echo 'Veritabanı hatası: ' . $e->getMessage();
}
?>