<?php
// Veritabanı Bağlantısı
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo 'Veritabanı bağlantı hatası: ' . $e->getMessage();
    exit;
}

// Parametreleri al
$offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
$provider_game = isset($_GET['provider_game']) ? $_GET['provider_game'] : null;
$sort = isset($_GET['sort']) ? strtolower($_GET['sort']) : 'az'; // az/za desteği

// İzin verilen oyun sağlayıcıları listesi
$allowed_providers = [
    '7-mojos', 'creedz-vgs', 'creedz', 'creedz-bj',
    'evolutionGH', 'evolutionGHX', 'evolutionGHHS', 'evolutionGHY', 'evolutionGHVHS', 'evolutionGHLS',
    'ezugi', 'ezugiX', 'ezugiZ', 'livegames', 'liw', 'micro-gaming-live', 'onetouch-live',
    'popok-live', 'pragmatic-live', 'pragmatic-bj', 'pragmatic-virtual',
    'religa', 'sagaming', 'skywind-live', 'skywind-bj', 'tvbet', 'vivo'
];

// Oyunları almak için fonksiyon
function getGames($provider_game, $offset, $limit, $sort) {
    global $pdo, $allowed_providers;

    // ORDER BY oluştur
    $orderName = ($sort === 'za') ? 'game_name DESC' : 'game_name ASC';

    if ($provider_game && in_array($provider_game, $allowed_providers)) {
        // Belirtilen sağlayıcının oyunlarını almak için sorgu (yalnızca slot olmayanlar)
        $sql = "SELECT provider_game, game_id, game_name, cover FROM games WHERE provider_game = :provider_game AND LOWER(game_type) NOT LIKE 'slot%' ORDER BY $orderName LIMIT :offset, :limit";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':provider_game', $provider_game, PDO::PARAM_STR);
    } else {
        // Tüm canlı casino oyunlarını almak için sorgu (yalnızca slot olmayanlar)
        $caseOrder = "CASE WHEN provider_game = 'pragmatic-bj' THEN 1 ELSE 2 END";
        $sql = "SELECT provider_game, game_id, game_name, cover FROM games WHERE LOWER(game_type) NOT LIKE 'slot%' AND provider_game NOT IN ('iconix', 'spinomenal') ORDER BY $caseOrder, $orderName LIMIT :offset, :limit";
        $stmt = $pdo->prepare($sql);
    }
    
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Oyunları al
$games = getGames($provider_game, $offset, $limit, $sort);
echo json_encode($games);
?>
