<?php
include '../../database.php';

function getOtherLiveGames() {
    global $pdo;

    // Bilinen canlı casino provider_game değerleri (DB'de yer alan ve ayrı sekmesi olanlar)
    $knownProviders = [
        'evolutionWCY','evolutionWCHS','evolutionWCLS','evolutionWC','evolutionWCX',
        'evolutionGH','evolutionGHX','evolutionGHHS','evolutionGHY','evolutionGHVHS','evolutionGHLS',
        'ezugi','ezugiX','ezugiZ',
        'livegames',
        'liw',
        'micro-gaming-live',
        'onetouch-live',
        'popok-live',
        'pragmatic-live','pragmatic-bj','pragmatic-bj2','pragmatic-virtual',
        'religa',
        'sagaming',
        'skywind-live','skywind-bj',
        'tvbet',
        'vivo',
        '7-mojos',
        'creedz-vgs','creedz','creedz-bj'
    ];

    // IN listesi için placeholder'ları hazırla
    $placeholders = implode(',', array_fill(0, count($knownProviders), '?'));

    $sql = "SELECT provider_game, game_id, game_name, cover 
            FROM games 
            WHERE LOWER(game_type) NOT LIKE 'slot%' 
              AND provider_game NOT IN ($placeholders)
            ORDER BY game_name ASC";

    $stmt = $pdo->prepare($sql);
    foreach ($knownProviders as $i => $prov) {
        $stmt->bindValue($i + 1, $prov, PDO::PARAM_STR);
    }
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$games = getOtherLiveGames();
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Diğer Canlı Oyunlar</title>
    <style>
        body { background-color: #000; color: #fff; }
        .game-grid { display: grid; grid-template-columns: repeat(5, 1fr); grid-gap: 20px; margin: 20px; }
        .game-item { text-align: center; color: #fff; }
        .game-item img { width: 100%; height: auto; cursor: pointer; border-radius: 10px; transition: 0.3s; }
        .game-item img:hover { transform: scale(1.05); }
        .game-item p { color: #fff; margin-top: 10px; }
        @media (max-width: 768px) { .game-grid { grid-template-columns: repeat(3, 1fr); } }
    </style>
</head>
<body>

<div class="game-grid" id="game-grid">
    <?php foreach ($games as $game): ?>
        <div class="game-item">
            <a href="/start/game.php?gameid=<?= $game['game_id']; ?>" target="_blank">
                <img src="<?= htmlspecialchars($game['cover'], ENT_QUOTES); ?>" alt="<?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?>">
                <p><?= htmlspecialchars($game['game_name'], ENT_QUOTES); ?> <small>(<?= htmlspecialchars($game['provider_game'], ENT_QUOTES); ?>)</small></p>
            </a>
        </div>
    <?php endforeach; ?>
</div>

</body>
</html>