<!-- Font Awesome (ikon için) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* Eski Bootstrap close butonunu gizle */
button.close {
  display: none !important;
}

/* Yeni altın tonlu minimalist kapatma butonu */
.modal-close {
  position: absolute;
  top: 10px;
  right: 12px;
  width: 32px;
  height: 32px;
  border-radius: 50%;
  background-color: rgba(255, 255, 255, 0.05);
  border: 1px solid rgba(255, 255, 255, 0.08);
color: var(--primary);
  font-size: 16px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.25s ease;
  z-index: 9999;
}
.modal-close:hover {
  background-color: rgba(212, 175, 55, 0.15);
  color: #fff;
  border-color: rgba(212, 175, 55, 0.4);
  transform: scale(1.1);
}
.modal-close i { pointer-events: none; }

@media (max-width: 768px) {
  .modal-close {
    width: 28px;
    height: 28px;
    font-size: 14px;
    top: 8px;
    right: 10px;
  }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  function addCloseButton() {
    const modal = document.getElementById('login2'); // Giriş modal ID’si
    if (!modal) return;
    if (modal.querySelector('.modal-close')) return;

    const btn = document.createElement('div');
    btn.className = 'modal-close';
    btn.innerHTML = '<i class="fa-solid fa-xmark"></i>';
    btn.addEventListener('click', () => {
      modal.classList.remove('show');
      modal.style.display = 'none';
      document.body.classList.remove('modal-open');
      const backdrop = document.querySelector('.modal-backdrop');
      if (backdrop) backdrop.remove();
    });

    const content = modal.querySelector('.modal-content');
    if (content) content.appendChild(btn);
    else modal.appendChild(btn);
  }

  addCloseButton();

  const observer = new MutationObserver(addCloseButton);
  observer.observe(document.body, { childList: true, subtree: true });
});
</script>
