<?php
// Oturum başlat
session_start();

// JSON çıktısı olarak döndürmek için içerik türünü belirt
header('Content-Type: application/json');

// Veritabanı bağlantısı
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$db_username = 'blacrhdy_bet1';
$db_password = 'blacrhdy_bet1';

try {
    // PDO ile veritabanı bağlantısı
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $db_username, $db_password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['mesaj' => "Bağlantı hatası: " . $e->getMessage()]);
    exit;
}

// Kullanıcı oturumunu al
if (!isset($_SESSION['username'])) {
    die(json_encode(['mesaj' => 'Kullanıcı oturumu bulunamadı.']));
}

$kullanici_adi = $_SESSION['username'];

// JSON verisini al
$data = json_decode(file_get_contents("php://input"));
$kod = $data->kod;

try {
    // Promosyon kodunu veritabanında kontrol et
    $query = "SELECT * FROM promosyonlar WHERE kod = :kod";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':kod', $kod);
    $stmt->execute();
    $promo = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$promo) {
        echo json_encode(['mesaj' => 'Geçersiz kod.']);
        exit;
    }

    if (strtotime($promo['son_gecerlilik_tarihi']) < time()) {
        echo json_encode(['mesaj' => 'Promosyon süresi dolmuş.']);
        exit;
    }

    $query = "SELECT * FROM kullanici_promosyonlar WHERE username = :username AND kod = :kod";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':username', $kullanici_adi);
    $stmt->bindParam(':kod', $kod);
    $stmt->execute();
    $previousUse = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($previousUse) {
        echo json_encode(['mesaj' => 'Bu kodu daha önce kullandınız.']);
        exit;
    }

    if ($promo['mevcut_kullanim'] >= $promo['kullanim_limiti']) {
        echo json_encode(['mesaj' => 'Bu promosyon kodu için limit doldu.']);
        exit;
    }

    $query = "UPDATE kullanicilar SET ana_bakiye = ana_bakiye + :miktar WHERE username = :username";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':miktar', $promo['miktar']);
    $stmt->bindParam(':username', $kullanici_adi);
    $stmt->execute();

    $query = "UPDATE promosyonlar SET mevcut_kullanim = mevcut_kullanim + 1 WHERE kod = :kod";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':kod', $kod);
    $stmt->execute();

    $query = "INSERT INTO kullanici_promosyonlar (username, kod) VALUES (:username, :kod)";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':username', $kullanici_adi);
    $stmt->bindParam(':kod', $kod);
    $stmt->execute();

    echo json_encode(['mesaj' => 'Promosyon kodu başarıyla kullanıldı!']);

} catch (PDOException $e) {
    echo json_encode(['mesaj' => 'Hata: ' . $e->getMessage()]);
}
?>
