<?php
// Hata ayıklama
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Veritabanı bağlantısı
$host = 'localhost';
$db = 'blacrhdy_bet1';
$user = 'blacrhdy_bet1';
$pass = 'blacrhdy_bet1';

$conn = new mysqli($host, $user, $pass, $db);

// Bağlantı kontrolü
if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Bağlantı hatası: " . $conn->connect_error]));
}

// İçerik türünü JSON olarak ayarla
header('Content-Type: application/json');

// POST verilerini al
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $firstName = $conn->real_escape_string($_POST['firstName']);
    $surname = $conn->real_escape_string($_POST['surname']);
    $username = $conn->real_escape_string($_POST['username']);
    $email = $conn->real_escape_string($_POST['email']);
    $tcKimlikNo = $conn->real_escape_string($_POST['tcKimlikNo']);
    $gender = $conn->real_escape_string($_POST['gender']);
    $dob = $conn->real_escape_string($_POST['dob']);
    $phone = $conn->real_escape_string($_POST['phone']);
    $password = $_POST['password'];
    $bonusCode = $conn->real_escape_string($_POST['bonusCode']);

    // 1. Kullanıcı adı kontrolü (maximum 10 karakter)
    if (strlen($username) > 10) {
        echo json_encode(["status" => "error", "message" => "Kullanıcı adı en fazla 10 karakter olabilir."]);
        exit();
    }

    // 2. Ad kontrolü (maximum 20 karakter)
    if (strlen($firstName) > 20) {
        echo json_encode(["status" => "error", "message" => "Ad en fazla 20 karakter olabilir."]);
        exit();
    }

    // 3. Soyad kontrolü (maximum 20 karakter)
    if (strlen($surname) > 20) {
        echo json_encode(["status" => "error", "message" => "Soyad en fazla 20 karakter olabilir."]);
        exit();
    }

    // 4. TC Kimlik Numarası doğrulaması (algoritmaya uygun olmalı)
    if (!validateTcKimlikNo($tcKimlikNo)) {
        echo json_encode(["status" => "error", "message" => "Geçersiz T.C. Kimlik Numarası."]);
        exit();
    }

    // 5. Telefon numarası kontrolü (tam olarak 10 haneli olmalı)
    if (strlen($phone) != 10 || !ctype_digit($phone)) {
        echo json_encode(["status" => "error", "message" => "Telefon numarası 10 haneli olmalıdır."]);
        exit();
    }

    // 6. Şifre kontrolü (en az 8 karakter, büyük-küçük harf, rakam ve özel karakter şartı)
    if (!validatePassword($password)) {
        echo json_encode(["status" => "error", "message" => "Şifre en az 8 karakter olmalı; en az bir büyük harf, bir küçük harf, bir rakam ve bir özel karakter içermelidir."]);
        exit();
    }

    // Şifreyi hash'le
    $passwordHash = password_hash($password, PASSWORD_BCRYPT);

    // Kullanıcı adı, e-posta, T.C. Kimlik No ve telefon numarası kontrolü
    $checkStmt = $conn->prepare("SELECT username, email, tc_kimlik_no, phone FROM kullanicilar WHERE username = ? OR email = ? OR tc_kimlik_no = ? OR phone = ?");
    $checkStmt->bind_param("ssss", $username, $email, $tcKimlikNo, $phone);
    $checkStmt->execute();
    $checkStmt->bind_result($existingUsername, $existingEmail, $existingTcKimlikNo, $existingPhone);
    $checkStmt->fetch();
    $checkStmt->close();

    // Her bir alanı ayrı ayrı kontrol ediyoruz
    if ($existingUsername == $username) {
        echo json_encode(["status" => "error", "message" => "Kullanıcı adı zaten kayıtlı."]);
        exit();
    }

    if ($existingEmail == $email) {
        echo json_encode(["status" => "error", "message" => "E-posta adresi zaten kayıtlı."]);
        exit();
    }

    if ($existingTcKimlikNo == $tcKimlikNo) {
        echo json_encode(["status" => "error", "message" => "T.C. Kimlik No zaten kayıtlı."]);
        exit();
    }

    if ($existingPhone == $phone) {
        echo json_encode(["status" => "error", "message" => "Telefon numarası zaten kayıtlı."]);
        exit();
    }

    // Doğrulama token'ı oluştur
    // $verificationToken = bin2hex(random_bytes(32));

    // Referral: cookie veya clicks tablosundan alınan kod
    $referredBy = null;
    // Cookie öncelikli
    if (!empty($_COOKIE['affid'])) {
        $referredBy = $conn->real_escape_string($_COOKIE['affid']);
    } elseif (!empty($_COOKIE['referans_kodu'])) {
        $referredBy = $conn->real_escape_string($_COOKIE['referans_kodu']);
    } else {
        // IP'ye göre clicks'ten bak
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        if ($ip) {
            $cs = $conn->prepare("SELECT referans_kodu FROM clicks WHERE ip_adresi = ? ORDER BY id DESC LIMIT 1");
            if ($cs) {
                $cs->bind_param("s", $ip);
                $cs->execute();
                $cs->bind_result($rk);
                if ($cs->fetch() && !empty($rk)) {
                    $referredBy = $conn->real_escape_string($rk);
                }
                $cs->close();
            }
        }
    }

    // Yeni kullanıcı için benzersiz referans kodu üret
    function generateRefCode($len = 8) {
        $chars = '23456789ABCDEFGHJKLMNPQRSTUVWXYZ';
        $out = '';
        for ($i = 0; $i < $len; $i++) {
            $out .= $chars[random_int(0, strlen($chars) - 1)];
        }
        return $out;
    }
    // Benzersiz olana kadar deneyerek üret (maks 20 deneme)
    $myRefCode = null;
    for ($i = 0; $i < 20; $i++) {
        $codeTry = generateRefCode(8);
        $chk = $conn->prepare("SELECT COUNT(*) FROM kullanicilar WHERE referans_kodu = ?");
        if ($chk) {
            $chk->bind_param("s", $codeTry);
            $chk->execute();
            $chk->bind_result($cnt);
            $chk->fetch();
            $chk->close();
            if ((int)$cnt === 0) { $myRefCode = $codeTry; break; }
        } else {
            $myRefCode = $codeTry; // hazırlama hatasında yine de kullan
            break;
        }
    }

    // Önce genişletilmiş şema ile INSERT dene
    $stmt = $conn->prepare("INSERT INTO kullanicilar (first_name, surname, username, email, tc_kimlik_no, gender, dob, phone, password, bonus_code, referans_kodu, referred_by, referred_at, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
    $useFallbackInsert = false;
    if ($stmt === false) {
        // Eski şema fallback (referans sütunları yoksa)
        $useFallbackInsert = true;
        $stmt = $conn->prepare("INSERT INTO kullanicilar (first_name, surname, username, email, tc_kimlik_no, gender, dob, phone, password, bonus_code, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
        if ($stmt === false) {
            die(json_encode(["status" => "error", "message" => "Sorgu hazırlama hatası: " . $conn->error]));
        }
    }

    if ($useFallbackInsert) {
        $stmt->bind_param("ssssssssss", $firstName, $surname, $username, $email, $tcKimlikNo, $gender, $dob, $phone, $passwordHash, $bonusCode);
    } else {
        // referred_by boş ise NULL geçelim
        $refBy = $referredBy ? $referredBy : null;
        $stmt->bind_param("ssssssssssss", $firstName, $surname, $username, $email, $tcKimlikNo, $gender, $dob, $phone, $passwordHash, $bonusCode, $myRefCode, $refBy);
    }

    // Sorguyu çalıştır
    if ($stmt->execute()) {
        // Başarılı insert sonrasında davetçi sayaç artışı (varsa)
        if (!$useFallbackInsert && $referredBy) {
            $upd = $conn->prepare("UPDATE kullanicilar SET invite_count = invite_count + 1 WHERE referans_kodu = ?");
            if ($upd) { $upd->bind_param("s", $referredBy); $upd->execute(); $upd->close(); }
        }
        // Logla (admin dışı olay)
        try {
            @include_once __DIR__ . '/../woohdd/logger.php';
            if (function_exists('event_log')) {
                event_log('register', 'Yeni kullanıcı kaydı', [
                    'username' => $username,
                    'email' => $email,
                    'referans_kodu' => isset($myRefCode) ? $myRefCode : null,
                    'referred_by' => $referredBy ?: null
                ]);
            }
        } catch (Throwable $e) {
            // Logging hatası kritik değil; yoksay
        }
        echo json_encode([
            "status" => "success",
            "message" => "Kayıt başarılı! Hesabınız oluşturuldu."
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "Kayıt sırasında hata oluştu: " . $stmt->error]);
    }

    // Bağlantıyı kapat
    $stmt->close();
} else {
    echo json_encode(["status" => "error", "message" => "Geçersiz istek!"]);
}

$conn->close();

// T.C. Kimlik No doğrulama fonksiyonu
function validateTcKimlikNo($tc)
{
    if (strlen($tc) != 11 || !ctype_digit($tc) || $tc[0] == '0') {
        return false;
    }

    $odd = $tc[0] + $tc[2] + $tc[4] + $tc[6] + $tc[8];
    $even = $tc[1] + $tc[3] + $tc[5] + $tc[7];

    // 10. rakam kontrolü
    if ((($odd * 7) - $even) % 10 != $tc[9]) {
        return false;
    }

    // 11. rakam kontrolü
    if ((array_sum(str_split(substr($tc, 0, 10))) % 10) != $tc[10]) {
        return false;
    }

    return true;
}

// Şifre doğrulama fonksiyonu
function validatePassword($password)
{
    if (strlen($password) < 8) {
        return false;
    }
    if (!preg_match('/[A-Z]/', $password)) {
        return false;
    }
    if (!preg_match('/[a-z]/', $password)) {
        return false;
    }
    if (!preg_match('/[0-9]/', $password)) {
        return false;
    }
    // En az bir özel karakter şartı
    if (!preg_match('/[\W_]/', $password)) {
        return false;
    }
    return true;
}
?>
