<?php
// Slider tüm sayfalarda yüklensin
?>
<style>
/* ======== Genel sıfırlama ======== */
section.mainWrap,
.centerWrap,
.container-fluid,
.row,
.col-12 {
  margin: 0 !important;
  padding: 0 !important;
}

:root {
  --header-height: 70px; /* header sabitse buna göre boşluk bırak */
  --banner-aspect-ratio: 3.44; /* 2322 / 675 oranı */
}

/* ======== Slider ana kutusu ======== */
.bannerRow {
  background: #000 !important;
  width: 100% !important;
  position: relative !important;
  overflow: hidden !important;
  margin: var(--header-height) 0 8px 0 !important;
  display: flex !important;
  justify-content: center !important;
  align-items: center !important;
  border-bottom: 1px solid #e5b645 !important;
  border-radius: 0 !important;

  /* Görsel oranına göre yükseklik */
  height: calc(100vw / var(--banner-aspect-ratio)) !important;
  min-height: 180px !important;
  max-height: 420px !important;
}

/* ======== Fade geçişli carousel ======== */
.bannerRow .carousel,
.bannerRow .carousel-inner,
.bannerRow .carousel-item {
  width: 100% !important;
  height: 100% !important;
  overflow: hidden !important;
}
.bannerRow .carousel-fade .carousel-item {
  opacity: 0;
  transition: opacity 1s ease-in-out;
}
.bannerRow .carousel-fade .carousel-item.active {
  opacity: 1;
  z-index: 1;
}

/* ======== Görsel ayarları ======== */
.bannerRow img {
  width: 100% !important;
  height: 100% !important;
  object-fit: contain !important;
  object-position: center center !important;
  display: block !important;
  background-color: #000 !important;
  transition: transform 0.8s ease-in-out;
}
.bannerRow img:hover {
  transform: scale(1.01);
}

/* ======== Kontroller ======== */
.bannerRow .carousel-control-prev,
.bannerRow .carousel-control-next {
  width: 22px !important;
  height: 22px !important;
  top: 8px !important;
  bottom: auto !important;
  opacity: 1 !important;
}
.bannerRow .carousel-control-next { right: 12px !important; }
.bannerRow .carousel-control-prev { right: 38px !important; left: auto !important; }

.bannerRow .carousel-control-next i,
.bannerRow .carousel-control-prev i {
  width: 20px !important;
  height: 20px !important;
  line-height: 20px !important;
  font-size: 12px !important;
  background: #000 !important;
  color: #e5b645 !important;
  border-radius: 50% !important;
  border: 1px solid rgba(229, 182, 69, 0.5) !important;
  box-shadow: 0 2px 6px rgba(0,0,0,.35) !important;
}
.bannerRow .carousel-control-next i:hover,
.bannerRow .carousel-control-prev i:hover {
  background: #e5b645 !important;
  color: #000 !important;
}

/* ======== Mobil uyumlu yükseklik ======== */
@media (max-width: 768px) {
  :root { --header-height: 80px; }
  .bannerRow {
    height: calc(100vw / 2.9) !important; /* mobilde biraz daha yüksek oran */
    max-height: none !important;
  }
}
@media (max-width: 480px) {
  :root { --header-height: 85px; }
  .bannerRow {
    height: calc(100vw / 2.5) !important; /* küçük cihazda daha yüksek */
  }
}

/* ======== Genel boşluk ======== */
body {
  margin: 0 !important;
  padding: 0 !important;
  background: #000 !important;
}
</style>

<app-g6-landing-page class="ng-star-inserted">
  <section class="mainWrap">
    <div class="centerWrap">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <app-g6-banner>
              <div class="bannerRow">
                <div id="carousel-example-generic" class="carousel slide carousel-fade" data-ride="carousel" data-interval="4000">
                  <div class="carousel-inner">
                    <?php
                    // Veritabanı bağlantısı
                    $host = 'localhost';
                    $dbname = 'blacrhdy_bet1';
                    $db_username = 'blacrhdy_bet1';
                    $db_password = 'blacrhdy_bet1';
                    try {
                      $pdo = new PDO("mysql:host=$host;dbname=$dbname", $db_username, $db_password);
                      $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                      $stmt = $pdo->query("SELECT * FROM gorseller");
                      $gorseller = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    } catch (PDOException $e) {
                      echo "Veritabanı bağlantısı başarısız: " . $e->getMessage();
                    }
                    ?>

                    <?php foreach ($gorseller as $index => $gorsel): ?>
                      <div class="carousel-item <?php echo ($index === 0) ? 'active' : ''; ?>">
                        <img src="<?php echo htmlspecialchars($gorsel['url']); ?>"
                             alt="<?php echo htmlspecialchars($gorsel['alt_text']); ?>"
                             loading="lazy">
                      </div>
                    <?php endforeach; ?>
                  </div>

                  <!-- Kontroller -->
                  <a class="carousel-control-prev" href="#carousel-example-generic" role="button" data-slide="prev">
                    <i aria-hidden="true" class="fa fa-chevron-left"></i>
                  </a>
                  <a class="carousel-control-next" href="#carousel-example-generic" role="button" data-slide="next">
                    <i aria-hidden="true" class="fa fa-chevron-right"></i>
                  </a>
                </div>
              </div>
            </app-g6-banner>
          </div>
        </div>
      </div>
    </div>
  </section>
</app-g6-landing-page>
