<?php
// Canlı istatistikler kaldırıldı. Sadece sahte "Son Kazananlar" listesi gösterilecek.
// Bu veri seti tamamen statiktir ve örnek amaçlıdır.
$recent_winners = [
    ['kullanici_adi' => 'AliK***',  'oyun' => 'Sweet Bonanza',           'kazanc' => 12850],
    ['kullanici_adi' => 'Ece_**',   'oyun' => 'Gates of Olympus',        'kazanc' => 21400],
    ['kullanici_adi' => 'Mert**',   'oyun' => 'Big Bass Hold Spinner',   'kazanc' => 7850],
    ['kullanici_adi' => 'Burak**',  'oyun' => 'Rocket Blast Megaways',   'kazanc' => 15600],
    ['kullanici_adi' => 'Sena**',   'oyun' => 'Book del Sol: Multiplier','kazanc' => 9200],
    ['kullanici_adi' => 'Deniz**',  'oyun' => 'XXXtreme Roulette',       'kazanc' => 13200],
    ['kullanici_adi' => 'Nisa**',   'oyun' => 'Dream Catcher',           'kazanc' => 6400],
    ['kullanici_adi' => 'Ahmet**',  'oyun' => 'Funky Time',              'kazanc' => 11150],
    ['kullanici_adi' => 'Caner**',  'oyun' => 'Craps',                   'kazanc' => 8700],
    ['kullanici_adi' => 'Zeynep**', 'oyun' => 'Lightning Roulette',      'kazanc' => 14300],
];
?>

<style>
/* Site İstatistikleri Bölümü */
.site-stats-section {
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8) 0%, rgba(20, 20, 20, 0.9) 100%);
    border: 1px solid rgba(212, 175, 55, 0.2);
    border-radius: 8px;
    padding: 12px;
    margin: 12px 0;
    position: relative;
    overflow: hidden;
}

.site-stats-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, transparent 30%, rgba(212, 175, 55, 0.03) 50%, transparent 70%);
    pointer-events: none;
}

.stats-header {
    text-align: center;
    margin-bottom: 12px;
    position: relative;
    z-index: 1;
}

.stats-header h3 {
    color: var(--white-color);
    font-size: 16px;
    font-weight: 600;
    margin: 0;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

.stats-header .stats-subtitle {
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
    margin-top: 2px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 10px;
    margin-bottom: 16px;
}

.stat-card {
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(212, 175, 55, 0.15);
    border-radius: 6px;
    padding: 10px;
    text-align: center;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 2px;
    background: linear-gradient(90deg, transparent, var(--primary), transparent);
    transition: left 0.6s ease;
}

.stat-card:hover::before {
    left: 100%;
}

.stat-card:hover {
    transform: translateY(-1px);
    border-color: rgba(212, 175, 55, 0.4);
    box-shadow: 0 4px 15px rgba(212, 175, 55, 0.1);
}

.stat-icon {
    font-size: 18px;
    color: var(--primary);
    margin-bottom: 4px;
}

.stat-number {
    font-size: 18px;
    font-weight: 700;
    color: var(--white-color);
    margin: 4px 0 2px;
    line-height: 1;
}

.stat-label {
    font-size: 10px;
    color: rgba(255, 255, 255, 0.7);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-weight: 500;
}

.recent-winners {
    background: rgba(0, 0, 0, 0.2);
    border: 1px solid rgba(212, 175, 55, 0.15);
    border-radius: 6px;
    padding: 12px;
}

.recent-winners h4 {
    color: var(--white-color);
    font-size: 14px;
    font-weight: 600;
    margin: 0 0 8px;
    display: flex;
    align-items: center;
    gap: 6px;
}

.winners-list {
    max-height: 140px;
    overflow-y: auto;
    scrollbar-width: thin;
    scrollbar-color: var(--primary) transparent;
}

.winners-list::-webkit-scrollbar {
    width: 4px;
}

.winners-list::-webkit-scrollbar-track {
    background: transparent;
}

.winners-list::-webkit-scrollbar-thumb {
    background: var(--primary);
    border-radius: 2px;
}

.winner-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    animation: slideInRight 0.5s ease;
}

.winner-item:last-child {
    border-bottom: none;
}

.winner-info {
    flex: 1;
}

.winner-name {
    color: var(--white-color);
    font-size: 13px;
    font-weight: 500;
    margin-bottom: 2px;
}

.winner-game {
    color: rgba(255, 255, 255, 0.6);
    font-size: 11px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 120px;
}

.winner-amount {
    color: var(--primary);
    font-size: 13px;
    font-weight: 700;
    white-space: nowrap;
}

.no-winners {
    text-align: center;
    color: rgba(255, 255, 255, 0.5);
    font-size: 13px;
    padding: 20px;
}

/* Responsive tasarım */
@media (max-width: 768px) {
    .site-stats-section {
        padding: 10px;
        margin: 10px 0;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 8px;
    }
    
    .stat-card {
        padding: 8px;
    }
    
    .stat-number {
        font-size: 16px;
    }
    
    .stats-header h3 {
        font-size: 14px;
    }
    
    .recent-winners {
        padding: 10px;
    }
    
    .winners-list {
        max-height: 120px;
    }
}

@media (max-width: 480px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .winner-game {
        max-width: 80px;
    }
    
    .site-stats-section {
        padding: 8px;
        margin: 8px 0;
    }
}

/* Animasyonlar */
@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(20px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.stat-card {
    animation: fadeInUp 0.6s ease;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<div class="site-stats-section">
    <div class="stats-header">
        <h3><i class="fas fa-trophy"></i> Son Kazananlar</h3>
        <div class="stats-subtitle"></div>
    </div>
    
    <div class="recent-winners">
        <h4><i class="fas fa-trophy"></i> Son Kazananlar</h4>
        <div class="winners-list" id="winners-list">
            <?php if (!empty($recent_winners)): ?>
                <?php foreach ($recent_winners as $winner): ?>
                    <div class="winner-item">
                        <div class="winner-info">
                            <div class="winner-name"><?php echo htmlspecialchars($winner['kullanici_adi']); ?></div>
                            <div class="winner-game"><?php echo htmlspecialchars($winner['oyun']); ?></div>
                        </div>
                        <div class="winner-amount">₺<?php echo number_format($winner['kazanc'], 2); ?></div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="no-winners">Henüz kazanan bulunmuyor</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Canlı istatistikler ve otomatik güncelleme kaldırıldı. Sadece statik sahte veriler gösteriliyor. -->