<?php
session_start();

// Veritabanı bağlantısı
$host = 'localhost';
$dbname = 'blacrhdy_bet1';
$username = 'blacrhdy_bet1';
$password = 'blacrhdy_bet1';

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Bağlantı hatası: " . $e->getMessage());
}

$message = "";

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username_input = trim($_POST['username']);
    $password_input = $_POST['password'];
    
    echo "<h3>🔍 Login Test Sonuçları:</h3>";
    echo "Girilen kullanıcı adı: " . htmlspecialchars($username_input) . "<br>";
    echo "Girilen şifre uzunluğu: " . strlen($password_input) . " karakter<br><br>";
    
    // Kullanıcıyı ara
    $sql = "SELECT * FROM kullanicilar WHERE username = :username";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':username', $username_input);
    
    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result) {
            echo "✅ Kullanıcı veritabanında bulundu<br>";
            echo "Kullanıcı ID: " . $result['id'] . "<br>";
            echo "Email: " . $result['email'] . "<br>";
            echo "Kayıtlı şifre hash: " . substr($result['password'], 0, 20) . "...<br><br>";
            
            // Şifre doğrulama
            if (password_verify($password_input, $result['password'])) {
                echo "✅ Şifre doğru! Login başarılı<br>";
                
                // Session ayarla
                $_SESSION['loggedin'] = true;
                $_SESSION['username'] = $username_input;
                $_SESSION['user_id'] = $result['id'];
                
                echo "✅ Session ayarlandı<br>";
                echo "Session ID: " . session_id() . "<br>";
                
                $message = "Login başarılı! Ana sayfaya yönlendiriliyorsunuz...";
                echo "<script>setTimeout(function(){ window.location.href = '/'; }, 3000);</script>";
            } else {
                echo "❌ Şifre yanlış!<br>";
                $message = "Şifre hatalı!";
            }
        } else {
            echo "❌ Kullanıcı bulunamadı<br>";
            $message = "Kullanıcı bulunamadı!";
        }
    } else {
        echo "❌ Veritabanı sorgu hatası<br>";
        $message = "Veritabanı hatası!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Login Test</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f0f0f0; }
        .form { background: white; padding: 20px; border-radius: 8px; max-width: 400px; }
        input { width: 100%; padding: 10px; margin: 5px 0; border: 1px solid #ddd; border-radius: 4px; }
        button { background: #007cba; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; }
        .message { padding: 10px; margin: 10px 0; border-radius: 4px; background: #e7f3ff; }
    </style>
</head>
<body>
    <h2>🔐 Login Test Sayfası</h2>
    
    <?php if ($message): ?>
        <div class="message"><?php echo $message; ?></div>
    <?php endif; ?>
    
    <div class="form">
        <form method="POST">
            <h3>Giriş Yap</h3>
            <input type="text" name="username" placeholder="Kullanıcı Adı" required>
            <input type="password" name="password" placeholder="Şifre" required>
            <button type="submit">Test Et</button>
        </form>
    </div>
    
    <h3>📊 Mevcut Session Durumu:</h3>
    <p>Session ID: <?php echo session_id(); ?></p>
    <p>Logged in: <?php echo isset($_SESSION['loggedin']) ? 'Evet' : 'Hayır'; ?></p>
    <?php if (isset($_SESSION['username'])): ?>
        <p>Kullanıcı: <?php echo $_SESSION['username']; ?></p>
    <?php endif; ?>
    
    <p><a href="/">← Ana Sayfaya Dön</a></p>
</body>
</html>