<?php
session_start(); // Oturumu başlat

// Veritabanındaki session'ı sonlandır
if (isset($_SESSION['db_session_id']) && isset($_SESSION['user_id'])) {
    try {
        require_once __DIR__ . '/inc/database.php';
        
        // Session'ı manuel olarak sonlandır
        $stmt = $conn->prepare("UPDATE user_sessions SET is_active = FALSE, terminated_at = NOW(), termination_reason = 'user_logout' WHERE session_id = ? AND user_id = ?");
        $stmt->bind_param("si", $_SESSION['db_session_id'], $_SESSION['user_id']);
        $stmt->execute();
        
        if ($stmt->affected_rows > 0) {
            error_log("Session terminated successfully for user_id: " . $_SESSION['user_id'] . ", session_id: " . $_SESSION['db_session_id']);
        } else {
            error_log("No session found to terminate for user_id: " . $_SESSION['user_id'] . ", session_id: " . $_SESSION['db_session_id']);
        }
        
    } catch (Throwable $e) {
        error_log("Session termination failed: " . $e->getMessage());
    }
}

// Oturumdaki tüm değişkenleri temizle
$_SESSION = [];

// Oturumu yok et
session_destroy();

// Kullanıcıyı giriş sayfasına veya ana sayfaya yönlendir
header("Location: /"); // veya istediğiniz sayfa
exit();
?>
