<?php
// Kullanıcı oturumunu sonlandır
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Tüm oturum verilerini temizle
$_SESSION = [];

// Oturum çerezini geçersiz kıl
if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params['path'] ?? '/',
        $params['domain'] ?? '',
        $params['secure'] ?? false,
        $params['httponly'] ?? true
    );
}

// Oturumu yok et
session_destroy();

// Ana sayfaya yönlendir
header('Location: /');
exit;
?>