<?php
// Basit SMTP gönderim test sayfası
// Bu sayfa, inc/send_mail.php üzerinden e-posta göndermeyi dener.

require_once __DIR__ . '/inc/send_mail.php';

function tail_file($path, $maxBytes = 4000) {
    if (!file_exists($path)) { return "Log dosyası bulunamadı."; }
    $size = filesize($path);
    $bytes = min($maxBytes, $size);
    $fp = fopen($path, 'rb');
    if (!$fp) { return "Log dosyası açılamadı."; }
    fseek($fp, -$bytes, SEEK_END);
    $data = fread($fp, $bytes);
    fclose($fp);
    return $data;
}

$message = null;
$logOutput = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $to = isset($_POST['to']) ? trim($_POST['to']) : '';
    $subject = isset($_POST['subject']) ? trim($_POST['subject']) : 'SMTP Test';
    $body = isset($_POST['body']) ? trim($_POST['body']) : 'Merhaba, bu bir SMTP test mesajıdır.';

    if ($to === '') {
        $message = 'Lütfen alıcı e-posta adresi girin.';
    } else {
        $ok = send_mail($to, $subject, nl2br($body));
        $message = $ok ? 'Gönderim başarılı.' : 'Gönderim başarısız.';
        $logOutput = tail_file(__DIR__ . '/inc/error.log');
    }
}
?>
<!doctype html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SMTP Gönderim Testi</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 24px; }
        .container { max-width: 680px; margin: 0 auto; }
        label { display: block; margin: 8px 0 4px; }
        input[type="text"], input[type="email"], textarea {
            width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;
        }
        button { margin-top: 12px; padding: 10px 14px; border: none; border-radius: 4px; background: #007bff; color: #fff; cursor: pointer; }
        button:hover { filter: brightness(0.95); }
        .msg { margin-top: 12px; padding: 10px; border-radius: 4px; }
        .ok { background: #d4edda; color: #155724; }
        .err { background: #f8d7da; color: #721c24; }
        pre { background: #f6f8fa; padding: 10px; overflow: auto; border: 1px solid #ddd; border-radius: 4px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>SMTP Gönderim Testi</h1>
        <?php if ($message !== null): ?>
            <div class="msg <?php echo ($message === 'Gönderim başarılı.') ? 'ok' : 'err'; ?>">
                <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
            </div>
        <?php endif; ?>
        <form method="post">
            <label for="to">Alıcı (To)</label>
            <input type="email" id="to" name="to" placeholder="alici@domain.tld" value="<?php echo isset($_POST['to']) ? htmlspecialchars($_POST['to'], ENT_QUOTES, 'UTF-8') : 'blackbetdestek@yandex.com'; ?>" required>

            <label for="subject">Konu (Subject)</label>
            <input type="text" id="subject" name="subject" value="<?php echo isset($_POST['subject']) ? htmlspecialchars($_POST['subject'], ENT_QUOTES, 'UTF-8') : 'SMTP Test'; ?>" required>

            <label for="body">Mesaj (Body)</label>
            <textarea id="body" name="body" rows="6" placeholder="Mesaj içeriği..." required><?php echo isset($_POST['body']) ? htmlspecialchars($_POST['body'], ENT_QUOTES, 'UTF-8') : "Merhaba, bu bir SMTP test mesajıdır."; ?></textarea>

            <button type="submit">Gönder</button>
        </form>

        <?php if ($logOutput !== null): ?>
            <h2>Son Log Çıktısı (inc/error.log)</h2>
            <pre><?php echo htmlspecialchars($logOutput, ENT_QUOTES, 'UTF-8'); ?></pre>
        <?php endif; ?>
    </div>
</body>
</html>