<?php
session_start();

// Veritabanı bağlantısı
$servername = "localhost";
$username = "blacrhdy_bet1";
$password = "blacrhdy_bet1";
$dbname = "blacrhdy_bet1";

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Oturumdan aktif kullanıcıyı al
    if (!isset($_SESSION['username'])) {
        die("Oturum açılmamış! Lütfen giriş yapın.");
    }
    $activeUsername = $_SESSION['username'];

    // Kullanıcı bilgilerini sorgula
    $stmt = $conn->prepare("SELECT * FROM kullanicilar WHERE username = :username AND is_disabled = 0");
    $stmt->bindParam(':username', $activeUsername);
    $stmt->execute();

    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        die("Kullanıcı bulunamadı veya devre dışı.");
    }

    // Kullanıcı bilgileri
    $fullname = $user['first_name'] . ' ' . $user['surname'];
    $usercode = $user['id'];

    // Formdan alınan ödeme miktarı
    if (!isset($_POST['amount']) || empty($_POST['amount'])) {
        die("Ödeme miktarı girilmemiş!");
    }

    $amount = floatval($_POST['amount']); // Miktarı sayıya dönüştür
    if ($amount <= 0) {
        die("Geçersiz ödeme miktarı.");
    }

    $currency = "TRY"; // Para birimi

    // API bilgileri
    $apikey = "7b3ee21b54b01295dc602dbadb434e09";
    $apisecret = "b06536e98bec72f5c69d0afffd51728f";
    $host = "https://onayhavale.app";

    // İşlem tipi (Hash için)
    $method = "deposit.bank";

    // Hash oluştur
    $hashString = sprintf('%s-%s-%s', $apikey, $method, $apisecret);
    $hash = hash('sha256', $hashString);

    // Benzersiz Merchant Transaction ID
    $merchantTxId = uniqid('tx_');

    // Başarılı, başarısız ve callback URL'leri
    $successUrl = "https://gatesofbet9131.com/success";
    $failUrl = "https://gatesofbet9131.com/fail";
    $callbackUrl = "https://gatesofbet9131.com/callback";

    // API URL
    $url = $host . "/api/deposit/bank-transfer";

    // POST verisi
    $postData = [
        'apikey' => $apikey,
        'hash' => $hash,
        'username' => $activeUsername,
        'usercode' => $usercode,
        'fullname' => $fullname,
        'amount' => number_format($amount, 2, '.', ''), // Miktarı 2 ondalıklı formatta gönder
        'currency' => $currency,
        'successUrl' => $successUrl,
        'failUrl' => $failUrl,
        'callbackUrl' => $callbackUrl,
        'merchantTxId' => $merchantTxId
    ];

    // CURL ile API isteği gönder
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        die("CURL Hatası: " . curl_error($ch));
    }

    curl_close($ch);

    // Yanıtı kontrol et
    $responseData = json_decode($response, true);

    // Yanıtı log dosyasına kaydet
    $logMessage = "API Yanıtı: " . print_r($responseData, true);
    file_put_contents('api_response_log.txt', $logMessage . "\n", FILE_APPEND);

    if (isset($responseData['data']['url'])) {
        // Gelen URL'ye yönlendir
        header("Location: " . $responseData['data']['url']);
        exit;
    } else {
        // Hata mesajını göster
        echo "İşlem başarısız: " . htmlspecialchars($responseData['message']);
        
        // Fail durumunda callback URL'sine yönlendirme
        if (isset($responseData['data']['failUrl'])) {
            // Callback URL'sini tetikle
            header("Location: " . $responseData['data']['failUrl']);
            exit;
        }
    }
} catch (PDOException $e) {
    echo "Veritabanı Hatası: " . $e->getMessage();
} catch (Exception $e) {
    echo "Bir Hata Oluştu: " . $e->getMessage();
}
?>
