<?php
session_start(); // Oturumu başlatıyoruz

// API URL
$url = "https://tbs2api.aslot.net/API/openGame/";

// Aktif kullanıcının username bilgisini oturumdan alıyoruz
$player_login = isset($_SESSION['username']) ? $_SESSION['username'] : 'default_username';

// Request payload
$data = array(
    "cmd" => "openGame",
    "hall" => "3205588",
    "domain" => "https://betkayi1.com", 
    "exitUrl" => "https://betkayi1.com/close.php",
    "language" => "tr",
    "key" => "betkayiana",
    "login" => $player_login, // Oturumdan alınan kullanıcı adı burada kullanılıyor
    "gameId" => "3002", // Sabit gameId değeri
    "cdnUrl" => "http://cdn.lvslot.net/resources",
    "demo" => "0"
);

// Initialize cURL
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json'
));

// Execute request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo 'Error:' . curl_error($ch);
} else {
    // Handle the response
    $response_data = json_decode($response, true);

    // Check if the response contains a game URL
    if (isset($response_data['content']['game']['url'])) {
        // Redirect to the game URL
        $game_url = $response_data['content']['game']['url'];
        header("Location: $game_url");
        exit; // Stop further execution to ensure redirection
    } else {
        echo "Game URL not found.";
        print_r($response_data); // For debugging if URL is missing
    }
}

// Close cURL
curl_close($ch);
?>
