<?php
session_start(); // Oturumu başlat

// Veritabanı bağlantısını dahil et
require '../profile/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Kullanıcıdan gelen şifreleri al
    $oldPwd = $_POST['oldPwd'];
    $newPwd = $_POST['newPwd'];

    // Kullanıcının oturum açıp açmadığını kontrol et
    $isLoggedIn = isset($_SESSION['username']); // Kullanıcının oturum açıp açmadığını kontrol et
    $username = $isLoggedIn ? $_SESSION['username'] : ''; // Oturumdan kullanıcı adını al

    // Eğer oturum açık değilse hata mesajı gönder
    if (!$isLoggedIn) {
        echo json_encode(["status" => "error", "message" => "Oturum açmanız gerekiyor."]);
        exit;
    }

    // Yeni şifrede büyük harf, küçük harf, sayı ve özel karakter kontrolü
if (!preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W])[A-Za-z\d\W]{8,}$/', $newPwd)) {
        echo json_encode(["status" => "error", "message" => "Şifre en az bir büyük harf, bir küçük harf, bir rakam ve bir özel karakter içermeli ve en az 8 karakter uzunluğunda olmalıdır."]);
        exit;
    }

    // Veritabanından kullanıcının şifresini al (username'e göre)
    $query = "SELECT password FROM kullanicilar WHERE username = :username";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':username', $username);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Kullanıcı veritabanında yoksa
    if (!$user) {
        echo json_encode(["status" => "error", "message" => "Kullanıcı bulunamadı."]);
        exit;
    }

    // Veritabanından alınan şifre hash'i
    $dbPassword = $user['password'];

    // Eski şifreyi kontrol et
    if (!password_verify($oldPwd, $dbPassword)) {
        echo json_encode(["status" => "error", "message" => "Eski şifre hatalı."]);
        exit;
    }

    // Yeni şifreyi hashle
    $newPwdHashed = password_hash($newPwd, PASSWORD_BCRYPT);

    // Yeni şifreyi veritabanında güncelle (username'e göre)
    $updateQuery = "UPDATE kullanicilar SET password = :newPwd WHERE username = :username";
    $stmt = $pdo->prepare($updateQuery);
    $stmt->bindParam(':newPwd', $newPwdHashed);
    $stmt->bindParam(':username', $username);

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Şifre başarıyla güncellendi."]);
    } else {
        echo json_encode(["status" => "error", "message" => "Şifre güncellenirken bir hata oluştu."]);
    }
}
?>