<?php ?>
<!doctype html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Para Yatır / Para Çekme</title>
    <style>
        :root {
            --bg: #000;
            --panel: #000;
            --pri: #e5b645;
            --txt: #fff;
            --muted: #8b93a7;
            --accent: #e5b645;
            --shadow: rgba(0,0,0,.35)
        }
        * {
            box-sizing: border-box
        }
        body {
            margin: 0;
            background: var(--bg);
            color: var(--txt);
            font: 14px/1.4 system-ui,-apple-system,"Segoe UI",Roboto
        }
        .wrap {
            max-width: 920px;
            margin: 0 auto;
            padding: 14px
        }
        .card {
            background: #000!important;
            border: 1px solid rgba(255,255,255,.08);
            border-radius: 12px;
            box-shadow: 0 10px 30px var(--shadow);
            padding: 12px
        }
        .row {
            display: flex;
            gap: 12px
        }
        .row>.col {
            flex: 1
        }
        .h {
            font-weight: 800;
            color: var(--accent)
        }
        .muted {
            color: var(--muted)
        }
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px;
            border-radius: 10px;
            border: 1px solid rgba(255,255,255,.08);
            background: linear-gradient(180deg,#e5b645,#d4a536);
            color: #0b1020;
            font-weight: 800;
            cursor: pointer
        }
        .btn.secondary {
            background: rgba(255,255,255,.06);
            color: #fff
        }
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fill,minmax(220px,1fr));
            gap: 10px
        }
        .method {
            padding: 10px;
            border-radius: 10px;
            background: linear-gradient(180deg,#0b0b0b,#000);
            border: 1px solid rgba(255,255,255,.06);
            display: flex;
            justify-content: space-between;
            align-items: center;
            cursor: pointer
        }
        .method .t {
            font-weight: 700
        }
        .copy {
            background: rgba(255,255,255,.06);
            border: 1px solid rgba(255,255,255,.08);
            color: #fff;
            border-radius: 8px;
            padding: 8px;
            cursor: pointer
        }
        input[type=number], input[type=text], select {
            width: 100%;
            padding: 10px 12px;
            border-radius: 10px;
            border: 1px solid rgba(255,255,255,.08);
            background: rgba(255,255,255,.03);
            color: #fff
        }
        .box {
            border: 1px dashed rgba(255,255,255,.15);
            border-radius: 10px;
            padding: 10px;
            margin-top: 8px;
            display: flex;
            justify-content: space-between;
            align-items: center
        }
        .timer {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(255,255,255,.06);
            padding: 6px 10px;
            border-radius: 10px
        }
        @media(max-width:640px) {
            .row {
                flex-direction: column
            }
        }
        .tabs {
            display: flex;
            gap: 20px;
            align-items: center;
            border: 1px solid rgba(255,255,255,.12);
            border-radius: 12px;
            padding: 10px 12px;
            background: rgba(255,255,255,.03);
            margin-bottom: 8px
        }
        .tab {
            padding: 10px 6px;
            color: #e6e9ef;
            cursor: pointer;
            font-weight: 700;
            font-size: 12px
        }
        .tab.active {
            color: var(--accent);
            border-bottom: 3px solid var(--accent)
        }
        .tabpan {
            display: none
        }
        .tabpan.active {
            display: block
        }
        .bank-selection {
            margin-top: 10px;
            display: none;
        }
        .bank-selection select {
            background: rgba(255,255,255,.03);
            color: #fff;
            border: 1px solid rgba(255,255,255,.08);
        }
        .bank-selection select option {
            background: #000;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="wrap">
        <div class="card">
            <div class="tabs">
                <div class="tab active" id="tabDeposit" onclick="switchTab('deposit')">Para Yatır</div>
                <div class="tab" id="tabWithdraw" onclick="switchTab('withdraw')">Para Çekme</div>
                <div class="tab" onclick="window.location.href='/'">Anasayfaya Dön</div>
                <div class="col" style="text-align:right">
                    <span class="timer">
                        <span id="dwFastCountdown" data-seconds="900">15:00</span>
                    </span>
                </div>
            </div>
        </div>

        <!-- Deposit Panel -->
        <div id="panelDeposit" class="tabpan active">
            <div class="row">
                <div class="col">
                    <div class="h">Para Yatır</div>
                    <div class="muted">Ödeme yöntemini seçin, verilen süre içinde işlemi tamamlayın.</div>
                </div>
            </div>

            <div class="h" style="margin-top:10px">Adım 1 • Yöntem Seç</div>
            <div class="grid" id="methodGrid">
                <div class="method" onclick="selectMethod('fast')">
                    <div>
                        <div class="t">Havale/EFT (FAST)</div>
                        <div class="muted">1-15 dk • min ₺500</div>
                    </div>
                    <img src="/assets/images/havale.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('param')">
                    <div>
                        <div class="t">Param</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/param.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('paycel')">
                    <div>
                        <div class="t">Paycel</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/paycel.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('hadi')">
                    <div>
                        <div class="t">Hadi</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/hadi.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('ahlpay')">
                    <div>
                        <div class="t">Ahl Pay</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/ahlpay.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('uption')">
                    <div>
                        <div class="t">Uption</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/uption.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('morpara')">
                    <div>
                        <div class="t">Morpara</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/morpara.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectMethod('usdt')">
                    <div>
                        <div class="t">USDT (TRC20)</div>
                        <div class="muted">Kripto • 7/24</div>
                    </div>
                    <img src="/assets/images/kripto.png" alt="" style="height:28px">
                </div>
            </div>

            <!-- Bank Selection for FAST method -->
            <div id="bankSelection" class="bank-selection">
                <div class="h">Banka Seçimi</div>
                <select id="bankSelect" onchange="updateBankInfo()">
                    <option value="">Banka seçiniz...</option>
                </select>
            </div>

            <div id="step2" style="margin-top:12px;display:none">
                <div class="h">Adım 2 • Alıcı Hesap</div>
                <div class="box">
                    <div>
                        <div class="muted">İsim</div>
                        <div id="accName">MYPAYZ ÖDEME KURULUŞU A.Ş.</div>
                    </div>
                    <button class="copy" onclick="copyText(document.getElementById('accName').textContent)">Kopyala</button>
                </div>
                <div class="box">
                    <div>
                        <div class="muted">IBAN No</div>
                        <div id="accIban">TR56000590502580130258013380</div>
                    </div>
                    <button class="copy" onclick="copyText(document.getElementById('accIban').textContent)">Kopyala</button>
                </div>
                <div id="accNote" class="muted" style="margin-top:8px">
                    500₺ altındaki işlemler iade edilecektir. Lütfen belirtilen sürede ödemenizi gerçekleştirin.
                </div>
            </div>

            <div id="step3" style="margin-top:12px">
                <div class="h">Adım 3 • Yatırılacak Tutar</div>
                <input type="number" id="amount" placeholder="₺ Tutar" oninput="calculateUSDTEquivalent()">
                
                <!-- USDT Equivalent Display -->
                <div id="usdtEquivalent" style="display:none;margin-top:8px;padding:10px;background:rgba(229,182,69,0.1);border:1px solid rgba(229,182,69,0.3);border-radius:8px;">
                    <div style="display:flex;justify-content:space-between;align-items:center;">
                        <span class="muted">USDT Karşılığı:</span>
                        <span id="usdtAmount" style="font-weight:700;color:var(--accent);">0.00 USDT</span>
                    </div>
                    <div style="font-size:12px;color:var(--muted);margin-top:4px;">
                        <span>Kur: 1 USDT = </span><span id="usdtRate">34.50</span><span> TL</span>
                    </div>
                </div>
                
                <div style="margin-top:10px;display:flex;gap:8px">
                    <button id="paidBtn" class="btn" onclick="submitPayment()">Ödemeyi Yaptım</button>
                    <button class="btn secondary" onclick="Swal.fire('Bilgi','Sadece kendi adınıza olan bir banka hesabı ile yatırım yapabilirsiniz.','info')">Uyarı</button>
                </div>
            </div>
        </div>

        <!-- Withdraw Panel -->
        <div id="panelWithdraw" class="tabpan">
            <div class="h">Para Çekme</div>
            <div class="muted">Kendi adınıza kayıtlı bir hesapla çekim talebi oluşturun.</div>
            
            <div class="h" style="margin-top:10px">Adım 1 • Yöntem Seç</div>
            <div class="grid" id="wdMethodGrid">
                <div class="method" onclick="selectWithdrawMethod('havale')">
                    <div>
                        <div class="t">Havale/EFT (FAST)</div>
                        <div class="muted">1-15 dk • max ₺50.000</div>
                    </div>
                    <img src="/assets/images/havale.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectWithdrawMethod('papara')">
                    <div>
                        <div class="t">Papara</div>
                        <div class="muted">Hızlı • Ücretsiz</div>
                    </div>
                    <img src="/assets/images/papara.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectWithdrawMethod('payfix')">
                    <div>
                        <div class="t">PayFix</div>
                        <div class="muted">Hızlı • Güvenli</div>
                    </div>
                    <img src="/assets/images/payfix.png" alt="" style="height:28px">
                </div>
                <div class="method" onclick="selectWithdrawMethod('usdt')">
                    <div>
                        <div class="t">USDT (TRC20)</div>
                        <div class="muted">Kripto • 7/24</div>
                    </div>
                    <img src="/assets/images/kripto.png" alt="" style="height:28px">
                </div>
            </div>

            <div id="wdStep2" style="margin-top:12px">
                <div class="h">Adım 2 • Hesap Bilgisi</div>
                <input type="text" id="wdIban" placeholder="IBAN / Hesap">
            </div>

            <div id="wdStep3" style="margin-top:12px">
                <div class="h">Adım 3 • Çekilecek Tutar</div>
                <input type="number" id="wdAmount" placeholder="₺ Tutar">
                <div style="margin-top:10px;display:flex;gap:8px">
                    <button class="btn" onclick="submitWithdraw()">Talebi Gönder</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        let method = '';
        let availableBanks = [];
        let usdtRate = 34.50; // Default USDT rate, will be updated from API

        // Fetch current USDT rate
        function fetchUSDTRate() {
            // You can replace this with a real crypto API
            fetch('https://api.coingecko.com/api/v3/simple/price?ids=tether&vs_currencies=try')
                .then(response => response.json())
                .then(data => {
                    if (data.tether && data.tether.try) {
                        usdtRate = data.tether.try;
                        document.getElementById('usdtRate').textContent = usdtRate.toFixed(2);
                        calculateUSDTEquivalent(); // Recalculate if amount is already entered
                    }
                })
                .catch(error => {
                    console.log('USDT kuru alınamadı, varsayılan kur kullanılıyor:', error);
                });
        }

        // Calculate USDT equivalent of entered TL amount
        function calculateUSDTEquivalent() {
            const amount = parseFloat(document.getElementById('amount').value || '0');
            const usdtEquivalentDiv = document.getElementById('usdtEquivalent');
            const usdtAmountSpan = document.getElementById('usdtAmount');
            
            if (method === 'usdt' && amount > 0) {
                const usdtAmount = (amount / usdtRate).toFixed(6);
                usdtAmountSpan.textContent = usdtAmount + ' USDT';
                usdtEquivalentDiv.style.display = 'block';
            } else {
                usdtEquivalentDiv.style.display = 'none';
            }
        }

        function switchTab(t) {
            document.getElementById('tabDeposit').classList.toggle('active', t === 'deposit');
            document.getElementById('tabWithdraw').classList.toggle('active', t === 'withdraw');
            document.getElementById('panelDeposit').classList.toggle('active', t === 'deposit');
            document.getElementById('panelWithdraw').classList.toggle('active', t === 'withdraw');
            
            if (t === 'deposit' && method === 'fast') {
                initFastCountdown();
            }
        }

        function loadBanks() {
            fetch('/woohdd/payment_methods.php?api=get_banks')
                .then(r => r.json())
                .then(banks => {
                    availableBanks = banks;
                    const select = document.getElementById('bankSelect');
                    select.innerHTML = '<option value="">Banka seçiniz...</option>';
                    
                    banks.forEach(bank => {
                        const option = document.createElement('option');
                        option.value = bank.id;
                        option.textContent = bank.bank_name;
                        select.appendChild(option);
                    });
                })
                .catch(err => {
                    console.error('Banka listesi yüklenemedi:', err);
                });
        }

        function updateBankInfo() {
            const select = document.getElementById('bankSelect');
            const selectedBankId = select.value;
            
            if (!selectedBankId) {
                document.getElementById('step2').style.display = 'none';
                return;
            }

            const selectedBank = availableBanks.find(bank => bank.id == selectedBankId);
            if (selectedBank) {
                document.getElementById('accName').textContent = selectedBank.account_name;
                document.getElementById('accIban').textContent = selectedBank.iban;
                document.getElementById('accNote').textContent = '500₺ altındaki işlemler iade edilecektir. Lütfen belirtilen sürede ödemenizi gerçekleştirin.';
                
                document.getElementById('step2').style.display = 'block';
                initFastCountdown();
            }
        }

        function selectMethod(m) {
            method = m;
            
            // Hide bank selection first
            document.getElementById('bankSelection').style.display = 'none';
            document.getElementById('step2').style.display = 'none';
            
            if (m === 'fast') {
                // Show bank selection for FAST method
                document.getElementById('bankSelection').style.display = 'block';
                loadBanks();
                return;
            }
            
            // For other methods, show step2 directly
            document.getElementById('step2').style.display = 'block';
            
            fetch('/woohdd/payment_methods.php?api=get_payment_methods')
                .then(r => r.json())
                .then(cfg => {
                    const n = document.getElementById('accName'),
                          i = document.getElementById('accIban'),
                          note = document.getElementById('accNote');
                    
                    if (m === 'param') {
                        n.textContent = cfg.param.name + ' (Param)';
                        i.textContent = 'No: ' + cfg.param.number;
                        note.textContent = cfg.param.note;
                    } else if (m === 'paycel') {
                        n.textContent = cfg.paycel.name + ' (Paycel)';
                        i.textContent = 'No: ' + cfg.paycel.number;
                        note.textContent = cfg.paycel.note;
                    } else if (m === 'hadi') {
                        n.textContent = cfg.hadi.name + ' (Hadi)';
                        i.textContent = 'No: ' + cfg.hadi.number;
                        note.textContent = cfg.hadi.note;
                    } else if (m === 'ahlpay') {
                        n.textContent = cfg.ahlpay.name + ' (Ahl Pay)';
                        i.textContent = 'No: ' + cfg.ahlpay.number;
                        note.textContent = cfg.ahlpay.note;
                    } else if (m === 'uption') {
                        n.textContent = cfg.uption.name + ' (Uption)';
                        i.textContent = 'No: ' + cfg.uption.number;
                        note.textContent = cfg.uption.note;
                    } else if (m === 'morpara') {
                        n.textContent = cfg.morpara.name + ' (Morpara)';
                        i.textContent = 'No: ' + cfg.morpara.number;
                        note.textContent = cfg.morpara.note;
                    } else if (m === 'usdt') {
                        n.textContent = 'USDT ' + cfg.usdt.network + ' Ağı';
                        i.textContent = cfg.usdt.address;
                        note.textContent = cfg.usdt.note;
                        
                        // Fetch USDT rate when USDT method is selected
                        fetchUSDTRate();
                        calculateUSDTEquivalent(); // Show USDT equivalent if amount is already entered
                    }
                    
                    document.getElementById('paidBtn').textContent = (m === 'fast') ? 
                        'Ödemeyi Yaptım' : 'Para Transferini Gerçekleştirdim';
                })
                .catch(() => {
                    document.getElementById('step2').style.display = 'block';
                });
        }

        function copyText(t) {
            if (!t) return;
            
            const toast = {
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 1400,
                timerProgressBar: true,
                background: 'rgba(18,24,41,.92)',
                color: '#e6e9ef'
            };
            
            if (navigator.clipboard) {
                navigator.clipboard.writeText(t)
                    .then(() => Swal.fire({...toast, icon: 'success', title: 'Kopyalandı'}))
                    .catch(() => Swal.fire({...toast, icon: 'error', title: 'Kopyalama Hatası'}));
            } else {
                const ta = document.createElement('textarea');
                ta.value = t;
                ta.style.position = 'fixed';
                ta.style.top = '-1000px';
                document.body.appendChild(ta);
                ta.select();
                
                try {
                    document.execCommand('copy');
                    Swal.fire({...toast, icon: 'success', title: 'Kopyalandı'});
                } catch (e) {
                    Swal.fire({...toast, icon: 'error', title: 'Kopyalama Hatası'});
                }
                
                document.body.removeChild(ta);
            }
        }

        function initFastCountdown() {
            const c = document.getElementById('dwFastCountdown');
            if (!c) return;
            
            let sec = parseInt(c.getAttribute('data-seconds') || c.getAttribute('data-left') || '900', 10);
            if (!sec || isNaN(sec)) return;
            if (c.getAttribute('data-running') === '1') return;
            
            c.setAttribute('data-running', '1');
            const btn = document.getElementById('paidBtn');
            
            const tick = () => {
                if (sec <= 0) {
                    c.textContent = '00:00';
                    c.setAttribute('data-running', '0');
                    if (btn) btn.textContent = 'Ödemeyi Yaptım';
                    return;
                }
                
                const m = Math.floor(sec / 60), s = sec % 60;
                c.textContent = (m < 10 ? '0' : '') + m + ':' + (s < 10 ? '0' : '') + s;
                
                if (btn && method === 'fast') {
                    btn.textContent = 'Ödemeyi Yaptım (' + sec + 'sn)';
                }
                
                sec--;
                setTimeout(tick, 1000);
            };
            
            tick();
        }

        function submitPayment() {
            const amt = parseFloat(document.getElementById('amount').value || '0');
            
            if (!method) {
                Swal.fire('Hata', 'Lütfen yöntem seçin.', 'error');
                return;
            }
            
            if (!(amt > 0)) {
                Swal.fire('Hata', 'Geçerli bir tutar girin.', 'error');
                return;
            }
            
            fetch('/api/deposit_notify.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({amount: amt, method})
            })
            .then(r => r.json())
            .catch(() => ({ok: false}))
            .then(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Talep Alındı',
                    text: 'Yöntem: ' + method + ' • Tutar: ₺' + amt,
                    confirmButtonText: 'Tamam'
                }).then(() => {
                    window.location.href = '/';
                });
            });
        }

        let wdMethod = 'havale';

        function selectWithdrawMethod(m) {
            wdMethod = m;
            const ib = document.getElementById('wdIban');
            if (!ib) return;
            
            if (m === 'havale') {
                ib.placeholder = 'IBAN / Hesap';
            } else if (m === 'papara') {
                ib.placeholder = 'Papara No';
            } else if (m === 'payfix') {
                ib.placeholder = 'PayFix No';
            } else if (m === 'usdt') {
                ib.placeholder = 'USDT (TRC20) Adresi';
            }
        }

        function submitWithdraw() {
            const iban = document.getElementById('wdIban').value.trim(),
                  amount = parseFloat(document.getElementById('wdAmount').value || '0');
            
            if (!iban) {
                Swal.fire('Hata', 'Hesap bilgisi girin.', 'error');
                return;
            }
            
            if (!(amount > 0)) {
                Swal.fire('Hata', 'Geçerli tutar girin.', 'error');
                return;
            }
            
            fetch('/api/withdraw_notify.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({amount, method: wdMethod, iban})
            })
            .then(r => r.json())
            .then(js => {
                if (js.ok) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Talep Alındı',
                        text: 'Çekim talebiniz oluşturuldu.'
                    }).then(() => {
                        window.location.href = '/';
                    });
                } else {
                    Swal.fire('Hata', 'Talep oluşturulamadı.', 'error');
                }
            });
        }
    </script>
</body>
</html>