<?php
// Direct KYC Test
session_start();

// Session ayarla
$_SESSION['loggedin'] = true;
$_SESSION['username'] = 'aaaa';

echo "=== KYC Direct Test ===\n";
echo "Session: " . ($_SESSION['loggedin'] ? 'OK' : 'FAIL') . "\n";
echo "Username: " . $_SESSION['username'] . "\n\n";

// Test dosyaları oluştur
$test_content = "FAKE JPEG FILE FOR TESTING";
file_put_contents('temp_on.jpg', $test_content);
file_put_contents('temp_arka.jpg', $test_content);

echo "Test dosyaları oluşturuldu.\n";
echo "temp_on.jpg boyutu: " . filesize('temp_on.jpg') . " bytes\n";
echo "temp_arka.jpg boyutu: " . filesize('temp_arka.jpg') . " bytes\n\n";

// POST ve FILES verilerini ayarla
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST = [
    'action' => 'upload_kyc'
];

$_FILES = [
    'kimlik_on' => [
        'name' => 'test_kimlik_on.jpg',
        'type' => 'image/jpeg',
        'tmp_name' => 'temp_on.jpg',
        'error' => UPLOAD_ERR_OK,
        'size' => filesize('temp_on.jpg')
    ],
    'kimlik_arka' => [
        'name' => 'test_kimlik_arka.jpg',
        'type' => 'image/jpeg',
        'tmp_name' => 'temp_arka.jpg',
        'error' => UPLOAD_ERR_OK,
        'size' => filesize('temp_arka.jpg')
    ]
];

echo "POST ve FILES verileri hazırlandı.\n\n";

// KYC handler'ı çağır
echo "=== KYC Handler Çağrılıyor ===\n";
ob_start();

// Handler'ı include et
include 'kyc_handler.php';

$output = ob_get_clean();

echo "Handler Output:\n";
echo $output . "\n";

// Test dosyalarını temizle
if (file_exists('temp_on.jpg')) unlink('temp_on.jpg');
if (file_exists('temp_arka.jpg')) unlink('temp_arka.jpg');

echo "\nTest tamamlandı.\n";
?>