<?php 
session_start(); 

// Veritabanı bağlantısını yapın
include '../inc/database.php'; 

// Kullanıcının oturum açıp açmadığını kontrol edin
$isLoggedIn = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;
$username = $isLoggedIn ? $_SESSION['username'] : ''; // Kullanıcı adını al
$email = ''; // E-posta adresi için bir değişken tanımlayın
$firstName = ''; // Kullanıcının ismi için bir değişken
$surname = ''; // Kullanıcının soyismi için bir değişken

// Kullanıcı giriş yapmamışsa yönlendirme yap
if (!$isLoggedIn) {
    header('Location: /'); // Giriş sayfasına yönlendir
    exit();
}

// Kullanıcının baş harfini al
$initial = strtoupper(substr($username, 0, 1)); // İlk karakteri al ve büyük harfe çevir

// E-posta adresi ve kullanıcı bilgilerini sorgula
$sql = "SELECT email, first_name, surname FROM kullanicilar WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$stmt->bind_result($email, $firstName, $surname);
$stmt->fetch();
$stmt->close();
?>

<?php include '../inc/head.php'; ?>
<?php include '../inc/header.php'; ?>



<div _ngcontent-ouf-c21="" class="centerWrap porfileWrap">
<style>
.mt-theme{display:flex;align-items:center;gap:10px;padding:8px 0}
.mt-theme .breadcrumb{display:flex;flex-wrap:wrap;gap:6px;background:transparent !important;margin:0 !important;padding:0 !important}
 .breadcrumb-item, .breadcrumb-item a{color:#fff !important;text-decoration:none}
 .breadcrumb-item + .breadcrumb-item::before{color:rgba(255,255,255,.6) !important}
 .centerWrap.porfileWrap{padding-top:64px !important}
@media (max-width: 768px){
  .mt-theme{flex-wrap:wrap}
  .breadcrumb{font-size:14px}
  .centerWrap.porfileWrap{padding-top:25px !important}
}
</style>
    <aside _ngcontent-ouf-c27="" class="sidebarMain playersidebarMain">
        <div _ngcontent-ouf-c27="" class="profile-content">
            <div _ngcontent-ouf-c27="" class="edit-user"><!----><!---->                <span class="avatar-holder ng-tns-c27-2 ng-star-inserted"><?php echo $initial; ?></span>

                <div _ngcontent-ouf-c27="" class="user-right"><!----><!---->                    <span class="username ng-tns-c27-2 ng-star-inserted"><?php echo htmlspecialchars($username); ?></span>
</div>
            </div>
            
            
<script>
                document.addEventListener('DOMContentLoaded', function() {
                    const isLoggedIn = <?php echo json_encode($isLoggedIn); ?>;

                    if (isLoggedIn) {
                        // Kullanıcı giriş yapmışsa API'den ana bakiyeyi çek
                        fetch('../api/balanceapi')
                            .then(response => response.json())
                            .then(data => {
                                const balanceText = document.querySelector('.amount'); // .amount sınıfını hedef alıyoruz

                                if (data.status === 'success') {
                                    // Bakiye başarılı bir şekilde çekildiyse span'a yaz
                                    balanceText.textContent = data.ana_bakiye + ' '; // Para birimini ekleyerek yaz
                                } else {
                                    // Hata durumunda kullanıcıya bilgi ver
                                    alert("Hata: " + data.message); // Hata mesajını kullanıcıya göster
                                    console.error(data.message); // Hata mesajını konsola yazdır
                                }
                            })
                            .catch(error => {
                                console.error('Hata:', error);
                                alert("Bir hata oluştu. Lütfen tekrar deneyin."); // Genel hata mesajı
                            });
                    }
                });
            </script>


            
            
            <div _ngcontent-ouf-c27="" class="main-balance">
                <div _ngcontent-ouf-c27="" class="total-balance">
                    <div _ngcontent-ouf-c27="" class="user-balance"><span _ngcontent-ouf-c27="" class="balance-title">Ana Baki̇ye</span><!---->  <span class="amount ng-tns-c27-2 ng-star-inserted">0 </span><!----></div><!----><i _ngcontent-ouf-c27="" class="fa-solid fa-eye eye-icon ng-tns-c27-2 ng-star-inserted"></i>
                </div>
                
                
                
<div _ngcontent-ouf-c27="" class="buttons-bottom">
    <a _ngcontent-ouf-c27="" class="btn deposit-bc" href="/profile/deposit-withdraw">
        <i _ngcontent-ouf-c27="" class="fa-solid fa-wallet"></i> Para Yatır
    </a>
    <a _ngcontent-ouf-c27="" class="btn withdraw-bc" href="/profile/deposit-withdraw">
        <img _ngcontent-ouf-c27="" class="ng-tns-c27-2" alt="" src="assets/images/withdraw-icon.png"> Para Çekme
    </a>
</div>
            </div>
            <div _ngcontent-ouf-c27="" class="main-balance bonus">
                <div _ngcontent-ouf-c27="" class="user-balance"><span _ngcontent-ouf-c27="" class="balance-title">Bonus Bakiyesi</span><!----><span _ngcontent-ouf-c27="" class="amount ng-tns-c27-2 ng-star-inserted">0 ₺</span><!----></div>
            </div>
        </div>
        <div _ngcontent-ouf-c27="" class="sideSports">
            <ul _ngcontent-ouf-c27="" class="ng-tns-c27-2"><!----><!----><!----><!---->
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
    <a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/account-details">Profilim</a>
</li>

                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/account-statement">İşlem Geçmişi</a></li><!----><!----><!----><!----><!----><!---->
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/bet-history">Casino Geçmişi</a></li><!----><!----><!----><!----><!----><!----><!---->
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/invite">Davet Linki</a></li>
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/referral">Referans Programı</a></li>
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/responsible_gaming">Sorumlu Oyun</a></li>
                
                                               <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><span _ngcontent-ouf-c27="" class="ng-tns-c27-2" aria-disabled="true" style="cursor: default" type="GROUP"></span></li><!----><!---->

                
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/promotions.php">Promosyonlar</a></li><!----><!---->
         <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2" style="cursor: pointer" type="GROUP" href="/profile/deposit-withdraw">Para Yatırma/para Çekme</a></li><!----><!----><!----><!----><!----><!----><!---->
                <li _ngcontent-ouf-c27="" style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted"><a _ngcontent-ouf-c27="" class="ng-tns-c27-2 select active" style="cursor: pointer" type="GROUP">Kyc</a></li><!----><!---->
            </ul>
        </div>
    </aside>
</app-g6-sidebar-profile></app-player-sidebar-profile>

<app-player-kyc _nghost-mso-c56="" class="ng-star-inserted"><!----><!----><!----><!----><!----><!----><!----><app-all-player-kyc _ngcontent-mso-c56="" _nghost-mso-c57="" class="ng-star-inserted">
        <div _ngcontent-mso-c57="" class="container">
            <div _ngcontent-mso-c57="" class="row">
                <div _ngcontent-mso-c57="" class="col-12 mt-theme">
                    <ul _ngcontent-mso-c57="" class="breadcrumb">
<li _ngcontent-ouf-c48="" class="breadcrumb-item">
    <a _ngcontent-ouf-c48="" href="/">Ana Sayfa</a>
</li>                        <li _ngcontent-mso-c57="" aria-current="page" class="breadcrumb-item">Kyc</li>
                    </ul>
                </div>
                <div _ngcontent-mso-c57="" class="col-12">
                    <div _ngcontent-mso-c57="" class="profileRow">
                        <div _ngcontent-mso-c57="" class="row">
                            <div _ngcontent-mso-c57="" class="col-12 kycTabs">
                                
                        <div class="kyc-header">
                            <div class="kyc-title-section">
                                <h2 class="kyc-title">
                                    <i class="fas fa-shield-alt"></i>
                                    Hesap Doğrulama
                                </h2>
                                <div class="risk-status-badge" id="risk-status-badge" onclick="toggleRiskDetails()">
                                    Risk Seviyesi: Yükleniyor...
                                </div>
                            </div>
                            <p class="kyc-subtitle">Hesabınızı güvenli hale getirmek için kimlik doğrulama işlemlerini tamamlayın</p>
                            
                            <!-- Risk Detayları Paneli -->
                            <div class="risk-details-panel" id="riskDetailsPanel" style="display: none;">
                                <div class="risk-details-header">
                                    <h4><i class="fas fa-info-circle"></i> Risk Değerlendirme Detayları</h4>
                                    <button class="close-risk-details" onclick="toggleRiskDetails()">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                                <div class="risk-details-content">
                                    <div class="risk-score-display">
                                        <div class="risk-score-circle">
                                            <span id="riskScoreValue">0</span>
                                            <small>/100</small>
                                        </div>
                                        <div class="risk-score-info">
                                            <p><strong>Risk Skoru:</strong> <span id="riskScoreText">Hesaplanıyor...</span></p>
                                            <p><strong>Son Güncelleme:</strong> <span id="lastAssessment">-</span></p>
                                        </div>
                                    </div>
                                    <div class="risk-requirements" id="riskRequirements">
                                        <h5>Gerekli Doğrulamalar:</h5>
                                        <ul id="requirementsList">
                                            <li>Yükleniyor...</li>
                                        </ul>
                                    </div>
                                    <div class="risk-alerts" id="riskAlerts" style="display: none;">
                                        <h5>Aktif Uyarılar:</h5>
                                        <div id="alertsList"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="kyc-container">
                            <div class="kyc-tabs">
                                <button class="kyc-tab active" onclick="showForm('kimlik')">
                                    <i class="fas fa-id-card"></i>
                                    <span>Kimlik Doğrulama</span>
                                </button>
                                <button class="kyc-tab" onclick="showForm('email')">
                                    <i class="fas fa-envelope"></i>
                                    <span>E-posta Doğrulama</span>
                                </button>
                                <button class="kyc-tab" onclick="showForm('telefon')">
                                    <i class="fas fa-phone"></i>
                                    <span>Telefon Doğrulama</span>
                                </button>
                                <button class="kyc-tab" onclick="showForm('adres')">
                                    <i class="fas fa-home"></i>
                                    <span>Adres Doğrulama</span>
                                </button>
                                <button class="kyc-tab" onclick="showForm('gelir')">
                                    <i class="fas fa-money-bill-wave"></i>
                                    <span>Gelir Belgesi</span>
                                </button>
                            </div>

                            <!-- Kimlik Doğrulama Formu -->
                            <div id="kimlikForm" class="kyc-form active">
                                <div class="form-card">
                                    <div class="form-header">
                                        <h3><i class="fas fa-id-card"></i> Kimlik Doğrulama</h3>
                                        <p>Kimlik belgenizin ön ve arka yüzünün fotoğraflarını gönderin</p>
                                    </div>
                                    <div class="form-content">
                                        <div class="upload-area">
                                            <div class="upload-box">
                                                <div class="upload-content">
                                                    <i class="fas fa-id-card"></i>
                                                    <div class="upload-text">
                                                        <h4>Kimlik Ön Yüz</h4>
                                                        <p>Kimlik kartınızın ön yüzünün net fotoğrafını yükleyin</p>
                                                    </div>
                                                </div>
                                                <input type="file" id="kimlikOn" accept="image/*" style="display: none;">
                                                <button class="upload-btn" onclick="document.getElementById('kimlikOn').click()">
                                                    <i class="fas fa-upload"></i> Dosya Seç
                                                </button>
                                                <div id="kimlikOnDisplay" class="file-display" style="display: none;"></div>
                                            </div>
                                            
                                            <div class="upload-box">
                                                <div class="upload-content">
                                                    <i class="fas fa-id-card"></i>
                                                    <div class="upload-text">
                                                        <h4>Kimlik Arka Yüz</h4>
                                                        <p>Kimlik kartınızın arka yüzünün net fotoğrafını yükleyin</p>
                                                    </div>
                                                </div>
                                                <input type="file" id="kimlikArka" accept="image/*" style="display: none;">
                                                <button class="upload-btn" onclick="document.getElementById('kimlikArka').click()">
                                                    <i class="fas fa-upload"></i> Dosya Seç
                                                </button>
                                                <div id="kimlikArkaDisplay" class="file-display" style="display: none;"></div>
                                            </div>
                                        </div>
                                        <div class="form-actions">
                                            <button class="btn-submit" onclick="submitKYCDocuments()">
                                                <i class="fas fa-paper-plane"></i>
                                                Belgeleri Gönder
                                            </button>
                                        </div>
                                        <div class="info-box">
                                            <i class="fas fa-info-circle"></i>
                                            <p>Alternatif olarak belgelerinizi <strong>kyc@example.com</strong> adresine e-posta ile gönderebilirsiniz.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- E-posta Doğrulama Formu -->
                            <div id="emailForm" class="kyc-form">
                                <div class="form-card">
                                    <div class="form-header">
                                        <h3><i class="fas fa-envelope"></i> E-posta Doğrulama</h3>
                                        <p>E-posta adresinizi doğrulayarak hesabınızı güvenli hale getirin</p>
                                    </div>
                                    <div class="form-content">
                                        <div class="input-group">
                                            <label for="emailInput">E-posta Adresi</label>
                                            <input type="email" id="emailInput" placeholder="ornek@email.com" class="form-input">
                                        </div>
                                        <div class="form-actions">
                                            <button class="btn-submit">
                                                <i class="fas fa-key"></i>
                                                Doğrulama Kodu Gönder
                                            </button>
                                            <button class="btn-secondary" onclick="clearForm()">
                                                <i class="fas fa-times"></i>
                                                İptal Et
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Telefon Doğrulama Formu -->
                            <div id="telefonForm" class="kyc-form">
                                <div class="form-card">
                                    <div class="form-header">
                                        <h3><i class="fas fa-phone"></i> Telefon Doğrulama</h3>
                                        <p>Telefon numaranızı doğrulayarak hesabınızı güvenli hale getirin</p>
                                    </div>
                                    <div class="form-content">
                                        <div class="phone-input-group">
                                            <div class="input-group">
                                                <label for="countryCode">Ülke Kodu</label>
                                                <select id="countryCode" class="form-select">
                                                    <option value="+90">🇹🇷 +90 (Türkiye)</option>
                                                    <option value="+1">🇺🇸 +1 (ABD)</option>
                                                    <option value="+44">🇬🇧 +44 (İngiltere)</option>
                                                    <option value="+49">🇩🇪 +49 (Almanya)</option>
                                                </select>
                                            </div>
                                            <div class="input-group">
                                                <label for="phoneInput">Telefon Numarası</label>
                                                <input type="tel" id="phoneInput" placeholder="5XX XXX XX XX" class="form-input">
                                            </div>
                                        </div>
                                        <div class="form-actions">
                                            <button class="btn-submit">
                                                <i class="fas fa-sms"></i>
                                                SMS Doğrulama Kodu Gönder
                                            </button>
                                            <button class="btn-secondary" onclick="clearForm()">
                                                <i class="fas fa-times"></i>
                                                İptal Et
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Adres Doğrulama Formu -->
                            <div id="adresForm" class="kyc-form">
                                <div class="form-card">
                                    <div class="form-header">
                                        <h3><i class="fas fa-home"></i> Adres Doğrulama</h3>
                                        <p>Fatura veya banka ekstresi ile adresinizi doğrulayın</p>
                                    </div>
                                    <div class="form-content">
                                        <!-- Adres Bilgileri -->
                                        <div class="input-group">
                                            <label for="addressLine1">Adres Satır 1 *</label>
                                            <input type="text" id="addressLine1" placeholder="Mahalle, Sokak, Bina No" class="form-input" required>
                                        </div>
                                        <div class="input-group">
                                            <label for="addressLine2">Adres Satır 2</label>
                                            <input type="text" id="addressLine2" placeholder="Daire No, Kat (Opsiyonel)" class="form-input">
                                        </div>
                                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                                            <div class="input-group">
                                                <label for="city">Şehir *</label>
                                                <input type="text" id="city" placeholder="İstanbul" class="form-input" required>
                                            </div>
                                            <div class="input-group">
                                                <label for="postalCode">Posta Kodu *</label>
                                                <input type="text" id="postalCode" placeholder="34000" class="form-input" required>
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="country">Ülke</label>
                                            <select id="country" class="form-select">
                                                <option value="Turkey">🇹🇷 Türkiye</option>
                                                <option value="Germany">🇩🇪 Almanya</option>
                                                <option value="Netherlands">🇳🇱 Hollanda</option>
                                                <option value="Belgium">🇧🇪 Belçika</option>
                                            </select>
                                        </div>

                                        <!-- Belge Türü Seçimi -->
                                        <div class="input-group">
                                            <label for="documentType">Belge Türü *</label>
                                            <select id="documentType" class="form-select" required>
                                                <option value="">Belge türünü seçin</option>
                                                <option value="utility_bill">Elektrik/Su/Gaz Faturası</option>
                                                <option value="bank_statement">Banka Ekstresi</option>
                                                <option value="tax_document">Vergi Belgesi</option>
                                                <option value="rental_agreement">Kira Sözleşmesi</option>
                                                <option value="other">Diğer</option>
                                            </select>
                                        </div>

                                        <!-- Belge Tarihi ve Kurum -->
                                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                                            <div class="input-group">
                                                <label for="documentDate">Belge Tarihi *</label>
                                                <input type="date" id="documentDate" class="form-input" required>
                                            </div>
                                            <div class="input-group">
                                                <label for="documentIssuer">Belgeyi Veren Kurum</label>
                                                <input type="text" id="documentIssuer" placeholder="TEDAŞ, İGDAŞ, vb." class="form-input">
                                            </div>
                                        </div>

                                        <!-- Dosya Yükleme Alanı -->
                                        <div class="upload-area">
                                            <div class="upload-box">
                                                <div class="upload-content">
                                                    <i class="fas fa-file-upload"></i>
                                                    <div class="upload-text">
                                                        <h4>Adres Belgesi Yükle</h4>
                                                        <p>Fatura veya banka ekstresinin net fotoğrafını yükleyin<br>
                                                        <small>Desteklenen formatlar: PDF, JPG, PNG (Max: 10MB)</small></p>
                                                    </div>
                                                </div>
                                                <label for="addressDocument" class="upload-btn">
                                                    <i class="fas fa-plus"></i>
                                                    Dosya Seç
                                                </label>
                                                <input type="file" id="addressDocument" accept=".pdf,.jpg,.jpeg,.png" onchange="handleAddressFileSelect()">
                                            </div>
                                            <div id="addressDocumentDisplay" class="file-display" style="display: none;"></div>
                                        </div>

                                        <!-- Bilgilendirme -->
                                        <div class="info-box">
                                            <i class="fas fa-info-circle"></i>
                                            <div>
                                                <p><strong>Önemli Notlar:</strong></p>
                                                <ul style="margin: 0.5rem 0 0 0; padding-left: 1rem; color: #8b93a7;">
                                                    <li>Belge son 3 ay içinde düzenlenmiş olmalıdır</li>
                                                    <li>Adınız ve adresiniz belgede net bir şekilde görünmelidir</li>
                                                    <li>Belge orijinal ve değiştirilmemiş olmalıdır</li>
                                                    <li>Fotoğraf net ve okunaklı olmalıdır</li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="form-actions">
                                            <button class="btn-submit" onclick="submitAddressVerification()">
                                                <i class="fas fa-upload"></i>
                                                Adres Belgesi Gönder
                                            </button>
                                            <button class="btn-secondary" onclick="clearAddressForm()">
                                                <i class="fas fa-times"></i>
                                                Formu Temizle
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Gelir Belgesi Doğrulama -->
                        <div id="incomeForm" class="kyc-form" style="display: none;">
                            <div class="form-section">
                                <div class="section-header">
                                    <i class="fas fa-money-bill-wave"></i>
                                    <h3>Gelir Belgesi Doğrulama</h3>
                                    <p>Finansal durumunuzu doğrulamak için gelir belgenizi yükleyin</p>
                                </div>

                                <div class="form-content">
                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="incomeDocumentType">Belge Türü</label>
                                            <select id="incomeDocumentType" required>
                                                <option value="">Belge türünü seçin</option>
                                                <option value="salary_slip">Maaş Bordrosu</option>
                                                <option value="tax_return">Vergi Beyannamesi</option>
                                                <option value="bank_statement">Banka Ekstresi</option>
                                                <option value="employment_certificate">İş Belgesi</option>
                                                <option value="business_license">İş Yeri Belgesi</option>
                                                <option value="pension_statement">Emekli Maaşı Belgesi</option>
                                                <option value="investment_statement">Yatırım Geliri Belgesi</option>
                                                <option value="other">Diğer</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="employmentStatus">İstihdam Durumu</label>
                                            <select id="employmentStatus" required>
                                                <option value="">Durumunuzu seçin</option>
                                                <option value="employed">Çalışan</option>
                                                <option value="self_employed">Serbest Meslek</option>
                                                <option value="unemployed">İşsiz</option>
                                                <option value="retired">Emekli</option>
                                                <option value="student">Öğrenci</option>
                                                <option value="other">Diğer</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="monthlyIncome">Aylık Gelir (TL)</label>
                                            <input type="number" id="monthlyIncome" placeholder="Aylık gelirinizi girin" min="0" step="0.01">
                                        </div>
                                        <div class="form-group">
                                            <label for="annualIncome">Yıllık Gelir (TL)</label>
                                            <input type="number" id="annualIncome" placeholder="Yıllık gelirinizi girin" min="0" step="0.01">
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="incomeSource">Gelir Kaynağı</label>
                                            <input type="text" id="incomeSource" placeholder="Gelir kaynağınızı belirtin">
                                        </div>
                                        <div class="form-group">
                                            <label for="employerName">İşveren/Şirket Adı</label>
                                            <input type="text" id="employerName" placeholder="İşveren adını girin">
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="incomeDocumentDate">Belge Tarihi</label>
                                            <input type="date" id="incomeDocumentDate" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="documentIssuer">Belge Düzenleyen</label>
                                            <input type="text" id="documentIssuer" placeholder="Belgeyi düzenleyen kurum/şirket">
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="documentPeriodStart">Belge Dönemi Başlangıç</label>
                                            <input type="date" id="documentPeriodStart">
                                        </div>
                                        <div class="form-group">
                                            <label for="documentPeriodEnd">Belge Dönemi Bitiş</label>
                                            <input type="date" id="documentPeriodEnd">
                                        </div>
                                    </div>

                                    <!-- Dosya Yükleme -->
                                    <div class="form-group">
                                        <label>Gelir Belgesi</label>
                                        <div class="upload-area" id="incomeUploadArea">
                                            <div class="upload-box">
                                                <div class="upload-content">
                                                    <i class="fas fa-cloud-upload-alt"></i>
                                                    <div class="upload-text">
                                                        <h4>Gelir belgenizi yükleyin</h4>
                                                        <p>Maaş bordrosu, vergi beyannamesi veya banka ekstresini yükleyin<br>
                                                        <small>Desteklenen formatlar: PDF, JPG, PNG (Max: 10MB)</small></p>
                                                    </div>
                                                </div>
                                                <label for="incomeDocument" class="upload-btn">
                                                    <i class="fas fa-plus"></i>
                                                    Dosya Seç
                                                </label>
                                                <input type="file" id="incomeDocument" accept=".pdf,.jpg,.jpeg,.png" onchange="handleIncomeFileSelect()">
                                            </div>
                                        </div>
                                        <div id="incomeDocumentDisplay" class="file-display" style="display: none;"></div>
                                    </div>

                                    <!-- Ek Belgeler -->
                                    <div class="form-group">
                                        <label>Ek Belgeler (İsteğe Bağlı)</label>
                                        <div class="upload-area" id="additionalDocsArea">
                                            <div class="upload-box">
                                                <div class="upload-content">
                                                    <i class="fas fa-file-plus"></i>
                                                    <div class="upload-text">
                                                        <h4>Ek belgeler yükleyin</h4>
                                                        <p>İş sözleşmesi, SGK belgesi, vergi levhası vb.<br>
                                                        <small>Desteklenen formatlar: PDF, JPG, PNG (Max: 10MB)</small></p>
                                                    </div>
                                                </div>
                                                <label for="additionalDocuments" class="upload-btn">
                                                    <i class="fas fa-plus"></i>
                                                    Ek Belge Seç
                                                </label>
                                                <input type="file" id="additionalDocuments" accept=".pdf,.jpg,.jpeg,.png" multiple onchange="handleAdditionalDocsSelect()">
                                            </div>
                                        </div>
                                        <div id="additionalDocsDisplay" class="file-display" style="display: none;"></div>
                                    </div>

                                    <!-- Gelir Doğrulama Beyanı -->
                                    <div class="form-group">
                                        <div class="declaration-box">
                                            <h4><i class="fas fa-shield-alt"></i> Gelir Doğrulama Beyanı</h4>
                                            <div class="checkbox-group">
                                                <label class="checkbox-label">
                                                    <input type="checkbox" id="incomeDeclaration" required>
                                                    <span class="checkmark"></span>
                                                    Verdiğim gelir bilgilerinin doğru ve güncel olduğunu beyan ederim
                                                </label>
                                                <label class="checkbox-label">
                                                    <input type="checkbox" id="documentAuthenticity" required>
                                                    <span class="checkmark"></span>
                                                    Yüklediğim belgelerin orijinal ve değiştirilmemiş olduğunu onaylıyorum
                                                </label>
                                                <label class="checkbox-label">
                                                    <input type="checkbox" id="privacyConsent">
                                                    <span class="checkmark"></span>
                                                    Gelir bilgilerimin güvenlik amacıyla işlenmesine izin veriyorum
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Bilgilendirme -->
                                    <div class="info-box">
                                        <i class="fas fa-info-circle"></i>
                                        <div>
                                            <p><strong>Önemli Notlar:</strong></p>
                                            <ul style="margin: 0.5rem 0 0 0; padding-left: 1rem; color: #8b93a7;">
                                                <li>Belge son 6 ay içinde düzenlenmiş olmalıdır</li>
                                                <li>Adınız ve gelir bilgileriniz belgede net bir şekilde görünmelidir</li>
                                                <li>Belge orijinal ve değiştirilmemiş olmalıdır</li>
                                                <li>Maaş bordrosu için son 3 aylık belge yeterlidir</li>
                                                <li>Vergi beyannamesi için son yıla ait belge kabul edilir</li>
                                                <li>Banka ekstresi için son 3 aylık dönem yeterlidir</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="form-actions">
                                        <button class="btn-submit" onclick="submitIncomeVerification()">
                                            <i class="fas fa-upload"></i>
                                            Gelir Belgesi Gönder
                                        </button>
                                        <button class="btn-secondary" onclick="clearIncomeForm()">
                                            <i class="fas fa-times"></i>
                                            Formu Temizle
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

<style>
.kyc-header {
    text-align: center;
    margin-bottom: 2rem;
    padding: 2rem 0;
    background: linear-gradient(135deg, rgba(229, 182, 69, 0.1), rgba(229, 182, 69, 0.05));
    border-radius: 12px;
    border: 1px solid rgba(229, 182, 69, 0.2);
}

.kyc-title {
    color: #e5b645;
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.kyc-subtitle {
    color: #8b93a7;
    font-size: 1rem;
    margin: 0;
}

.kyc-container {
    background: #000;
    border: 1px solid rgba(255, 255, 255, 0.08);
    border-radius: 12px;
    overflow: hidden;
}

.kyc-tabs {
    display: flex;
    background: rgba(255, 255, 255, 0.02);
    border-bottom: 1px solid rgba(255, 255, 255, 0.08);
}

.kyc-tab {
    flex: 1;
    padding: 1rem;
    background: none;
    border: none;
    color: #8b93a7;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    font-weight: 500;
}

.kyc-tab:hover {
    background: rgba(229, 182, 69, 0.1);
    color: #e5b645;
}

.kyc-tab.active {
    background: #e5b645;
    color: #000;
    font-weight: 600;
}

.kyc-form {
    display: none;
    padding: 2rem;
}

.kyc-form.active {
    display: block;
}

.form-card {
    background: rgba(255, 255, 255, 0.02);
    border: 1px solid rgba(255, 255, 255, 0.08);
    border-radius: 12px;
    overflow: visible;
}

.form-header {
    padding: 1.5rem;
    background: rgba(229, 182, 69, 0.05);
    border-bottom: 1px solid rgba(255, 255, 255, 0.08);
}

.form-header h3 {
    color: #e5b645;
    margin: 0 0 0.5rem 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.form-header p {
    color: #8b93a7;
    margin: 0;
}

.form-content {
    padding: 2rem;
}

.upload-area {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    margin-bottom: 2rem;
}

.upload-box {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    padding: 1.5rem;
    border: 1px solid rgba(229, 182, 69, 0.2);
    border-radius: 8px;
    background: rgba(229, 182, 69, 0.02);
    transition: all 0.3s ease;
    min-height: 120px;
}

.upload-box:hover {
    border-color: rgba(229, 182, 69, 0.4);
    background: rgba(229, 182, 69, 0.05);
}

.upload-content {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    flex: 1;
    min-height: 80px;
}

.upload-content i {
    font-size: 1.5rem;
    color: #e5b645;
    min-width: 24px;
}

.upload-text h4 {
    color: #fff;
    margin: 0 0 0.5rem 0;
    font-size: 1.1rem;
    font-weight: 600;
    white-space: normal;
    word-wrap: break-word;
}

.upload-text p {
    color: #8b93a7;
    margin: 0;
    font-size: 0.9rem;
    line-height: 1.5;
    white-space: normal;
    word-wrap: break-word;
}
    margin: 0 0 0.5rem 0;
}

.upload-box p {
    color: #8b93a7;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.upload-box input[type="file"] {
    display: none;
}

.upload-btn {
    background: #e5b645;
    color: #000;
    border: none;
    padding: 0.75rem 1.25rem;
    border-radius: 6px;
    font-weight: 600;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    white-space: nowrap;
}

.upload-btn:hover {
    background: #d4a536;
    transform: translateY(-1px);
}

.input-group {
    margin-bottom: 1.5rem;
}

.input-group label {
    display: block;
    color: #e5b645;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.form-input, .form-select {
    width: 100%;
    padding: 0.75rem 1rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-input:focus, .form-select:focus {
    outline: none;
    border-color: #e5b645;
    background: rgba(255, 255, 255, 0.08);
}

.phone-input-group {
    display: grid;
    grid-template-columns: 1fr 2fr;
    gap: 1rem;
}

.form-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
    margin-bottom: 1.5rem;
}

.btn-submit {
    background: linear-gradient(135deg, #e5b645, #d4a536);
    color: #000;
    border: none;
    padding: 0.75rem 2rem;
    border-radius: 8px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-submit:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(229, 182, 69, 0.3);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 0.75rem 2rem;
    border-radius: 8px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.1);
    transform: translateY(-2px);
}

.file-display {
    margin-top: 1rem;
    padding: 1rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
}

.selected-file {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.75rem;
    background: rgba(229, 182, 69, 0.1);
    border: 1px solid rgba(229, 182, 69, 0.3);
    border-radius: 6px;
    margin-bottom: 0.5rem;
}

.selected-file i {
    color: #e5b645;
    font-size: 1.2rem;
}

.file-info {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.file-name {
    color: #fff;
    font-weight: 500;
    font-size: 0.9rem;
}

.file-size {
    color: #8b93a7;
    font-size: 0.8rem;
}

.remove-file {
    background: rgba(255, 0, 0, 0.1);
    border: 1px solid rgba(255, 0, 0, 0.3);
    color: #ff4757;
    padding: 0.5rem;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.remove-file:hover {
    background: rgba(255, 0, 0, 0.2);
    transform: scale(1.05);
}

.info-box {
    background: rgba(59, 130, 246, 0.1);
    border: 1px solid rgba(59, 130, 246, 0.2);
    border-radius: 8px;
    padding: 1rem;
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
}

.info-box i {
    color: #3b82f6;
    margin-top: 0.2rem;
}

.info-box p {
    color: #8b93a7;
    margin: 0;
    line-height: 1.5;
}

@media (max-width: 768px) {
    .kyc-tabs {
        flex-direction: column;
    }
    
    .upload-box {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .upload-content {
        width: 100%;
    }
    
    .upload-btn {
        align-self: flex-end;
    }
    
    .phone-input-group {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
    }
    
    .kyc-title {
        font-size: 1.5rem;
    }
}

/* Risk Durumu Stilleri */
.kyc-title-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.risk-status-badge {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
}

.risk-status-badge:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
}

.risk-status-badge.low {
    background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
}

.risk-status-badge.medium {
    background: linear-gradient(135deg, #FF9800 0%, #F57C00 100%);
}

.risk-status-badge.high {
    background: linear-gradient(135deg, #FF5722 0%, #D32F2F 100%);
}

.risk-status-badge.critical {
    background: linear-gradient(135deg, #9C27B0 0%, #7B1FA2 100%);
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { box-shadow: 0 2px 10px rgba(156, 39, 176, 0.3); }
    50% { box-shadow: 0 4px 20px rgba(156, 39, 176, 0.6); }
    100% { box-shadow: 0 2px 10px rgba(156, 39, 176, 0.3); }
}

.risk-details-panel {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 10px;
    margin-top: 15px;
    overflow: hidden;
    animation: slideDown 0.3s ease;
}

@keyframes slideDown {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.risk-details-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.risk-details-header h4 {
    margin: 0;
    font-size: 1.1rem;
}

.close-risk-details {
    background: none;
    border: none;
    color: white;
    font-size: 1.2rem;
    cursor: pointer;
    padding: 5px;
    border-radius: 50%;
    transition: background 0.3s ease;
}

.close-risk-details:hover {
    background: rgba(255, 255, 255, 0.2);
}

.risk-details-content {
    padding: 20px;
}

.risk-score-display {
    display: flex;
    align-items: center;
    margin-bottom: 20px;
    padding: 15px;
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

.risk-score-circle {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    margin-right: 20px;
    position: relative;
}

.risk-score-circle span {
    font-size: 1.5rem;
}

.risk-score-circle small {
    font-size: 0.8rem;
    opacity: 0.8;
}

.risk-score-info p {
    margin: 5px 0;
    color: #495057;
}

.risk-requirements {
    background: white;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 15px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

.risk-requirements h5 {
    color: #495057;
    margin-bottom: 10px;
    font-size: 1rem;
}

.risk-requirements ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.risk-requirements li {
    padding: 8px 0;
    border-bottom: 1px solid #e9ecef;
    display: flex;
    align-items: center;
}

.risk-requirements li:last-child {
    border-bottom: none;
}

.risk-requirements li i {
    margin-right: 10px;
    width: 16px;
}

.requirement-completed {
    color: #28a745;
}

.requirement-pending {
    color: #ffc107;
}

.requirement-required {
    color: #dc3545;
}

.risk-alerts {
    background: white;
    padding: 15px;
    border-radius: 8px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

.risk-alerts h5 {
    color: #495057;
    margin-bottom: 10px;
    font-size: 1rem;
}

.alert-item {
    padding: 10px;
    margin-bottom: 10px;
    border-radius: 5px;
    border-left: 4px solid;
}

.alert-item.low {
    background: #d4edda;
    border-color: #28a745;
    color: #155724;
}

.alert-item.medium {
    background: #fff3cd;
    border-color: #ffc107;
    color: #856404;
}

.alert-item.high {
    background: #f8d7da;
    border-color: #dc3545;
    color: #721c24;
}

.alert-item.critical {
    background: #f3e5f5;
    border-color: #9c27b0;
    color: #4a148c;
}

@media (max-width: 768px) {
    .kyc-title-section {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .risk-status-badge {
        margin-top: 10px;
        align-self: stretch;
        text-align: center;
    }
    
    .risk-score-display {
        flex-direction: column;
        text-align: center;
    }
    
    .risk-score-circle {
        margin-right: 0;
        margin-bottom: 15px;
    }
}

/* Beyan kutuları için stiller */
.declaration-box {
    background: linear-gradient(135deg, rgba(229, 182, 69, 0.1), rgba(229, 182, 69, 0.05));
    border: 1px solid rgba(229, 182, 69, 0.2);
    border-radius: 12px;
    padding: 20px;
    margin: 20px 0;
}

.declaration-box h4 {
    color: #e5b645;
    margin-bottom: 15px;
    font-size: 1.1rem;
    display: flex;
    align-items: center;
    gap: 8px;
}

.checkbox-group {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.checkbox-label {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    cursor: pointer;
    font-size: 0.95rem;
    line-height: 1.4;
    color: #8b93a7;
    transition: color 0.3s ease;
}

.checkbox-label:hover {
    color: #e5b645;
}

.checkbox-label input[type="checkbox"] {
    display: none;
}

.checkmark {
    width: 20px;
    height: 20px;
    border: 2px solid #e5b645;
    border-radius: 4px;
    position: relative;
    flex-shrink: 0;
    transition: all 0.3s ease;
    margin-top: 2px;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark {
    background: #e5b645;
    border-color: #e5b645;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #1a1d29;
    font-weight: bold;
    font-size: 14px;
}

.checkbox-label input[type="checkbox"]:required + .checkmark {
    border-color: #e5b645;
}

.checkbox-label input[type="checkbox"]:required:not(:checked) + .checkmark {
    border-color: #ff6b6b;
    animation: shake 0.5s ease-in-out;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-2px); }
    75% { transform: translateX(2px); }
}
</style>

<script>
function showForm(formType) {
    // Tüm formları gizle
    document.querySelectorAll('.kyc-form').forEach(form => {
        form.classList.remove('active');
    });
    
    // Tüm tabları pasif yap
    document.querySelectorAll('.kyc-tab').forEach(tab => {
        tab.classList.remove('active');
    });
    
    // Seçilen formu göster
    const targetForm = formType + 'Form';
    document.getElementById(targetForm).classList.add('active');
    
    // Seçilen tabı aktif yap
    event.target.classList.add('active');
}

function clearForm() {
    // Tüm formları gizle
    document.querySelectorAll('.kyc-form').forEach(form => {
        form.classList.remove('active');
    });
    
    // Tüm tabları pasif yap
    document.querySelectorAll('.kyc-tab').forEach(tab => {
        tab.classList.remove('active');
    });
    
    // İlk tabı aktif yap
    document.querySelector('.kyc-tab').classList.add('active');
    document.getElementById('kimlikForm').classList.add('active');
}

// Dosya seçildiğinde görünmesi için fonksiyonlar
function handleFileSelect(inputId, displayId) {
    const input = document.getElementById(inputId);
    const display = document.getElementById(displayId);
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const fileName = file.name;
        const fileSize = (file.size / 1024 / 1024).toFixed(2); // MB cinsinden
        
        // Sadece dosya bilgilerini göster (önizleme yok)
        display.innerHTML = `
            <div class="selected-file">
                <i class="fas fa-file-image"></i>
                <div class="file-info">
                    <span class="file-name">${fileName}</span>
                    <span class="file-size">${fileSize} MB</span>
                </div>
                <button type="button" class="remove-file" onclick="removeFile('${inputId}', '${displayId}')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        display.style.display = 'block';
    }
}

function removeFile(inputId, displayId) {
    document.getElementById(inputId).value = '';
    document.getElementById(displayId).style.display = 'none';
    document.getElementById(displayId).innerHTML = '';
}

// Dosya yükleme event listener'ları
document.addEventListener('DOMContentLoaded', function() {
    const kimlikOnInput = document.getElementById('kimlikOn');
    const kimlikArkaInput = document.getElementById('kimlikArka');
    
    if (kimlikOnInput) {
        kimlikOnInput.addEventListener('change', function() {
            handleFileSelect('kimlikOn', 'kimlikOnDisplay');
        });
    }
    
    if (kimlikArkaInput) {
        kimlikArkaInput.addEventListener('change', function() {
            handleFileSelect('kimlikArka', 'kimlikArkaDisplay');
        });
    }
});

// Adres doğrulama dosya seçimi
function handleAddressFileSelect() {
    const input = document.getElementById('addressDocument');
    const display = document.getElementById('addressDocumentDisplay');
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const fileName = file.name;
        const fileSize = (file.size / 1024 / 1024).toFixed(2); // MB cinsinden
        
        // Dosya türü kontrolü
        const allowedTypes = ['application/pdf', 'image/jpeg', 'image/jpg', 'image/png'];
        if (!allowedTypes.includes(file.type)) {
            alert('Desteklenmeyen dosya türü. Lütfen PDF, JPG, JPEG veya PNG dosyası seçin.');
            input.value = '';
            return;
        }
        
        // Dosya boyutu kontrolü (10MB)
        if (file.size > 10 * 1024 * 1024) {
            alert('Dosya boyutu 10MB\'dan büyük olamaz.');
            input.value = '';
            return;
        }
        
        display.innerHTML = `
            <div class="selected-file">
                <i class="fas fa-file-alt"></i>
                <div class="file-info">
                    <span class="file-name">${fileName}</span>
                    <span class="file-size">${fileSize} MB</span>
                </div>
                <button type="button" class="remove-file" onclick="removeAddressFile()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        display.style.display = 'block';
    }
}

function removeAddressFile() {
    document.getElementById('addressDocument').value = '';
    document.getElementById('addressDocumentDisplay').style.display = 'none';
    document.getElementById('addressDocumentDisplay').innerHTML = '';
}

function clearAddressForm() {
    // Form alanlarını temizle
    document.getElementById('addressLine1').value = '';
    document.getElementById('addressLine2').value = '';
    document.getElementById('city').value = '';
    document.getElementById('postalCode').value = '';
    document.getElementById('country').value = 'Turkey';
    document.getElementById('documentType').value = '';
    document.getElementById('documentDate').value = '';
    document.getElementById('documentIssuer').value = '';
    
    // Dosya seçimini temizle
    removeAddressFile();
}

function submitAddressVerification() {
    // Form verilerini al
    const addressLine1 = document.getElementById('addressLine1').value.trim();
    const addressLine2 = document.getElementById('addressLine2').value.trim();
    const city = document.getElementById('city').value.trim();
    const postalCode = document.getElementById('postalCode').value.trim();
    const country = document.getElementById('country').value;
    const documentType = document.getElementById('documentType').value;
    const documentDate = document.getElementById('documentDate').value;
    const documentIssuer = document.getElementById('documentIssuer').value.trim();
    const documentFile = document.getElementById('addressDocument').files[0];
    
    // Zorunlu alan kontrolü
    if (!addressLine1 || !city || !postalCode || !documentType || !documentDate || !documentFile) {
        alert('Lütfen tüm zorunlu alanları doldurun ve belge dosyasını seçin.');
        return;
    }
    
    // Belge tarihi kontrolü (son 3 ay)
    const docDate = new Date(documentDate);
    const threeMonthsAgo = new Date();
    threeMonthsAgo.setMonth(threeMonthsAgo.getMonth() - 3);
    
    if (docDate < threeMonthsAgo) {
        alert('Belge tarihi son 3 ay içinde olmalıdır.');
        return;
    }
    
    // FormData oluştur
    const formData = new FormData();
    formData.append('action', 'upload');
    formData.append('document_type', documentType);
    formData.append('address_line1', addressLine1);
    formData.append('address_line2', addressLine2);
    formData.append('city', city);
    formData.append('postal_code', postalCode);
    formData.append('country', country);
    formData.append('document_date', documentDate);
    formData.append('document_issuer', documentIssuer);
    formData.append('document', documentFile);
    
    // Loading göster
    const submitBtn = document.querySelector('#adresForm .btn-submit');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Gönderiliyor...';
    submitBtn.disabled = true;
    
    // API'ye gönder
    fetch('/api/address_verification.php?t=' + Date.now(), {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Adres belgesi başarıyla gönderildi! İnceleme süreci 24-48 saat sürmektedir.');
            clearAddressForm();
            
            // Otomatik kontrol sonuçlarını göster
            if (data.auto_check_results) {
                showAutoCheckResults(data.auto_check_results);
            }
        } else {
            alert('Hata: ' + (data.message || 'Belge gönderilemedi.'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu. Lütfen tekrar deneyin.');
    })
    .finally(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

function showAutoCheckResults(results) {
    let message = 'Otomatik Kontrol Sonuçları:\n\n';
    message += `Format Kontrolü: ${results.format_check ? '✓ Geçti' : '✗ Başarısız'}\n`;
    message += `Dosya Boyutu: ${results.file_size_check ? '✓ Uygun' : '✗ Uygun Değil'}\n`;
    message += `Metin Tanıma: ${results.text_recognition ? '✓ Başarılı' : '✗ Başarısız'}\n`;
    message += `Güven Skoru: ${results.overall_confidence}%\n\n`;
    
    if (results.overall_confidence >= 70) {
        message += 'Belgeniz otomatik kontrolleri başarıyla geçti!';
    } else {
        message += 'Belgeniz manuel incelemeye alınacaktır.';
    }
    
    alert(message);
}

// Form gönderimi
function submitKYCDocuments() {
    const kimlikOn = document.getElementById('kimlikOn').files[0];
    const kimlikArka = document.getElementById('kimlikArka').files[0];
    
    if (!kimlikOn || !kimlikArka) {
        alert('Lütfen hem kimlik ön yüzü hem de arka yüzü fotoğraflarını seçin.');
        return;
    }
    
    const formData = new FormData();
    formData.append('kimlik_on', kimlikOn);
    formData.append('kimlik_arka', kimlikArka);
    formData.append('action', 'upload_kyc');
    
    // Loading göster
    const submitBtn = document.querySelector('.btn-submit');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Gönderiliyor...';
    submitBtn.disabled = true;
    
    fetch('/profile/kyc_handler.php?t=' + Date.now(), {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Belgeleriniz başarıyla gönderildi! İnceleme süreci 24-48 saat sürmektedir.');
            // Formu temizle
            removeFile('kimlikOn', 'kimlikOnDisplay');
            removeFile('kimlikArka', 'kimlikArkaDisplay');
        } else {
            alert('Hata: ' + (data.message || 'Belgeler gönderilemedi.'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu. Lütfen tekrar deneyin.');
    })
    .finally(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

// Gelir Belgesi Fonksiyonları
function handleIncomeFileSelect() {
    const input = document.getElementById('incomeDocument');
    const display = document.getElementById('incomeDocumentDisplay');
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        // Dosya türü kontrolü
        const allowedTypes = ['application/pdf', 'image/jpeg', 'image/jpg', 'image/png'];
        if (!allowedTypes.includes(file.type)) {
            alert('Geçersiz dosya türü! Sadece PDF, JPG, PNG dosyaları kabul edilir.');
            input.value = '';
            return;
        }
        
        // Dosya boyutu kontrolü (10MB)
        if (file.size > 10 * 1024 * 1024) {
            alert('Dosya boyutu çok büyük! Maksimum 10MB olmalıdır.');
            input.value = '';
            return;
        }
        
        display.innerHTML = `
            <div class="file-info">
                <i class="fas fa-file-alt"></i>
                <div class="file-details">
                    <span class="file-name">${file.name}</span>
                    <span class="file-size">${(file.size / 1024 / 1024).toFixed(2)} MB</span>
                </div>
                <button type="button" class="remove-file" onclick="removeIncomeFile()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        display.style.display = 'block';
    }
}

function removeIncomeFile() {
    document.getElementById('incomeDocument').value = '';
    document.getElementById('incomeDocumentDisplay').style.display = 'none';
}

// Ek belgeler için fonksiyonlar
function handleAdditionalDocsSelect() {
    const input = document.getElementById('additionalDocuments');
    const display = document.getElementById('additionalDocsDisplay');
    
    if (input.files && input.files.length > 0) {
        let html = '';
        
        for (let i = 0; i < input.files.length; i++) {
            const file = input.files[i];
            
            // Dosya türü kontrolü
            const allowedTypes = ['application/pdf', 'image/jpeg', 'image/jpg', 'image/png'];
            if (!allowedTypes.includes(file.type)) {
                alert(`Geçersiz dosya türü: ${file.name}! Sadece PDF, JPG, PNG dosyaları kabul edilir.`);
                input.value = '';
                return;
            }
            
            // Dosya boyutu kontrolü (10MB)
            if (file.size > 10 * 1024 * 1024) {
                alert(`Dosya boyutu çok büyük: ${file.name}! Maksimum 10MB olmalıdır.`);
                input.value = '';
                return;
            }
            
            html += `
                <div class="file-info">
                    <i class="fas fa-file-alt"></i>
                    <div class="file-details">
                        <span class="file-name">${file.name}</span>
                        <span class="file-size">${(file.size / 1024 / 1024).toFixed(2)} MB</span>
                    </div>
                </div>
            `;
        }
        
        html += `
            <button type="button" class="remove-file" onclick="removeAdditionalFiles()">
                <i class="fas fa-times"></i> Tümünü Kaldır
            </button>
        `;
        
        display.innerHTML = html;
        display.style.display = 'block';
    }
}

function removeAdditionalFiles() {
    document.getElementById('additionalDocuments').value = '';
    document.getElementById('additionalDocsDisplay').style.display = 'none';
}

function clearIncomeForm() {
    // Form alanlarını temizle
    document.getElementById('incomeDocumentType').value = '';
    document.getElementById('employmentStatus').value = '';
    document.getElementById('monthlyIncome').value = '';
    document.getElementById('annualIncome').value = '';
    document.getElementById('incomeSource').value = '';
    document.getElementById('employerName').value = '';
    document.getElementById('incomeDocumentDate').value = '';
    document.getElementById('documentIssuer').value = '';
    document.getElementById('documentPeriodStart').value = '';
    document.getElementById('documentPeriodEnd').value = '';
    
    // Beyan kutularını temizle
    document.getElementById('incomeDeclaration').checked = false;
    document.getElementById('documentAuthenticity').checked = false;
    document.getElementById('privacyConsent').checked = false;
    
    // Dosyaları temizle
    removeIncomeFile();
    removeAdditionalFiles();
}

function submitIncomeVerification() {
    // Form verilerini al
    const documentType = document.getElementById('incomeDocumentType').value;
    const employmentStatus = document.getElementById('employmentStatus').value;
    const monthlyIncome = document.getElementById('monthlyIncome').value;
    const annualIncome = document.getElementById('annualIncome').value;
    const incomeSource = document.getElementById('incomeSource').value;
    const employerName = document.getElementById('employerName').value;
    const documentDate = document.getElementById('incomeDocumentDate').value;
    const documentIssuer = document.getElementById('documentIssuer').value;
    const documentPeriodStart = document.getElementById('documentPeriodStart').value;
    const documentPeriodEnd = document.getElementById('documentPeriodEnd').value;
    const documentFile = document.getElementById('incomeDocument').files[0];
    
    // Zorunlu alan kontrolü
    if (!documentType || !employmentStatus || !documentDate || !documentFile) {
        alert('Lütfen zorunlu alanları doldurun: Belge Türü, İstihdam Durumu, Belge Tarihi ve Dosya');
        return;
    }
    
    // Belge tarihi kontrolü (son 6 ay)
    const docDate = new Date(documentDate);
    const sixMonthsAgo = new Date();
    sixMonthsAgo.setMonth(sixMonthsAgo.getMonth() - 6);
    
    if (docDate < sixMonthsAgo) {
        alert('Belge tarihi son 6 ay içinde olmalıdır.');
        return;
    }
    
    // Gelir miktarı kontrolü
    if (monthlyIncome && parseFloat(monthlyIncome) <= 0) {
        alert('Geçerli bir aylık gelir miktarı girin.');
        return;
    }
    
    if (annualIncome && parseFloat(annualIncome) <= 0) {
        alert('Geçerli bir yıllık gelir miktarı girin.');
        return;
    }
    
    // Beyan kontrolü
    const incomeDeclaration = document.getElementById('incomeDeclaration').checked;
    const documentAuthenticity = document.getElementById('documentAuthenticity').checked;
    
    if (!incomeDeclaration || !documentAuthenticity) {
        alert('Lütfen zorunlu beyan kutularını işaretleyin.');
        return;
    }
    
    // FormData oluştur
    const formData = new FormData();
    formData.append('document_type', documentType);
    formData.append('employment_status', employmentStatus);
    formData.append('monthly_income', monthlyIncome);
    formData.append('annual_income', annualIncome);
    formData.append('income_source', incomeSource);
    formData.append('employer_name', employerName);
    formData.append('document_date', documentDate);
    formData.append('document_issuer', documentIssuer);
    formData.append('document_period_start', documentPeriodStart);
    formData.append('document_period_end', documentPeriodEnd);
    formData.append('document', documentFile);
    
    // Ek belgeleri ekle
    const additionalFiles = document.getElementById('additionalDocuments').files;
    for (let i = 0; i < additionalFiles.length; i++) {
        formData.append('additional_documents[]', additionalFiles[i]);
    }
    
    // Beyan bilgilerini ekle
    formData.append('income_declaration', incomeDeclaration);
    formData.append('document_authenticity', documentAuthenticity);
    formData.append('privacy_consent', document.getElementById('privacyConsent').checked);
    
    // Loading göster
    const submitBtn = document.querySelector('#incomeForm .btn-submit');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Gönderiliyor...';
    submitBtn.disabled = true;
    
    fetch('/api/income_verification.php?action=upload&t=' + Date.now(), {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Gelir belgeniz başarıyla gönderildi! Otomatik kontroller tamamlandı. İnceleme süreci 24-48 saat sürmektedir.');
            
            // Otomatik kontrol sonuçlarını göster
            if (data.data.auto_check_results) {
                showIncomeAutoCheckResults(data.data.auto_check_results);
            }
            
            // Formu temizle
            clearIncomeForm();
        } else {
            alert('Hata: ' + (data.error || 'Belge gönderilemedi.'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu. Lütfen tekrar deneyin.');
    })
    .finally(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}

function showIncomeAutoCheckResults(results) {
    let message = 'Otomatik Kontrol Sonuçları:\n\n';
    message += `Güven Skoru: ${results.confidence_score}/100\n`;
    message += `Risk Skoru: ${results.risk_score}/100\n\n`;
    
    if (results.warnings && results.warnings.length > 0) {
        message += 'Uyarılar:\n';
        results.warnings.forEach(warning => {
            message += `• ${warning}\n`;
        });
        message += '\n';
    }
    
    if (results.extracted_data) {
        message += 'Tespit Edilen Bilgiler:\n';
        if (results.extracted_data.detected_income) {
            message += `• Gelir Miktarı: ${results.extracted_data.detected_income} TL\n`;
        }
        if (results.extracted_data.detected_issuer) {
            message += `• Belge Düzenleyen: ${results.extracted_data.detected_issuer}\n`;
        }
        if (results.extracted_data.document_age) {
            message += `• Belge Yaşı: ${results.extracted_data.document_age}\n`;
        }
    }
    
    alert(message);
}

// Risk Durumu Fonksiyonları
let userRiskData = null;

// Sayfa yüklendiğinde risk durumunu getir
document.addEventListener('DOMContentLoaded', function() {
    loadUserRiskStatus();
});

// Kullanıcının risk durumunu yükle
async function loadUserRiskStatus() {
    try {
        const response = await fetch('/api/risk_based_kyc.php?action=get_user_risk&user_id=<?php echo $_SESSION["user_id"] ?? 0; ?>');
        const data = await response.json();
        
        if (data.success) {
            userRiskData = data.data;
            updateRiskStatusDisplay();
        } else {
            console.error('Risk durumu yüklenemedi:', data.message);
            // Varsayılan durumu göster
            updateRiskStatusDisplay({
                risk_level: 'unknown',
                current_risk_score: 0,
                last_updated: new Date().toISOString()
            });
        }
    } catch (error) {
        console.error('Risk durumu yükleme hatası:', error);
        // Hata durumunda varsayılan göster
        updateRiskStatusDisplay({
            risk_level: 'unknown',
            current_risk_score: 0,
            last_updated: new Date().toISOString()
        });
    }
}

// Risk durumu gösterimini güncelle
function updateRiskStatusDisplay(riskData = null) {
    const data = riskData || userRiskData;
    const badge = document.getElementById('risk-status-badge');
    
    if (!badge || !data) return;
    
    // Risk seviyesine göre badge'i güncelle
    const riskLevels = {
        'low': { text: 'Düşük Risk', class: 'low' },
        'medium': { text: 'Orta Risk', class: 'medium' },
        'high': { text: 'Yüksek Risk', class: 'high' },
        'critical': { text: 'Kritik Risk', class: 'critical' },
        'unknown': { text: 'Risk Değerlendiriliyor', class: '' }
    };
    
    const riskLevel = riskLevels[data.risk_level] || riskLevels['unknown'];
    
    // Mevcut sınıfları temizle
    badge.className = 'risk-status-badge';
    if (riskLevel.class) {
        badge.classList.add(riskLevel.class);
    }
    
    badge.textContent = `Risk Seviyesi: ${riskLevel.text}`;
}

// Risk detaylarını göster/gizle
function toggleRiskDetails() {
    const panel = document.getElementById('riskDetailsPanel');
    
    if (panel.style.display === 'none' || !panel.style.display) {
        showRiskDetails();
    } else {
        hideRiskDetails();
    }
}

// Risk detaylarını göster
async function showRiskDetails() {
    const panel = document.getElementById('riskDetailsPanel');
    
    if (!userRiskData) {
        await loadUserRiskStatus();
    }
    
    if (userRiskData) {
        updateRiskDetailsContent();
        panel.style.display = 'block';
    }
}

// Risk detaylarını gizle
function hideRiskDetails() {
    const panel = document.getElementById('riskDetailsPanel');
    panel.style.display = 'none';
}

// Risk detayları içeriğini güncelle
async function updateRiskDetailsContent() {
    if (!userRiskData) return;
    
    // Risk skoru gösterimi
    updateRiskScoreDisplay();
    
    // Gerekli doğrulamaları yükle
    await loadRiskRequirements();
    
    // Aktif uyarıları yükle
    await loadRiskAlerts();
}

// Risk skoru gösterimini güncelle
function updateRiskScoreDisplay() {
    const scoreCircle = document.querySelector('.risk-score-circle');
    const scoreInfo = document.querySelector('.risk-score-info');
    
    if (!scoreCircle || !scoreInfo || !userRiskData) return;
    
    const score = userRiskData.current_risk_score || 0;
    const riskLevel = userRiskData.risk_level || 'unknown';
    const lastUpdated = new Date(userRiskData.last_updated).toLocaleDateString('tr-TR');
    
    // Skor dairesini güncelle
    scoreCircle.innerHTML = `
        <span>${score}</span>
        <small>/ 100</small>
    `;
    
    // Risk seviyesine göre renk
    const riskColors = {
        'low': 'linear-gradient(135deg, #4CAF50 0%, #45a049 100%)',
        'medium': 'linear-gradient(135deg, #FF9800 0%, #F57C00 100%)',
        'high': 'linear-gradient(135deg, #FF5722 0%, #D32F2F 100%)',
        'critical': 'linear-gradient(135deg, #9C27B0 0%, #7B1FA2 100%)'
    };
    
    if (riskColors[riskLevel]) {
        scoreCircle.style.background = riskColors[riskLevel];
    }
    
    // Bilgi alanını güncelle
    scoreInfo.innerHTML = `
        <p><strong>Risk Seviyesi:</strong> ${getRiskLevelText(riskLevel)}</p>
        <p><strong>Son Güncelleme:</strong> ${lastUpdated}</p>
        <p><strong>Toplam Uyarı:</strong> ${userRiskData.total_alerts_generated || 0}</p>
        <p><strong>Doğrulanmış Tehdit:</strong> ${userRiskData.confirmed_threats || 0}</p>
    `;
}

// Risk seviyesi metnini al
function getRiskLevelText(level) {
    const texts = {
        'low': 'Düşük Risk',
        'medium': 'Orta Risk', 
        'high': 'Yüksek Risk',
        'critical': 'Kritik Risk',
        'unknown': 'Değerlendiriliyor'
    };
    return texts[level] || 'Bilinmiyor';
}

// Risk gereksinimlerini yükle
async function loadRiskRequirements() {
    try {
        const response = await fetch(`/api/risk_based_kyc.php?action=get_risk_requirements&risk_level=${userRiskData.risk_level}`);
        const data = await response.json();
        
        if (data.success && data.data) {
            updateRiskRequirementsDisplay(data.data);
        }
    } catch (error) {
        console.error('Risk gereksinimleri yüklenemedi:', error);
    }
}

// Risk gereksinimlerini göster
function updateRiskRequirementsDisplay(requirements) {
    const container = document.querySelector('.risk-requirements ul');
    if (!container) return;
    
    container.innerHTML = '';
    
    if (!requirements || requirements.length === 0) {
        container.innerHTML = '<li><i class="fas fa-check requirement-completed"></i> Tüm gereksinimler karşılandı</li>';
        return;
    }
    
    requirements.forEach(req => {
        const li = document.createElement('li');
        const status = getRequirementStatus(req.requirement_type);
        
        li.innerHTML = `
            <i class="fas fa-${status.icon} ${status.class}"></i>
            ${req.description}
        `;
        
        container.appendChild(li);
    });
}

// Gereksinim durumunu kontrol et
function getRequirementStatus(type) {
    // Bu fonksiyon kullanıcının mevcut KYC durumuna göre gereksinim durumunu kontrol eder
    const statuses = {
        'identity_verification': { icon: 'check', class: 'requirement-completed' },
        'address_verification': { icon: 'clock', class: 'requirement-pending' },
        'income_verification': { icon: 'times', class: 'requirement-required' },
        'enhanced_due_diligence': { icon: 'exclamation', class: 'requirement-required' }
    };
    
    return statuses[type] || { icon: 'question', class: 'requirement-pending' };
}

// Risk uyarılarını yükle
async function loadRiskAlerts() {
    try {
        const response = await fetch(`/api/risk_based_kyc.php?action=get_user_alerts&user_id=<?php echo $_SESSION["user_id"] ?? 0; ?>`);
        const data = await response.json();
        
        if (data.success) {
            updateRiskAlertsDisplay(data.data || []);
        }
    } catch (error) {
        console.error('Risk uyarıları yüklenemedi:', error);
    }
}

// Risk uyarılarını göster
function updateRiskAlertsDisplay(alerts) {
    const container = document.querySelector('.risk-alerts');
    if (!container) return;
    
    const alertsContent = container.querySelector('.alerts-content') || container;
    
    if (!alerts || alerts.length === 0) {
        alertsContent.innerHTML = `
            <h5>Aktif Uyarılar</h5>
            <p style="color: #28a745; font-style: italic;">Aktif uyarı bulunmuyor</p>
        `;
        return;
    }
    
    let alertsHtml = '<h5>Aktif Uyarılar</h5>';
    
    alerts.forEach(alert => {
        const alertDate = new Date(alert.created_at).toLocaleDateString('tr-TR');
        alertsHtml += `
            <div class="alert-item ${alert.severity}">
                <strong>${alert.alert_type}:</strong> ${alert.message}
                <br><small>Tarih: ${alertDate}</small>
            </div>
        `;
    });
    
    alertsContent.innerHTML = alertsHtml;
}

// Risk değerlendirmesini yenile
async function refreshRiskAssessment() {
    try {
        const response = await fetch('/api/risk_based_kyc.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                action: 'assess_user_risk',
                user_id: <?php echo $_SESSION["user_id"] ?? 0; ?>
            })
        });
        
        const data = await response.json();
        
        if (data.success) {
            // Risk durumunu yeniden yükle
            await loadUserRiskStatus();
            
            // Detaylar açıksa güncelle
            const panel = document.getElementById('riskDetailsPanel');
            if (panel.style.display === 'block') {
                await updateRiskDetailsContent();
            }
            
            // Başarı mesajı
            if (window.Swal) {
                Swal.fire({
                    icon: 'success',
                    title: 'Risk Değerlendirmesi Güncellendi',
                    text: 'Risk durumunuz başarıyla yenilendi.',
                    timer: 3000,
                    showConfirmButton: false
                });
            }
        } else {
            throw new Error(data.message || 'Risk değerlendirmesi güncellenemedi');
        }
    } catch (error) {
        console.error('Risk değerlendirmesi güncelleme hatası:', error);
        
        if (window.Swal) {
            Swal.fire({
                icon: 'error',
                title: 'Hata',
                text: 'Risk değerlendirmesi güncellenirken bir hata oluştu.'
            });
        }
    }
}
</script>
                      
                            </div><!----><!---->
                        </div>
                    </div>
                </div>
            </div>
        </div><!---->
    </app-all-player-kyc></app-player-kyc>
