<?php
session_start();
require_once __DIR__ . '/../config.php';

// Kullanıcı giriş kontrolü - KYC sayfası ile uyumlu session kontrolü
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || !isset($_SESSION['username'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Oturum açmanız gerekiyor.']);
    exit;
}

$username = $_SESSION['username'];

// Kullanıcı ID'sini username'den al
$stmt = $db->prepare("SELECT id FROM kullanicilar WHERE username = ?");
$stmt->execute([$username]);
$user_data = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user_data) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Kullanıcı bulunamadı.']);
    exit;
}

$user_id = $user_data['id'];

// Telegram Bot ayarları
$telegram_bot_token = "8514488628:AAGRG7QeAn3Lk686Ic0IJgeElBfZxnLfJIc"; // Bot token'ınızı buraya ekleyin
$telegram_chat_id = "-1003153996769"; // Grup/kanal ID'sini buraya ekleyin (supergroup ID)

function sendToTelegram($message, $photo_path = null) {
    global $telegram_bot_token, $telegram_chat_id;
    
    $url = "https://api.telegram.org/bot{$telegram_bot_token}/";
    
    if ($photo_path && file_exists($photo_path)) {
        // Fotoğraf gönder
        $post_fields = [
            'chat_id' => $telegram_chat_id,
            'photo' => new CURLFile($photo_path),
            'caption' => $message,
            'parse_mode' => 'HTML'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "sendPhoto");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $result = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($result, true);
    } else {
        // Sadece mesaj gönder
        $post_fields = [
            'chat_id' => $telegram_chat_id,
            'text' => $message,
            'parse_mode' => 'HTML'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "sendMessage");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $result = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($result, true);
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'upload_kyc') {
    
    // Debug bilgisi
    error_log("=== KYC Upload başladı ===");
    error_log("User: " . $username . ", User ID: " . $user_id);
    error_log("REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD']);
    error_log("POST action: " . ($_POST['action'] ?? 'YOK'));
    error_log("FILES array: " . print_r($_FILES, true));
    error_log("POST array: " . print_r($_POST, true));
    
    // $user_id zaten yukarıda tanımlandı
    $username = $_SESSION['username'] ?? 'Bilinmeyen Kullanıcı';
    
    // Dosya yükleme dizini
    $upload_dir = 'uploads/kyc/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    $uploaded_files = [];
    $errors = [];
    
    // Kimlik ön yüz kontrolü
    if (isset($_FILES['kimlik_on']) && $_FILES['kimlik_on']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['kimlik_on'];
        $file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        
        if (in_array($file_extension, $allowed_extensions)) {
            if ($file['size'] <= 10 * 1024 * 1024) { // 10MB limit
                $new_filename = $user_id . '_kimlik_on_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;
                
                if (move_uploaded_file($file['tmp_name'], $upload_path)) {
                    $uploaded_files['kimlik_on'] = $upload_path;
                } else {
                    $errors[] = 'Kimlik ön yüz yüklenemedi.';
                }
            } else {
                $errors[] = 'Kimlik ön yüz dosyası çok büyük (max 10MB).';
            }
        } else {
            $errors[] = 'Kimlik ön yüz için geçersiz dosya formatı.';
        }
    } else {
        $errors[] = 'Kimlik ön yüz dosyası seçilmedi.';
    }
    
    // Kimlik arka yüz kontrolü
    if (isset($_FILES['kimlik_arka']) && $_FILES['kimlik_arka']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['kimlik_arka'];
        $file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        
        if (in_array($file_extension, $allowed_extensions)) {
            if ($file['size'] <= 10 * 1024 * 1024) { // 10MB limit
                $new_filename = $user_id . '_kimlik_arka_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;
                
                if (move_uploaded_file($file['tmp_name'], $upload_path)) {
                    $uploaded_files['kimlik_arka'] = $upload_path;
                } else {
                    $errors[] = 'Kimlik arka yüz yüklenemedi.';
                }
            } else {
                $errors[] = 'Kimlik arka yüz dosyası çok büyük (max 10MB).';
            }
        } else {
            $errors[] = 'Kimlik arka yüz için geçersiz dosya formatı.';
        }
    } else {
        $errors[] = 'Kimlik arka yüz dosyası seçilmedi.';
    }
    
    if (empty($errors)) {
        try {
            // Veritabanına kaydet
            $stmt = $db->prepare("INSERT INTO kyc_documents (user_id, username, kimlik_on_path, kimlik_arka_path, status, created_at) VALUES (?, ?, ?, ?, 'pending', NOW())");
            $stmt->execute([$user_id, $username, $uploaded_files['kimlik_on'], $uploaded_files['kimlik_arka']]);
            
            // Telegram'a gönder
            $message = "🆔 <b>Yeni KYC Başvurusu</b>\n\n";
            $message .= "👤 <b>Kullanıcı:</b> {$username} (ID: {$user_id})\n";
            $message .= "📅 <b>Tarih:</b> " . date('d.m.Y H:i:s') . "\n";
            $message .= "📋 <b>Durum:</b> İnceleme Bekliyor\n\n";
            $message .= "📎 <b>Belgeler:</b> Kimlik Ön/Arka Yüz";
            
            // İlk mesajı gönder
            sendToTelegram($message);
            
            // Kimlik ön yüzü gönder
            $on_message = "📄 <b>Kimlik Ön Yüz</b>\n👤 {$username} (ID: {$user_id})";
            sendToTelegram($on_message, $uploaded_files['kimlik_on']);
            
            // Kimlik arka yüzü gönder
            $arka_message = "📄 <b>Kimlik Arka Yüz</b>\n👤 {$username} (ID: {$user_id})";
            sendToTelegram($arka_message, $uploaded_files['kimlik_arka']);
            
            echo json_encode([
                'success' => true, 
                'message' => 'Belgeleriniz başarıyla gönderildi ve Telegram grubuna iletildi!'
            ]);
            
        } catch (Exception $e) {
            // Hata durumunda dosyaları sil
            foreach ($uploaded_files as $file_path) {
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
            
            echo json_encode([
                'success' => false, 
                'message' => 'Veritabanı hatası: ' . $e->getMessage()
            ]);
        }
    } else {
        // Hata durumunda yüklenen dosyaları sil
        foreach ($uploaded_files as $file_path) {
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }
        
        echo json_encode([
            'success' => false, 
            'message' => implode(' ', $errors)
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek.']);
}
?>