<?php
// Session kontrolü
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Kullanıcı giriş kontrolü
if (!isset($_SESSION['user_id']) || !isset($_SESSION['username'])) {
    header("Location: ../giris.php");
    exit;
}

// Mevcut sayfayı belirle
$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>

<aside class="sidebarMain playersidebarMain">
        <div class="profile-content">
            <div class="edit-user">
                <span class="avatar-holder ng-tns-c27-2 ng-star-inserted"><?php echo strtoupper(substr($_SESSION['username'], 0, 1)); ?></span>
                <div class="user-right">
                    <span class="username ng-tns-c27-2 ng-star-inserted"><?php echo htmlspecialchars($_SESSION['username']); ?></span>
                </div>
            </div>
        
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const isLoggedIn = <?php echo json_encode(isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true); ?>;

                if (isLoggedIn) {
                    fetch('../api/balanceapi')
                        .then(response => response.json())
                        .then(data => {
                            const balanceText = document.querySelector('.amount');
                            if (data.status === 'success') {
                                balanceText.textContent = data.ana_bakiye + ' ₺';
                            } else {
                                console.error(data.message);
                            }
                        })
                        .catch(error => {
                            console.error('Hata:', error);
                        });
                }
            });
        </script>
        
        <div class="main-balance">
            <div class="total-balance">
                <div class="user-balance">
                    <span class="balance-title">Ana Bakiye</span>
                    <span class="amount ng-tns-c27-2 ng-star-inserted">0 ₺</span>
                </div>
                <i class="fa-solid fa-eye eye-icon ng-tns-c27-2 ng-star-inserted"></i>
            </div>
            
            <div class="buttons-bottom">
                <a class="btn deposit-bc" href="/profile/deposit-withdraw">
                    <i class="fa-solid fa-wallet"></i> Para Yatır
                </a>
                <a class="btn withdraw-bc" href="/profile/deposit-withdraw">
                    <img class="ng-tns-c27-2" alt="" src="/assets/images/withdraw-icon.png"> Para Çekme
                </a>
            </div>
        </div>
        
        <div class="main-balance bonus">
            <div class="user-balance">
                <span class="balance-title">Bonus Bakiyesi</span>
                <span class="amount ng-tns-c27-2 ng-star-inserted">0 ₺</span>
            </div>
        </div>
    </div>
    
    <div class="sideSports scrollable-menu">
        <ul class="ng-tns-c27-2">
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'account-details') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/account-details">Profilim</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'changePassword') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/changePassword">Şifre Değiştir</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'account-statement') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/account-statement">İşlem Geçmişi</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'bet-history') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/bet-history">Casino Geçmişi</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'bonuses') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/bonuses">Bonuslarım</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'loyalty') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/loyalty">Sadakat Programı</a>
            </li>
            
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'sessions') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/sessions">Oturum Yönetimi</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'referral') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/referral">Referans Programı</a>
            </li>
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'responsible_gaming') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/responsible_gaming">Sorumlu Oyun</a>
            </li>
            
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <span class="ng-tns-c27-2" aria-disabled="true" style="cursor: default;" type="GROUP"></span>
            </li>
            
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2" href="/promotions.php" style="cursor: pointer;" type="GROUP">Promosyonlar</a>
            </li>
            
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'deposit-withdraw') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/deposit-withdraw">Para Yatırma/Para Çekme</a>
            </li>
            
            <li style="display: list-item;" class="ng-tns-c27-2 ng-star-inserted">
                <a class="ng-tns-c27-2 <?php echo ($current_page == 'kyc') ? 'select active' : ''; ?>" 
                   style="cursor: pointer" type="GROUP" href="/profile/kyc">KYC</a>
            </li>
        </ul>
    </div>
    
    <style>
        .playersidebarMain {
            background: var(--darkBG, #1a1a1a);
            border-right: 1px solid rgba(255, 255, 255, 0.1);
            height: 100vh;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            position: sticky;
            top: 0;
        }
        
        .profile-content {
            flex-shrink: 0;
            padding: 15px;
            padding-bottom: 10px;
        }
        
        .scrollable-menu {
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
            padding: 0 15px 15px 15px;
        }
        
        .scrollable-menu::-webkit-scrollbar {
            width: 6px;
        }
        
        .scrollable-menu::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 3px;
        }
        
        .scrollable-menu::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
        }
        
        .scrollable-menu::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.5);
        }
        
        /* Firefox scrollbar */
        .scrollable-menu {
            scrollbar-width: thin;
            scrollbar-color: rgba(255, 255, 255, 0.3) rgba(255, 255, 255, 0.1);
        }
        
        /* Mobil responsive */
        @media (max-width: 768px) {
            .playersidebarMain {
                position: fixed;
                top: 0;
                left: 0;
                width: 280px;
                z-index: 1000;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }
            
            .playersidebarMain.mobile-open {
                transform: translateX(0);
            }
            
            /* Mobil menü toggle butonu */
            .mobile-menu-toggle {
                position: fixed;
                top: 15px;
                left: 15px;
                z-index: 1001;
                background: var(--primary, #e5b645);
                color: #000;
                border: none;
                padding: 10px;
                border-radius: 5px;
                cursor: pointer;
                display: block;
            }
            
            @media (min-width: 769px) {
                .mobile-menu-toggle {
                    display: none;
                }
            }
        }
    </style>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Mobil menü toggle
            if (window.innerWidth <= 768) {
                const toggleBtn = document.createElement('button');
                toggleBtn.className = 'mobile-menu-toggle';
                toggleBtn.innerHTML = '<i class="fa-solid fa-bars"></i>';
                toggleBtn.onclick = function() {
                    const sidebar = document.querySelector('.playersidebarMain');
                    sidebar.classList.toggle('mobile-open');
                };
                document.body.appendChild(toggleBtn);
                
                // Sidebar dışına tıklandığında mobilde kapat
                document.addEventListener('click', function(e) {
                    const sidebar = document.querySelector('.playersidebarMain');
                    const toggleBtn = document.querySelector('.mobile-menu-toggle');
                    
                    if (!sidebar.contains(e.target) && 
                        !toggleBtn.contains(e.target)) {
                        sidebar.classList.remove('mobile-open');
                    }
                });
            }
        });
    </script>
</aside>