# Telegram Bot Kurulum Rehberi

## 1. Telegram Bot Oluşturma

1. Telegram'da @BotFather'ı bulun ve `/start` yazın
2. `/newbot` komutunu gönderin
3. Bot için bir isim verin (örnek: KYC Belgeler Bot)
4. Bot için bir kullanıcı adı verin (örnek: kyc_belgeler_bot)
5. BotFather size bir token verecek (örnek: 123456789:ABCdefGHIjklMNOpqrsTUVwxyz)

## 2. Telegram Grubu/Kanalı Hazırlama

1. Yeni bir grup oluşturun veya mevcut grubu kullanın
2. Botu gruba ekleyin
3. Bota admin yetkisi verin (mesaj gönderme yetkisi)
4. Grup ID'sini almak için @userinfobot'u gruba ekleyin ve grup ID'sini alın

## 3. Kod Ayarları

`kyc_handler.php` dosyasında aşağıdaki satırları düzenleyin:

```php
$telegram_bot_token = "123456789:ABCdefGHIjklMNOpqrsTUVwxyz"; // BotFather'dan aldığınız token
$telegram_chat_id = "-1001234567890"; // Grup ID'si (- işareti ile başlar)
```

## 4. Veritabanı Tablosu Oluşturma

`kyc_table.sql` dosyasındaki SQL kodunu çalıştırın:

```sql
-- phpMyAdmin'de veya MySQL komut satırında çalıştırın
```

## 5. Test Etme

1. KYC sayfasına gidin
2. Kimlik belgelerini seçin
3. "Belgeleri Gönder" butonuna tıklayın
4. Telegram grubunda belgelerin geldiğini kontrol edin

## 6. Güvenlik Notları

- Bot token'ını kimseyle paylaşmayın
- Grup ID'sini gizli tutun
- uploads klasöründe .htaccess dosyası bulunduğundan emin olun
- Dosya boyutu limitleri: 10MB
- Desteklenen formatlar: JPG, JPEG, PNG, GIF, WEBP

## 7. Sorun Giderme

### Bot mesaj gönderemiyor:
- Bot admin yetkisine sahip mi kontrol edin
- Chat ID doğru mu kontrol edin
- Bot token doğru mu kontrol edin

### Dosyalar yüklenmiyor:
- uploads klasörü yazma yetkisine sahip mi kontrol edin
- PHP upload_max_filesize ayarını kontrol edin
- .htaccess dosyası doğru mu kontrol edin

### Veritabanı hatası:
- Tablo oluşturuldu mu kontrol edin
- Veritabanı bağlantısı çalışıyor mu kontrol edin
- config.php dosyası doğru mu kontrol edin